/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.jdbc;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.Consumer;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.core.Subscription;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.BaseDAOImpl;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.ConsumerDAO;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DBManager;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.Util;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsserver.util.ConsumerAlreadyAddedException;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

class ConsumerDAOImpl
extends BaseDAOImpl
implements ConsumerDAO {
    private final String tableName;
    private final String insertSQL;
    private final String insertNoDupSQL;
    private final String deleteSQL;
    private final String selectSQL;
    private final String selectAllSQL;
    private final String selectExistSQL;
    private final String selectExistByIDSQL;

    ConsumerDAOImpl() throws BrokerException {
        DBManager dbMgr = DBManager.getDBManager();
        this.tableName = dbMgr.getTableName("MQCON41");
        this.insertSQL = new StringBuilder(128).append("INSERT INTO ").append(this.tableName).append(" ( ").append("ID").append(", ").append("CONSUMER").append(", ").append("DURABLE_NAME").append(", ").append("CLIENT_ID").append(", ").append("CREATED_TS").append(") VALUES ( ?, ?, ?, ?, ? )").toString();
        this.insertNoDupSQL = new StringBuilder(128).append("INSERT INTO ").append(this.tableName).append(" ( ").append("ID").append(", ").append("CONSUMER").append(", ").append("DURABLE_NAME").append(", ").append("CLIENT_ID").append(", ").append("CREATED_TS").append(" ) SELECT ?, ?, ?, ?, ? FROM ").append(this.tableName).append(" WHERE ").append("DURABLE_NAME").append(" = ? ").append(" AND ").append("CLIENT_ID").append(" = ? ").append(" HAVING COUNT(*) ").append(" = 0 ").toString();
        this.deleteSQL = new StringBuilder(128).append("DELETE FROM ").append(this.tableName).append(" WHERE ").append("ID").append(" = ?").toString();
        this.selectSQL = new StringBuilder(128).append("SELECT ").append("CONSUMER").append(" FROM ").append(this.tableName).append(" WHERE ").append("ID").append(" = ?").toString();
        this.selectAllSQL = new StringBuilder(128).append("SELECT ").append("CONSUMER").append(" FROM ").append(this.tableName).toString();
        this.selectExistSQL = new StringBuilder(128).append("SELECT ").append("CONSUMER").append(" FROM ").append(this.tableName).append(" WHERE ").append("DURABLE_NAME").append(" = ?").append(" AND ").append("CLIENT_ID").append(" = ?").toString();
        this.selectExistByIDSQL = new StringBuilder(128).append("SELECT ").append("CONSUMER").append(" FROM ").append(this.tableName).append(" WHERE ").append("ID").append(" = ?").toString();
    }

    @Override
    public final String getTableNamePrefix() {
        return "MQCON41";
    }

    @Override
    public String getTableName() {
        return this.tableName;
    }

    @Override
    public void insert(Connection conn, Consumer consumer, long createdTS) throws BrokerException {
        block20: {
            Exception myex;
            PreparedStatement pstmt;
            block19: {
                ConsumerUID consumerUID = consumer.getConsumerUID();
                String durableName = null;
                String clientID = null;
                if (consumer instanceof Subscription) {
                    Subscription sub = (Subscription)consumer;
                    durableName = sub.getDurableName();
                    clientID = sub.getClientID();
                }
                boolean myConn = false;
                String sql = this.insertSQL;
                pstmt = null;
                myex = null;
                try {
                    Consumer tmpc;
                    DBManager dbMgr = DBManager.getDBManager();
                    if (conn == null) {
                        conn = dbMgr.getConnection(true);
                        myConn = true;
                    }
                    if ((tmpc = this.checkConsumer(conn, consumer, true)) != null) {
                        this.throwConflictException(tmpc, consumer);
                    }
                    if (durableName != null && (tmpc = this.checkConsumer(conn, consumer, false)) != null) {
                        this.throwConflictException(tmpc, consumer);
                    }
                    if (durableName != null && !dbMgr.isHADB() && !dbMgr.isDB2()) {
                        sql = this.insertNoDupSQL;
                    }
                    pstmt = DBManager.createPreparedStatement(conn, sql);
                    pstmt.setLong(1, consumerUID.longValue());
                    Util.setObject(pstmt, 2, consumer);
                    Util.setString(pstmt, 3, durableName);
                    Util.setString(pstmt, 4, clientID, false);
                    pstmt.setLong(5, createdTS);
                    if (durableName != null && !dbMgr.isHADB() && !dbMgr.isDB2()) {
                        Util.setString(pstmt, 6, durableName);
                        Util.setString(pstmt, 7, clientID, false);
                    }
                    if (pstmt.executeUpdate() == 0) {
                        tmpc = this.checkConsumer(conn, consumer, true);
                        if (tmpc != null) {
                            this.throwConflictException(tmpc, consumer);
                        }
                        if (durableName != null && (tmpc = this.checkConsumer(conn, consumer, false)) != null) {
                            this.throwConflictException(tmpc, consumer);
                        }
                        throw new BrokerException(this.br.getKString("B4012", consumerUID));
                    }
                    if (!myConn) break block19;
                }
                catch (Exception e) {
                    try {
                        myex = e;
                        try {
                            if (conn != null && !conn.getAutoCommit()) {
                                conn.rollback();
                            }
                        }
                        catch (SQLException rbe) {
                            this.logger.log(32, "B4080", rbe);
                        }
                        if (e instanceof BrokerException) {
                            throw (BrokerException)e;
                        }
                        Exception ex = e instanceof IOException ? DBManager.wrapIOException("[" + sql + "]", (IOException)e) : (e instanceof SQLException ? DBManager.wrapSQLException("[" + sql + "]", (SQLException)e) : e);
                        throw new BrokerException(this.br.getKString("B4012", consumerUID), ex);
                    }
                    catch (Throwable throwable) {
                        if (myConn) {
                            Util.close(null, pstmt, conn, myex);
                        } else {
                            Util.close(null, pstmt, null, myex);
                        }
                        throw throwable;
                    }
                }
                Util.close(null, pstmt, conn, myex);
                break block20;
            }
            Util.close(null, pstmt, null, myex);
        }
    }

    private void throwConflictException(Consumer existc, Consumer c) throws BrokerException {
        if (existc instanceof Subscription && c instanceof Subscription) {
            Subscription existsub = (Subscription)existc;
            Subscription sub = (Subscription)c;
            if (existsub.getShared() != sub.getShared() || existsub.getJMSShared() != sub.getJMSShared()) {
                throw new BrokerException(this.br.getKString("B4392", "[" + existsub.getDSubLongLogString() + "]" + existsub, existsub.getDestinationUID()), 409);
            }
            throw new ConsumerAlreadyAddedException(this.br.getKString("B4392", "[" + existsub.getDSubLongLogString() + "]" + existsub, existsub.getDestinationUID()));
        }
        throw new ConsumerAlreadyAddedException(this.br.getKString("B3010", "[" + existc + "]", existc.getDestinationUID()));
    }

    @Override
    public void delete(Connection conn, Consumer consumer) throws BrokerException {
        boolean deleted;
        ConsumerUID consumerUID;
        block14: {
            Exception myex;
            PreparedStatement pstmt;
            block13: {
                consumerUID = consumer.getConsumerUID();
                deleted = false;
                boolean myConn = false;
                pstmt = null;
                myex = null;
                try {
                    DBManager dbMgr = DBManager.getDBManager();
                    if (conn == null) {
                        conn = dbMgr.getConnection(true);
                        myConn = true;
                    }
                    pstmt = DBManager.createPreparedStatement(conn, this.deleteSQL);
                    pstmt.setLong(1, consumerUID.longValue());
                    if (pstmt.executeUpdate() > 0) {
                        deleted = true;
                    }
                    if (!myConn) break block13;
                }
                catch (Exception e) {
                    try {
                        myex = e;
                        try {
                            if (conn != null && !conn.getAutoCommit()) {
                                conn.rollback();
                            }
                        }
                        catch (SQLException rbe) {
                            this.logger.log(32, "B4080", rbe);
                        }
                        if (e instanceof BrokerException) {
                            throw (BrokerException)e;
                        }
                        Exception ex = e instanceof SQLException ? DBManager.wrapSQLException("[" + this.deleteSQL + "]", (SQLException)e) : e;
                        throw new BrokerException(this.br.getKString("B4034", consumerUID), ex);
                    }
                    catch (Throwable throwable) {
                        if (myConn) {
                            Util.close(null, pstmt, conn, myex);
                        } else {
                            Util.close(null, pstmt, null, myex);
                        }
                        throw throwable;
                    }
                }
                Util.close(null, pstmt, conn, myex);
                break block14;
            }
            Util.close(null, pstmt, null, myex);
        }
        if (!deleted) {
            DestinationUID destinationUID = consumer.getDestinationUID();
            throw new BrokerException(this.br.getKString("B3011", consumerUID, destinationUID), 404);
        }
    }

    @Override
    public void deleteAll(Connection conn) throws BrokerException {
        if (Globals.getHAEnabled()) {
            return;
        }
        super.deleteAll(conn);
    }

    @Override
    public Consumer getConsumer(Connection conn, ConsumerUID consumerUID) throws BrokerException {
        Consumer consumer;
        block15: {
            Exception myex;
            ResultSet rs;
            PreparedStatement pstmt;
            block14: {
                consumer = null;
                boolean myConn = false;
                pstmt = null;
                rs = null;
                myex = null;
                try {
                    DBManager dbMgr = DBManager.getDBManager();
                    if (conn == null) {
                        conn = dbMgr.getConnection(true);
                        myConn = true;
                    }
                    pstmt = DBManager.createPreparedStatement(conn, this.selectSQL);
                    pstmt.setLong(1, consumerUID.longValue());
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        try {
                            consumer = (Consumer)Util.readObject(rs, 1);
                        }
                        catch (IOException e) {
                            this.logger.logStack(32, "B4125", e);
                        }
                    }
                    if (!myConn) break block14;
                }
                catch (Exception e) {
                    try {
                        myex = e;
                        try {
                            if (conn != null && !conn.getAutoCommit()) {
                                conn.rollback();
                            }
                        }
                        catch (SQLException rbe) {
                            this.logger.log(32, "B4080", rbe);
                        }
                        if (e instanceof BrokerException) {
                            throw (BrokerException)e;
                        }
                        Exception ex = e instanceof SQLException ? DBManager.wrapSQLException("[" + this.selectSQL + "]", (SQLException)e) : e;
                        throw new BrokerException(this.br.getKString("B4013", consumerUID), ex);
                    }
                    catch (Throwable throwable) {
                        if (myConn) {
                            Util.close(rs, pstmt, conn, myex);
                        } else {
                            Util.close(rs, pstmt, null, myex);
                        }
                        throw throwable;
                    }
                }
                Util.close(rs, pstmt, conn, myex);
                break block15;
            }
            Util.close(rs, pstmt, null, myex);
        }
        return consumer;
    }

    @Override
    public List getAllConsumers(Connection conn) throws BrokerException {
        ArrayList<Consumer> list;
        block15: {
            Exception myex;
            ResultSet rs;
            PreparedStatement pstmt;
            block14: {
                list = new ArrayList<Consumer>();
                boolean myConn = false;
                pstmt = null;
                rs = null;
                myex = null;
                try {
                    DBManager dbMgr = DBManager.getDBManager();
                    if (conn == null) {
                        conn = dbMgr.getConnection(true);
                        myConn = true;
                    }
                    pstmt = DBManager.createPreparedStatement(conn, this.selectAllSQL);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        try {
                            Consumer consumer = (Consumer)Util.readObject(rs, 1);
                            list.add(consumer);
                        }
                        catch (IOException e) {
                            this.logger.logStack(32, "B4125", e);
                        }
                    }
                    if (!myConn) break block14;
                }
                catch (Exception e) {
                    try {
                        myex = e;
                        try {
                            if (conn != null && !conn.getAutoCommit()) {
                                conn.rollback();
                            }
                        }
                        catch (SQLException rbe) {
                            this.logger.log(32, "B4080", rbe);
                        }
                        if (e instanceof BrokerException) {
                            throw (BrokerException)e;
                        }
                        Exception ex = e instanceof SQLException ? DBManager.wrapSQLException("[" + this.selectAllSQL + "]", (SQLException)e) : e;
                        throw new BrokerException(this.br.getKString("B4035"), ex);
                    }
                    catch (Throwable throwable) {
                        if (myConn) {
                            Util.close(rs, pstmt, conn, myex);
                        } else {
                            Util.close(rs, pstmt, null, myex);
                        }
                        throw throwable;
                    }
                }
                Util.close(rs, pstmt, conn, myex);
                break block15;
            }
            Util.close(rs, pstmt, null, myex);
        }
        return list;
    }

    private Consumer checkConsumer(Connection conn, Consumer consumer, boolean byId) throws BrokerException {
        Consumer c2;
        block19: {
            Exception myex;
            ResultSet rs;
            PreparedStatement pstmt;
            block17: {
                String sql;
                boolean myConn;
                ConsumerUID consumerUID;
                block15: {
                    Consumer consumer2;
                    block18: {
                        block16: {
                            Consumer c2;
                            consumerUID = consumer.getConsumerUID();
                            myConn = false;
                            sql = this.selectExistByIDSQL;
                            pstmt = null;
                            rs = null;
                            myex = null;
                            DBManager dbMgr = DBManager.getDBManager();
                            if (conn == null) {
                                conn = dbMgr.getConnection(true);
                                myConn = true;
                            }
                            if (!byId) {
                                sql = this.selectExistSQL;
                            }
                            pstmt = DBManager.createPreparedStatement(conn, sql);
                            if (byId) {
                                pstmt.setLong(1, consumerUID.longValue());
                            } else {
                                Util.setString(pstmt, 1, ((Subscription)consumer).getDurableName());
                                Util.setString(pstmt, 2, ((Subscription)consumer).getClientID(), false);
                            }
                            rs = pstmt.executeQuery();
                            if (!rs.next()) break block15;
                            consumer2 = c2 = (Consumer)Util.readObject(rs, 1);
                            if (!myConn) break block16;
                            Util.close(rs, pstmt, conn, myex);
                            break block18;
                        }
                        Util.close(rs, pstmt, null, myex);
                    }
                    return consumer2;
                }
                try {
                    c2 = null;
                    if (!myConn) break block17;
                }
                catch (Exception e) {
                    try {
                        myex = e;
                        try {
                            if (conn != null && !conn.getAutoCommit()) {
                                conn.rollback();
                            }
                        }
                        catch (SQLException rbe) {
                            this.logger.log(32, "B4080[" + sql + "]", rbe);
                        }
                        if (e instanceof BrokerException) {
                            throw (BrokerException)e;
                        }
                        Exception ex = e instanceof SQLException ? DBManager.wrapSQLException("[" + sql + "]", (SQLException)e) : (e instanceof IOException ? DBManager.wrapIOException("[" + sql + "]", (IOException)e) : e);
                        throw new BrokerException(this.br.getKString("B4013", consumerUID), ex);
                    }
                    catch (Throwable throwable) {
                        if (myConn) {
                            Util.close(rs, pstmt, conn, myex);
                        } else {
                            Util.close(rs, pstmt, null, myex);
                        }
                        throw throwable;
                    }
                }
                Util.close(rs, pstmt, conn, myex);
                break block19;
            }
            Util.close(rs, pstmt, null, myex);
        }
        return c2;
    }

    @Override
    public HashMap getDebugInfo(Connection conn) {
        HashMap<CallSite, String> map = new HashMap<CallSite, String>();
        int count = -1;
        try {
            count = this.getRowCount(null, null);
        }
        catch (Exception e) {
            this.logger.log(32, e.getMessage(), e.getCause());
        }
        map.put((CallSite)((Object)("Consumers(" + this.tableName + ")")), String.valueOf(count));
        return map;
    }
}

