/*
 * Copyright (c) 1997, 2018 Oracle and/or its affiliates. All rights reserved.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Distribution License v. 1.0, which is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

package org.glassfish.pfl.tf.timer.spi ;

/** Used to create specific TimerEvent instances through a TimerEventController.
 * The contents() method in a Timer returns an unmodifiable empty set.
 *
 * @author  Ken Cavanaugh
 */
public interface Timer extends Controllable {
    /** Return true if this Timer is ready to create TimerEvents.
     * This is the case either if this Timer is enabled, or is reachable
     * through contents() from an enabled TimerGroup.
     */
    boolean isActivated() ;
}
