/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.junit.platform.config.core;

import java.lang.reflect.Method;
import org.graalvm.junit.platform.config.core.NativeImageConfiguration;

public abstract class PluginConfigProvider {
    protected ClassLoader applicationClassLoader;
    protected NativeImageConfiguration nativeImageConfigImpl;

    public abstract void onLoad(NativeImageConfiguration var1);

    public abstract void onTestClassRegistered(Class<?> var1, NativeImageConfiguration var2);

    public final void initialize(ClassLoader classLoader, NativeImageConfiguration nic) {
        this.applicationClassLoader = classLoader;
        this.nativeImageConfigImpl = nic;
    }

    protected final <T> T getAnnotationElementValue(Class<?> annotatedClass, String annotationName, String annotationElementName) {
        try {
            Class<?> annotation = this.applicationClassLoader.loadClass(annotationName);
            Method classProvider = annotation.getDeclaredMethod(annotationElementName, new Class[0]);
            Object classAnnotation = annotatedClass.getAnnotation(annotation);
            if (classAnnotation != null) {
                return (T)classProvider.invoke(classAnnotation, new Object[0]);
            }
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            // empty catch block
        }
        return null;
    }
}

