/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.objectfile.debugentry;

import com.oracle.objectfile.debugentry.FileEntry;
import com.oracle.objectfile.debugentry.StructureTypeEntry;
import com.oracle.objectfile.debugentry.TypeEntry;

public abstract class MemberEntry {
    protected FileEntry fileEntry;
    protected int line;
    protected final String memberName;
    protected final StructureTypeEntry ownerType;
    protected final TypeEntry valueType;
    protected final int modifiers;

    public MemberEntry(FileEntry fileEntry, String memberName, StructureTypeEntry ownerType, TypeEntry valueType, int modifiers) {
        this(fileEntry, 0, memberName, ownerType, valueType, modifiers);
    }

    public MemberEntry(FileEntry fileEntry, int line, String memberName, StructureTypeEntry ownerType, TypeEntry valueType, int modifiers) {
        assert (line >= 0);
        this.fileEntry = fileEntry;
        this.line = line;
        this.memberName = memberName;
        this.ownerType = ownerType;
        this.valueType = valueType;
        this.modifiers = modifiers;
    }

    public String getFileName() {
        if (this.fileEntry != null) {
            return this.fileEntry.getFileName();
        }
        return "";
    }

    String getFullFileName() {
        if (this.fileEntry != null) {
            return this.fileEntry.getFullName();
        }
        return null;
    }

    String getDirName() {
        if (this.fileEntry != null) {
            return this.fileEntry.getPathName();
        }
        return "";
    }

    public FileEntry getFileEntry() {
        return this.fileEntry;
    }

    public int getLine() {
        return this.line;
    }

    public StructureTypeEntry ownerType() {
        return this.ownerType;
    }

    public TypeEntry getValueType() {
        return this.valueType;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public String getModifiersString() {
        return this.ownerType.memberModifiers(this.modifiers);
    }
}

