/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.flow;

import com.oracle.graal.pointsto.PointsToAnalysis;
import com.oracle.graal.pointsto.flow.ActualReturnTypeFlow;
import com.oracle.graal.pointsto.flow.InvokeTypeFlow;
import com.oracle.graal.pointsto.flow.MethodFlowsGraph;
import com.oracle.graal.pointsto.flow.TypeFlow;
import com.oracle.graal.pointsto.flow.context.BytecodeLocation;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.PointsToAnalysisMethod;
import com.oracle.graal.pointsto.typestate.TypeState;
import com.oracle.graal.pointsto.util.AnalysisError;
import com.oracle.graal.pointsto.util.ConcurrentLightHashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import jdk.vm.ci.code.BytecodePosition;

public abstract class AbstractVirtualInvokeTypeFlow
extends InvokeTypeFlow {
    private static final AtomicReferenceFieldUpdater<AbstractVirtualInvokeTypeFlow, Object> CALLEES_UPDATER = AtomicReferenceFieldUpdater.newUpdater(AbstractVirtualInvokeTypeFlow.class, Object.class, "callees");
    private static final AtomicReferenceFieldUpdater<AbstractVirtualInvokeTypeFlow, Object> INVOKE_LOCATIONS_UPDATER = AtomicReferenceFieldUpdater.newUpdater(AbstractVirtualInvokeTypeFlow.class, Object.class, "invokeLocations");
    protected volatile Object callees;
    private boolean isContextInsensitive;
    protected volatile Object invokeLocations;

    protected AbstractVirtualInvokeTypeFlow(BytecodePosition invokeLocation, AnalysisType receiverType, PointsToAnalysisMethod targetMethod, TypeFlow<?>[] actualParameters, ActualReturnTypeFlow actualReturn, BytecodeLocation location) {
        super(invokeLocation, receiverType, targetMethod, actualParameters, actualReturn, location);
    }

    protected AbstractVirtualInvokeTypeFlow(PointsToAnalysis bb, MethodFlowsGraph methodFlows, AbstractVirtualInvokeTypeFlow original) {
        super(bb, methodFlows, original);
    }

    public void markAsContextInsensitive() {
        this.isContextInsensitive = true;
    }

    public boolean isContextInsensitive() {
        return this.isContextInsensitive;
    }

    public boolean addInvokeLocation(BytecodePosition invokeLocation) {
        if (invokeLocation != null) {
            return ConcurrentLightHashSet.addElement(this, INVOKE_LOCATIONS_UPDATER, invokeLocation);
        }
        return false;
    }

    public Collection<BytecodePosition> getInvokeLocations() {
        if (this.isContextInsensitive) {
            return ConcurrentLightHashSet.getElements(this, INVOKE_LOCATIONS_UPDATER);
        }
        return Collections.singleton(this.getSource());
    }

    @Override
    public final boolean isDirectInvoke() {
        return false;
    }

    @Override
    public boolean addState(PointsToAnalysis bb, TypeState add, boolean postFlow) {
        throw AnalysisError.shouldNotReachHere("The VirtualInvokeTypeFlow should not be updated directly.");
    }

    @Override
    public void update(PointsToAnalysis bb) {
        throw AnalysisError.shouldNotReachHere("The VirtualInvokeTypeFlow should not be updated directly.");
    }

    @Override
    public abstract void onObservedUpdate(PointsToAnalysis var1);

    @Override
    public void onObservedSaturated(PointsToAnalysis bb, TypeFlow<?> observed) {
        assert (this.isClone());
        this.replaceObservedWith(bb, this.receiverType);
    }

    protected boolean addCallee(AnalysisMethod callee) {
        boolean add = ConcurrentLightHashSet.addElement(this, CALLEES_UPDATER, callee);
        if (this.isClone()) {
            ((AbstractVirtualInvokeTypeFlow)this.originalInvoke).addCallee(callee);
        }
        return add;
    }

    @Override
    public Collection<AnalysisMethod> getCallees() {
        return ConcurrentLightHashSet.getElements(this, CALLEES_UPDATER);
    }

    @Override
    public String toString() {
        return "VirtualInvoke<" + this.targetMethod.format("%h.%n") + ">:" + this.getState();
    }
}

