/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.flow;

import com.oracle.graal.pointsto.PointsToAnalysis;
import com.oracle.graal.pointsto.flow.MethodFlowsGraph;
import com.oracle.graal.pointsto.flow.TypeFlow;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.typestate.TypeState;
import jdk.vm.ci.code.BytecodePosition;
import org.graalvm.compiler.nodes.ValueNode;

public class FilterTypeFlow
extends TypeFlow<BytecodePosition> {
    private final boolean isExact;
    private final boolean isAssignable;
    private final boolean includeNull;

    public FilterTypeFlow(ValueNode node, AnalysisType filterType, boolean isAssignable, boolean includeNull) {
        this(node, filterType, false, isAssignable, includeNull);
    }

    public FilterTypeFlow(ValueNode node, AnalysisType filterType, boolean isExact, boolean isAssignable, boolean includeNull) {
        super(node.getNodeSourcePosition(), filterType);
        this.isExact = isExact;
        this.isAssignable = isAssignable;
        this.includeNull = includeNull;
    }

    public FilterTypeFlow(MethodFlowsGraph methodFlows, FilterTypeFlow original) {
        super(original, methodFlows);
        this.isExact = original.isExact;
        this.isAssignable = original.isAssignable;
        this.includeNull = original.includeNull;
    }

    @Override
    public TypeFlow<BytecodePosition> copy(PointsToAnalysis bb, MethodFlowsGraph methodFlows) {
        return new FilterTypeFlow(methodFlows, this);
    }

    @Override
    public TypeState filter(PointsToAnalysis bb, TypeState update) {
        TypeState result = this.isExact ? (this.isAssignable ? TypeState.forIntersection(bb, update, TypeState.forExactType(bb, this.declaredType, this.includeNull)) : TypeState.forSubtraction(bb, update, TypeState.forExactType(bb, this.declaredType, !this.includeNull))) : (this.isAssignable ? TypeState.forIntersection(bb, update, this.declaredType.getAssignableTypes(this.includeNull)) : TypeState.forSubtraction(bb, update, this.declaredType.getAssignableTypes(!this.includeNull)));
        return result;
    }

    @Override
    protected void onInputSaturated(PointsToAnalysis bb, TypeFlow<?> input) {
        if (this.isAssignable) {
            this.setSaturated();
            this.swapOut(bb, this.declaredType.getTypeFlow(bb, this.includeNull));
        } else {
            super.onInputSaturated(bb, input);
        }
    }

    @Override
    protected void notifyUseOfSaturation(PointsToAnalysis bb, TypeFlow<?> use) {
        if (this.isAssignable) {
            this.swapAtUse(bb, this.declaredType.getTypeFlow(bb, this.includeNull), use);
        } else {
            super.notifyUseOfSaturation(bb, use);
        }
    }

    @Override
    protected void notifyObserverOfSaturation(PointsToAnalysis bb, TypeFlow<?> observer) {
        if (this.isAssignable) {
            this.swapAtObserver(bb, this.declaredType.getTypeFlow(bb, this.includeNull), observer);
        } else {
            super.notifyObserverOfSaturation(bb, observer);
        }
    }

    @Override
    public boolean addState(PointsToAnalysis bb, TypeState add) {
        assert (this.isClone());
        return super.addState(bb, add);
    }

    public boolean isExact() {
        return this.isExact;
    }

    public boolean isAssignable() {
        return this.isAssignable;
    }

    public boolean includeNull() {
        return this.includeNull;
    }

    @Override
    public String toString() {
        return "FilterTypeFlow<" + this.declaredType + ", isAssignable: " + this.isAssignable + ", includeNull: " + this.includeNull + ">";
    }
}

