/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.flow;

import com.oracle.graal.pointsto.PointsToAnalysis;
import com.oracle.graal.pointsto.flow.TypeFlow;
import com.oracle.graal.pointsto.flow.UnsafeWriteSinkTypeFlow;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.typestate.TypeState;

public class FrozenFieldFilterTypeFlow
extends TypeFlow<AnalysisField> {
    private final UnsafeWriteSinkTypeFlow unsafeSink;

    public FrozenFieldFilterTypeFlow(PointsToAnalysis bb, AnalysisField field, UnsafeWriteSinkTypeFlow unsafeSink) {
        super(field, field.getType());
        this.unsafeSink = unsafeSink;
        ((AnalysisField)this.source).getInstanceFieldFlow().addObserver(bb, this);
    }

    @Override
    public TypeState filter(PointsToAnalysis bb, TypeState update) {
        TypeState fieldState = ((AnalysisField)this.source).getInstanceFieldFlow().getState();
        TypeState filter = TypeState.forContextInsensitiveTypeState(bb, fieldState);
        return TypeState.forIntersection(bb, update, filter);
    }

    @Override
    public void onObservedUpdate(PointsToAnalysis bb) {
        this.addState(bb, this.unsafeSink.getState());
    }

    @Override
    public String toString() {
        return "FrozenFieldFilterTypeFlow<" + this.source + ">";
    }
}

