/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.flow;

import com.oracle.graal.pointsto.PointsToAnalysis;
import com.oracle.graal.pointsto.flow.ArrayElementsTypeFlow;
import com.oracle.graal.pointsto.flow.FieldFilterTypeFlow;
import com.oracle.graal.pointsto.flow.MethodFlowsGraph;
import com.oracle.graal.pointsto.flow.TypeFlow;
import com.oracle.graal.pointsto.flow.UnsafeWriteSinkTypeFlow;
import com.oracle.graal.pointsto.flow.context.object.AnalysisObject;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.nodes.UnsafePartitionStoreNode;
import com.oracle.graal.pointsto.typestate.TypeState;
import com.oracle.svm.util.UnsafePartitionKind;
import java.util.List;
import jdk.vm.ci.code.BytecodePosition;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.extended.JavaWriteNode;
import org.graalvm.compiler.nodes.extended.RawStoreNode;
import org.graalvm.compiler.nodes.java.UnsafeCompareAndSwapNode;

public abstract class OffsetStoreTypeFlow
extends TypeFlow<BytecodePosition> {
    private final AnalysisType objectType;
    private final TypeFlow<?> valueFlow;
    protected TypeFlow<?> objectFlow;

    public OffsetStoreTypeFlow(ValueNode node, AnalysisType objectType, AnalysisType componentType, TypeFlow<?> objectFlow, TypeFlow<?> valueFlow) {
        super(node.getNodeSourcePosition(), componentType);
        this.objectType = objectType;
        this.valueFlow = valueFlow;
        this.objectFlow = objectFlow;
    }

    public OffsetStoreTypeFlow(PointsToAnalysis bb, MethodFlowsGraph methodFlows, OffsetStoreTypeFlow original) {
        super(original, methodFlows);
        this.objectType = original.objectType;
        this.valueFlow = methodFlows.lookupCloneOf(bb, original.valueFlow);
        this.objectFlow = methodFlows.lookupCloneOf(bb, original.objectFlow);
    }

    @Override
    public TypeFlow<?> receiver() {
        return this.objectFlow;
    }

    public TypeState getObjectState() {
        return this.objectFlow.getState();
    }

    @Override
    public abstract TypeFlow<BytecodePosition> copy(PointsToAnalysis var1, MethodFlowsGraph var2);

    @Override
    public abstract boolean addState(PointsToAnalysis var1, TypeState var2);

    @Override
    public void setObserved(TypeFlow<?> newObjectFlow) {
        this.objectFlow = newObjectFlow;
    }

    @Override
    public abstract void onObservedUpdate(PointsToAnalysis var1);

    @Override
    public void onObservedSaturated(PointsToAnalysis bb, TypeFlow<?> observed) {
        assert (this.isClone());
        this.replaceObservedWith(bb, this.objectType);
    }

    public static class JavaWriteTypeFlow
    extends AbstractUnsafeStoreTypeFlow {
        public JavaWriteTypeFlow(JavaWriteNode node, AnalysisType objectType, AnalysisType componentType, TypeFlow<?> objectFlow, TypeFlow<?> valueFlow) {
            super((ValueNode)node, objectType, componentType, objectFlow, valueFlow);
        }

        public JavaWriteTypeFlow(PointsToAnalysis bb, MethodFlowsGraph methodFlows, JavaWriteTypeFlow original) {
            super(bb, methodFlows, original);
        }

        @Override
        public JavaWriteTypeFlow makeCopy(PointsToAnalysis bb, MethodFlowsGraph methodFlows) {
            return new JavaWriteTypeFlow(bb, methodFlows, this);
        }

        @Override
        public String toString() {
            return "JavaWriteTypeFlow<" + this.getState() + ">";
        }
    }

    public static class UnsafePartitionStoreTypeFlow
    extends AbstractUnsafeStoreTypeFlow {
        protected final UnsafePartitionKind partitionKind;
        protected final AnalysisType partitionType;

        public UnsafePartitionStoreTypeFlow(UnsafePartitionStoreNode node, AnalysisType objectType, AnalysisType componentType, TypeFlow<?> objectFlow, TypeFlow<?> valueFlow, UnsafePartitionKind partitionKind, AnalysisType partitionType) {
            super((ValueNode)node, objectType, componentType, objectFlow, valueFlow);
            this.partitionKind = partitionKind;
            this.partitionType = partitionType;
        }

        public UnsafePartitionStoreTypeFlow(PointsToAnalysis bb, MethodFlowsGraph methodFlows, UnsafePartitionStoreTypeFlow original) {
            super(bb, methodFlows, original);
            this.partitionKind = original.partitionKind;
            this.partitionType = original.partitionType;
        }

        @Override
        public UnsafePartitionStoreTypeFlow makeCopy(PointsToAnalysis bb, MethodFlowsGraph methodFlows) {
            return new UnsafePartitionStoreTypeFlow(bb, methodFlows, this);
        }

        @Override
        public boolean addState(PointsToAnalysis bb, TypeState add) {
            assert (this.isClone());
            return super.addState(bb, add, true);
        }

        @Override
        public TypeState filter(PointsToAnalysis bb, TypeState update) {
            if (this.partitionType.equals(bb.getObjectType())) {
                return update;
            }
            return TypeState.forIntersection(bb, update, this.partitionType.getAssignableTypes(true));
        }

        @Override
        public void onObservedUpdate(PointsToAnalysis bb) {
            assert (this.isClone());
            TypeState objectState = this.objectFlow.getState();
            for (AnalysisObject object : objectState.objects()) {
                AnalysisType objectType = object.type();
                assert (!objectType.isArray());
                this.handleUnsafeAccessedFields(bb, objectType.unsafeAccessedFields(this.partitionKind), object);
            }
        }

        @Override
        public String toString() {
            return "UnsafePartitionStoreTypeFlow<" + this.getState() + "> : " + this.partitionKind;
        }
    }

    public static class AtomicWriteTypeFlow
    extends AbstractUnsafeStoreTypeFlow {
        public AtomicWriteTypeFlow(ValueNode node, AnalysisType objectType, AnalysisType componentType, TypeFlow<?> objectFlow, TypeFlow<?> valueFlow) {
            super(node, objectType, componentType, objectFlow, valueFlow);
        }

        public AtomicWriteTypeFlow(PointsToAnalysis bb, MethodFlowsGraph methodFlows, AtomicWriteTypeFlow original) {
            super(bb, methodFlows, original);
        }

        @Override
        public AtomicWriteTypeFlow makeCopy(PointsToAnalysis bb, MethodFlowsGraph methodFlows) {
            return new AtomicWriteTypeFlow(bb, methodFlows, this);
        }

        @Override
        public String toString() {
            return "AtomicWriteTypeFlow<" + this.getState() + ">";
        }
    }

    public static class CompareAndSwapTypeFlow
    extends AbstractUnsafeStoreTypeFlow {
        public CompareAndSwapTypeFlow(UnsafeCompareAndSwapNode node, AnalysisType objectType, AnalysisType componentType, TypeFlow<?> objectFlow, TypeFlow<?> valueFlow) {
            super((ValueNode)node, objectType, componentType, objectFlow, valueFlow);
        }

        public CompareAndSwapTypeFlow(PointsToAnalysis bb, MethodFlowsGraph methodFlows, CompareAndSwapTypeFlow original) {
            super(bb, methodFlows, original);
        }

        @Override
        public CompareAndSwapTypeFlow makeCopy(PointsToAnalysis bb, MethodFlowsGraph methodFlows) {
            return new CompareAndSwapTypeFlow(bb, methodFlows, this);
        }

        @Override
        public String toString() {
            return "CompareAndSwapTypeFlow<" + this.getState() + ">";
        }
    }

    public static class UnsafeStoreTypeFlow
    extends AbstractUnsafeStoreTypeFlow {
        public UnsafeStoreTypeFlow(RawStoreNode node, AnalysisType objectType, AnalysisType componentType, TypeFlow<?> objectFlow, TypeFlow<?> valueFlow) {
            super((ValueNode)node, objectType, componentType, objectFlow, valueFlow);
        }

        public UnsafeStoreTypeFlow(PointsToAnalysis bb, MethodFlowsGraph methodFlows, UnsafeStoreTypeFlow original) {
            super(bb, methodFlows, original);
        }

        @Override
        public UnsafeStoreTypeFlow makeCopy(PointsToAnalysis bb, MethodFlowsGraph methodFlows) {
            return new UnsafeStoreTypeFlow(bb, methodFlows, this);
        }

        @Override
        public String toString() {
            return "UnsafeStoreTypeFlow<" + this.getState() + ">";
        }
    }

    public static abstract class AbstractUnsafeStoreTypeFlow
    extends OffsetStoreTypeFlow {
        AbstractUnsafeStoreTypeFlow(ValueNode node, AnalysisType objectType, AnalysisType componentType, TypeFlow<?> objectFlow, TypeFlow<?> valueFlow) {
            super(node, objectType, componentType, objectFlow, valueFlow);
        }

        AbstractUnsafeStoreTypeFlow(PointsToAnalysis bb, MethodFlowsGraph methodFlows, OffsetStoreTypeFlow original) {
            super(bb, methodFlows, original);
        }

        public final AbstractUnsafeStoreTypeFlow copy(PointsToAnalysis bb, MethodFlowsGraph methodFlows) {
            AbstractUnsafeStoreTypeFlow copy = this.makeCopy(bb, methodFlows);
            bb.registerUnsafeStore(copy);
            return copy;
        }

        protected abstract AbstractUnsafeStoreTypeFlow makeCopy(PointsToAnalysis var1, MethodFlowsGraph var2);

        @Override
        public void initClone(PointsToAnalysis bb) {
            for (AnalysisField field : bb.getUniverse().getUnsafeAccessedStaticFields()) {
                this.addUse(bb, field.getStaticFieldFlow().filterFlow(bb));
            }
        }

        @Override
        public boolean addState(PointsToAnalysis bb, TypeState add) {
            assert (this.isClone());
            return super.addState(bb, add, true);
        }

        void handleUnsafeAccessedFields(PointsToAnalysis bb, List<AnalysisField> unsafeAccessedFields, AnalysisObject object) {
            for (AnalysisField field : unsafeAccessedFields) {
                if (field.hasUnsafeFrozenTypeState()) {
                    UnsafeWriteSinkTypeFlow unsafeWriteSink = object.getUnsafeWriteSinkFrozenFilterFlow(bb, this.objectFlow, (BytecodePosition)this.source, field);
                    this.addUse(bb, unsafeWriteSink);
                    continue;
                }
                FieldFilterTypeFlow fieldFilterFlow = object.getInstanceFieldFilterFlow(bb, this.objectFlow, (BytecodePosition)this.source, field);
                this.addUse(bb, fieldFilterFlow);
            }
        }

        @Override
        public void onObservedUpdate(PointsToAnalysis bb) {
            assert (this.isClone());
            TypeState objectState = this.objectFlow.getState();
            for (AnalysisObject object : objectState.objects()) {
                AnalysisType objectType = object.type();
                if (objectType.isArray()) {
                    if (object.isPrimitiveArray() || object.isEmptyObjectArrayConstant(bb)) continue;
                    ArrayElementsTypeFlow elementsFlow = object.getArrayElementsFlow(bb, true);
                    this.addUse(bb, elementsFlow);
                    continue;
                }
                this.handleUnsafeAccessedFields(bb, objectType.unsafeAccessedFields(), object);
            }
        }
    }

    public static class StoreIndexedTypeFlow
    extends OffsetStoreTypeFlow {
        public StoreIndexedTypeFlow(ValueNode node, AnalysisType arrayType, TypeFlow<?> objectFlow, TypeFlow<?> valueFlow) {
            super(node, arrayType, arrayType.getComponentType(), objectFlow, valueFlow);
        }

        public StoreIndexedTypeFlow(PointsToAnalysis bb, MethodFlowsGraph methodFlows, StoreIndexedTypeFlow original) {
            super(bb, methodFlows, original);
        }

        public StoreIndexedTypeFlow copy(PointsToAnalysis bb, MethodFlowsGraph methodFlows) {
            return new StoreIndexedTypeFlow(bb, methodFlows, this);
        }

        @Override
        public boolean addState(PointsToAnalysis bb, TypeState add) {
            assert (this.isClone());
            return super.addState(bb, add, true);
        }

        @Override
        public void onObservedUpdate(PointsToAnalysis bb) {
            assert (this.isClone());
            TypeState objectState = this.objectFlow.getState();
            for (AnalysisObject object : objectState.objects()) {
                if (bb.analysisPolicy().relaxTypeFlowConstraints() && !object.type().isArray() || object.isPrimitiveArray() || object.isEmptyObjectArrayConstant(bb)) continue;
                ArrayElementsTypeFlow elementsFlow = object.getArrayElementsFlow(bb, true);
                this.addUse(bb, elementsFlow);
            }
        }

        @Override
        public String toString() {
            return "StoreIndexedTypeFlow<" + this.getState() + ">";
        }
    }
}

