/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.reports;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.ObjectScanner;
import com.oracle.graal.pointsto.ObjectScanningObserver;
import com.oracle.graal.pointsto.api.PointstoOptions;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.reports.ReportUtils;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import jdk.vm.ci.meta.JavaConstant;

public final class AnalysisHeapHistogramPrinter
extends ObjectScanner {
    public static void print(BigBang bb, String reportsPath, String reportName) {
        ReportUtils.report("analysis heap histogram", reportsPath, "analysis_heap_histogram_" + reportName, "txt", writer -> AnalysisHeapHistogramPrinter.doPrint(writer, bb));
    }

    private static void doPrint(PrintWriter out, BigBang bb) {
        if (!((Boolean)PointstoOptions.ExhaustiveHeapScan.getValue(bb.getOptions())).booleanValue()) {
            String types = Arrays.stream(bb.skippedHeapTypes()).map(t -> t.toJavaName()).collect(Collectors.joining(", "));
            System.out.println("Exhaustive heap scanning is disabled. The analysis heap histogram will not contain all instances of types: " + types);
            System.out.println("Exhaustive heap scanning can be turned on using -H:+ExhaustiveHeapScan.");
        }
        HashMap<AnalysisType, Integer> histogram = new HashMap<AnalysisType, Integer>();
        AnalysisHeapHistogramPrinter printer = new AnalysisHeapHistogramPrinter(bb, histogram);
        printer.scanBootImageHeapRoots(ReportUtils.fieldComparator, ReportUtils.positionComparator);
        AnalysisHeapHistogramPrinter.printHistogram(out, histogram);
    }

    private static void printHistogram(PrintWriter out, Map<AnalysisType, Integer> histogram) {
        out.println("Heap histogram");
        out.format("%8s %s %n", "Count", "Class");
        histogram.entrySet().stream().sorted(Map.Entry.comparingByValue().reversed()).forEach(entry -> out.format("%8d %8s %n", entry.getValue(), ((AnalysisType)entry.getKey()).toJavaName()));
    }

    private AnalysisHeapHistogramPrinter(BigBang bb, Map<AnalysisType, Integer> histogram) {
        super(bb, null, new ObjectScanner.ReusableSet(), new ScanningObserver(bb, histogram));
    }

    private static final class ScanningObserver
    implements ObjectScanningObserver {
        private final BigBang bb;
        private final Map<AnalysisType, Integer> histogram;

        private ScanningObserver(BigBang bb, Map<AnalysisType, Integer> histogram) {
            this.bb = bb;
            this.histogram = histogram;
        }

        @Override
        public void forScannedConstant(JavaConstant scannedValue, ObjectScanner.ScanReason reason) {
            AnalysisType type = AnalysisHeapHistogramPrinter.constantType(this.bb, scannedValue);
            int count = this.histogram.getOrDefault(type, 0);
            this.histogram.put(type, count + 1);
        }

        @Override
        public void forRelocatedPointerFieldValue(JavaConstant receiver, AnalysisField field, JavaConstant fieldValue) {
        }

        @Override
        public void forNullFieldValue(JavaConstant receiver, AnalysisField field) {
        }

        @Override
        public void forNonNullFieldValue(JavaConstant receiver, AnalysisField field, JavaConstant fieldValue) {
        }

        @Override
        public void forNullArrayElement(JavaConstant array, AnalysisType arrayType, int index) {
        }

        @Override
        public void forNonNullArrayElement(JavaConstant array, AnalysisType arrayType, JavaConstant elementConstant, AnalysisType elementType, int index) {
        }
    }
}

