/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.code;

import com.oracle.graal.pointsto.infrastructure.GraphProvider;
import com.oracle.graal.pointsto.meta.HostedProviders;
import com.oracle.svm.core.meta.SharedMethod;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.hosted.annotation.CustomSubstitutionMethod;
import com.oracle.svm.hosted.c.NativeLibraries;
import com.oracle.svm.hosted.c.info.ElementInfo;
import com.oracle.svm.hosted.c.info.EnumInfo;
import com.oracle.svm.hosted.c.info.EnumLookupInfo;
import com.oracle.svm.hosted.code.CEntryPointCallStubSupport;
import com.oracle.svm.hosted.code.SimpleSignature;
import com.oracle.svm.hosted.phases.CInterfaceEnumTool;
import com.oracle.svm.hosted.phases.HostedGraphKit;
import java.lang.reflect.AnnotatedElement;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.Signature;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.java.FrameStateBuilder;
import org.graalvm.compiler.nodes.CallTargetNode;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.LogicNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.UnwindNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.FloatingNode;
import org.graalvm.compiler.nodes.calc.IsNullNode;
import org.graalvm.compiler.nodes.java.NewInstanceNode;
import org.graalvm.nativeimage.c.constant.CEnum;
import org.graalvm.nativeimage.c.constant.CEnumLookup;

public abstract class CCallStubMethod
extends CustomSubstitutionMethod {
    private static final JavaKind cEnumKind = JavaKind.Int;
    protected final boolean needsTransition;

    CCallStubMethod(ResolvedJavaMethod original, boolean needsTransition) {
        super(original);
        this.needsTransition = needsTransition;
    }

    protected abstract String getCorrespondingAnnotationName();

    public StructuredGraph buildGraph(DebugContext debug, ResolvedJavaMethod method, HostedProviders providers, GraphProvider.Purpose purpose) {
        NativeLibraries nativeLibraries = CEntryPointCallStubSupport.singleton().getNativeLibraries();
        boolean deoptimizationTarget = method instanceof SharedMethod && ((SharedMethod)method).isDeoptTarget();
        HostedGraphKit kit = new HostedGraphKit(debug, providers, method);
        FrameStateBuilder state = kit.getFrameState();
        List<ValueNode> arguments = kit.loadArguments(this.getParameterTypesForLoad(method));
        ValueNode callAddress = this.createTargetAddressNode(kit, providers, arguments);
        Signature signature = this.adaptSignatureAndConvertArguments(providers, nativeLibraries, kit, method.getSignature().getReturnType(null), method.toParameterTypes(), arguments);
        state.clearLocals();
        ValueNode returnValue = kit.createCFunctionCall(callAddress, arguments, signature, this.needsTransition, deoptimizationTarget);
        returnValue = this.adaptReturnValue(method, providers, nativeLibraries, kit, returnValue);
        kit.createReturn(returnValue, signature.getReturnKind());
        return kit.finalizeGraph();
    }

    protected abstract ValueNode createTargetAddressNode(HostedGraphKit var1, HostedProviders var2, List<ValueNode> var3);

    protected static boolean isPrimitiveOrWord(HostedProviders providers, JavaType type) {
        return type.getJavaKind().isPrimitive() || providers.getWordTypes().isWord(type);
    }

    protected JavaType[] getParameterTypesForLoad(ResolvedJavaMethod method) {
        return method.getSignature().toParameterTypes(null);
    }

    protected Signature adaptSignatureAndConvertArguments(HostedProviders providers, NativeLibraries nativeLibraries, HostedGraphKit kit, JavaType returnType, JavaType[] parameterTypes, List<ValueNode> arguments) {
        MetaAccessProvider metaAccess = providers.getMetaAccess();
        for (int i = 0; i < parameterTypes.length; ++i) {
            if (CCallStubMethod.isPrimitiveOrWord(providers, parameterTypes[i])) continue;
            ElementInfo typeInfo = nativeLibraries.findElementInfo((AnnotatedElement)((ResolvedJavaType)parameterTypes[i]));
            if (typeInfo instanceof EnumInfo) {
                ValueNode argumentValue = arguments.get(i);
                IsNullNode isNull = (IsNullNode)kit.unique((FloatingNode)new IsNullNode(argumentValue));
                kit.startIf((LogicNode)isNull, 0.0010000000000000009);
                kit.thenPart();
                ResolvedJavaType enumExceptionType = metaAccess.lookupJavaType(RuntimeException.class);
                NewInstanceNode enumException = (NewInstanceNode)kit.append((ValueNode)new NewInstanceNode(enumExceptionType, true));
                Iterator enumExceptionCtor = Arrays.stream(enumExceptionType.getDeclaredConstructors()).filter(c -> c.getSignature().getParameterCount(false) == 1 && c.getSignature().getParameterType(0, null).equals(metaAccess.lookupJavaType(String.class))).iterator();
                ConstantNode enumExceptionMessage = kit.createConstant((Constant)kit.getConstantReflection().forString("null return value cannot be converted to a C enum value"), JavaKind.Object);
                kit.createJavaCallWithExceptionAndUnwind(CallTargetNode.InvokeKind.Special, (ResolvedJavaMethod)enumExceptionCtor.next(), new ValueNode[]{enumException, enumExceptionMessage});
                assert (!enumExceptionCtor.hasNext());
                kit.append((ValueNode)new UnwindNode((ValueNode)enumException));
                kit.endIf();
                CInterfaceEnumTool tool = new CInterfaceEnumTool(metaAccess, providers.getSnippetReflection());
                argumentValue = tool.createEnumValueInvoke(kit, (EnumInfo)typeInfo, cEnumKind, argumentValue);
                arguments.set(i, argumentValue);
                parameterTypes[i] = metaAccess.lookupJavaType(cEnumKind.toJavaClass());
                continue;
            }
            throw UserError.abort("@" + this.getCorrespondingAnnotationName() + " parameter types are restricted to primitive types, word types and enumerations (@" + CEnum.class.getSimpleName() + "): " + this.getOriginal().format("%H.%n(%p)"));
        }
        JavaType actualReturnType = CCallStubMethod.isPrimitiveOrWord(providers, returnType) ? returnType : providers.getWordTypes().getWordImplType();
        return new SimpleSignature(parameterTypes, actualReturnType);
    }

    private ValueNode adaptReturnValue(ResolvedJavaMethod method, HostedProviders providers, NativeLibraries nativeLibraries, HostedGraphKit kit, ValueNode invokeValue) {
        ValueNode returnValue = invokeValue;
        JavaType declaredReturnType = method.getSignature().getReturnType(null);
        if (CCallStubMethod.isPrimitiveOrWord(providers, declaredReturnType)) {
            return returnValue;
        }
        ElementInfo typeInfo = nativeLibraries.findElementInfo((AnnotatedElement)((ResolvedJavaType)declaredReturnType));
        if (!(typeInfo instanceof EnumInfo)) {
            throw UserError.abort("Return types of methods annotated with @" + this.getCorrespondingAnnotationName() + " are restricted to primitive types, word types and enumerations (@" + CEnum.class.getSimpleName() + "): " + this.getOriginal().format("%H.%n(%p)"));
        }
        UserError.guarantee(typeInfo.getChildren().stream().anyMatch(EnumLookupInfo.class::isInstance), "Enum class " + declaredReturnType.toJavaName() + " needs a method that is annotated with @" + CEnumLookup.class.getSimpleName() + " because it is used as the return type of a method annotated with @" + this.getCorrespondingAnnotationName() + ": " + this.getOriginal().format("%H.%n(%p)"), new Object[0]);
        CInterfaceEnumTool tool = new CInterfaceEnumTool(providers.getMetaAccess(), providers.getSnippetReflection());
        returnValue = tool.createEnumLookupInvoke(kit, (ResolvedJavaType)declaredReturnType, (EnumInfo)typeInfo, cEnumKind, returnValue);
        return returnValue;
    }
}

