/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.hub;

import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.util.ImageHeapMap;
import org.graalvm.collections.EconomicMap;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public final class ClassForNameSupport {
    private final EconomicMap<String, Class<?>> knownClasses = ImageHeapMap.create();

    static ClassForNameSupport singleton() {
        return (ClassForNameSupport)ImageSingletons.lookup(ClassForNameSupport.class);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static void registerClass(Class<?> clazz) {
        ClassForNameSupport.singleton().knownClasses.put((Object)clazz.getName(), clazz);
    }

    public static Class<?> forNameOrNull(String className, boolean initialize) {
        Class result = (Class)ClassForNameSupport.singleton().knownClasses.get((Object)className);
        if (result == null) {
            return null;
        }
        if (initialize) {
            DynamicHub.fromClass(result).ensureInitialized();
        }
        return result;
    }

    public static Class<?> forName(String className, boolean initialize) throws ClassNotFoundException {
        Class<?> result = ClassForNameSupport.forNameOrNull(className, initialize);
        if (result == null) {
            throw new ClassNotFoundException(className);
        }
        return result;
    }
}

