/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.stack;

import com.oracle.svm.core.FrameAccess;
import com.oracle.svm.core.annotate.RestrictHeapAccess;
import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.code.CodeInfo;
import com.oracle.svm.core.code.CodeInfoAccess;
import com.oracle.svm.core.code.CodeInfoQueryResult;
import com.oracle.svm.core.code.CodeInfoTable;
import com.oracle.svm.core.code.SimpleCodeInfoQueryResult;
import com.oracle.svm.core.code.UntetheredCodeInfo;
import com.oracle.svm.core.deopt.DeoptimizationSupport;
import com.oracle.svm.core.deopt.DeoptimizedFrame;
import com.oracle.svm.core.deopt.Deoptimizer;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.stack.JavaFrameAnchor;
import com.oracle.svm.core.stack.JavaFrameAnchors;
import com.oracle.svm.core.stack.JavaStackWalk;
import com.oracle.svm.core.stack.ParameterizedStackFrameVisitor;
import com.oracle.svm.core.stack.StackFrameVisitor;
import com.oracle.svm.core.thread.VMOperation;
import com.oracle.svm.core.util.VMError;
import org.graalvm.nativeimage.CurrentIsolate;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.word.ComparableWord;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

public final class JavaStackWalker {
    private JavaStackWalker() {
    }

    @Uninterruptible(reason="Prevent deoptimization of stack frames while in this method.", callerMustBe=true)
    public static void initWalk(JavaStackWalk walk, Pointer startSP, CodePointer startIP) {
        walk.setSP(startSP);
        walk.setPossiblyStaleIP(startIP);
        walk.setStartSP(startSP);
        walk.setStartIP(startIP);
        walk.setAnchor(JavaFrameAnchors.getFrameAnchor());
        walk.setEndSP((Pointer)WordFactory.nullPointer());
        if (startIP.isNonNull()) {
            walk.setIPCodeInfo(CodeInfoTable.lookupCodeInfo(startIP));
        } else {
            walk.setIPCodeInfo((UntetheredCodeInfo)WordFactory.nullPointer());
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void initWalk(JavaStackWalk walk, Pointer startSP) {
        JavaStackWalker.initWalk(walk, startSP, (CodePointer)WordFactory.nullPointer());
        assert (walk.getIPCodeInfo().isNull()) : "otherwise, the caller would have to be uninterruptible as well";
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void initWalk(JavaStackWalk walk, Pointer startSP, Pointer endSP) {
        JavaStackWalker.initWalk(walk, startSP);
        walk.setEndSP(endSP);
    }

    @Uninterruptible(reason="Prevent deoptimization of stack frames while in this method.", callerMustBe=true)
    public static boolean initWalk(JavaStackWalk walk, IsolateThread thread) {
        assert (thread.notEqual((ComparableWord)CurrentIsolate.getCurrentThread())) : "Cannot walk the current stack with this method, it would miss all frames after the last frame anchor";
        assert (VMOperation.isInProgressAtSafepoint()) : "Walking the stack of another thread is only safe when that thread is stopped at a safepoint";
        JavaFrameAnchor anchor = JavaFrameAnchors.getFrameAnchor(thread);
        boolean result = anchor.isNonNull();
        Pointer sp = (Pointer)WordFactory.nullPointer();
        CodePointer ip = (CodePointer)WordFactory.nullPointer();
        if (result) {
            sp = anchor.getLastJavaSP();
            ip = anchor.getLastJavaIP();
        }
        walk.setSP(sp);
        walk.setPossiblyStaleIP(ip);
        walk.setStartSP(sp);
        walk.setStartIP(ip);
        walk.setAnchor(anchor);
        walk.setEndSP((Pointer)WordFactory.nullPointer());
        walk.setIPCodeInfo(CodeInfoTable.lookupCodeInfo(ip));
        return result;
    }

    @Uninterruptible(reason="Prevent deoptimization of stack frames while in this method.")
    public static boolean continueWalk(JavaStackWalk walk, CodeInfo info) {
        if (walk.getSP().isNull() || walk.getPossiblyStaleIP().isNull()) {
            return false;
        }
        Pointer sp = walk.getSP();
        SimpleCodeInfoQueryResult queryResult = (SimpleCodeInfoQueryResult)StackValue.get(SimpleCodeInfoQueryResult.class);
        DeoptimizedFrame deoptFrame = Deoptimizer.checkDeoptimized(sp);
        if (deoptFrame == null) {
            JavaStackWalker.lookupCodeInfoInterruptible(info, walk.getPossiblyStaleIP(), queryResult);
            deoptFrame = Deoptimizer.checkDeoptimized(sp);
        }
        return JavaStackWalker.continueWalk(walk, queryResult, deoptFrame);
    }

    @Uninterruptible(reason="Prevent deoptimization of stack frames while in this method.", callerMustBe=true)
    public static boolean continueWalk(JavaStackWalk walk, SimpleCodeInfoQueryResult queryResult, DeoptimizedFrame deoptFrame) {
        Pointer sp = walk.getSP();
        long encodedFrameSize = deoptFrame != null ? deoptFrame.getSourceEncodedFrameSize() : queryResult.getEncodedFrameSize();
        if (!CodeInfoQueryResult.isEntryPoint(encodedFrameSize)) {
            long totalFrameSize = CodeInfoQueryResult.getTotalFrameSize(encodedFrameSize);
            sp = sp.add(WordFactory.unsigned((long)totalFrameSize));
            CodePointer ip = FrameAccess.singleton().readReturnAddress(sp);
            walk.setSP(sp);
            walk.setPossiblyStaleIP(ip);
            walk.setIPCodeInfo(CodeInfoTable.lookupCodeInfo(ip));
            return true;
        }
        JavaFrameAnchor anchor = walk.getAnchor();
        while (anchor.isNonNull() && anchor.getLastJavaSP().belowOrEqual((UnsignedWord)sp)) {
            anchor = anchor.getPreviousAnchor();
        }
        if (anchor.isNonNull()) {
            assert (anchor.getLastJavaSP().aboveThan((UnsignedWord)sp));
            walk.setSP(anchor.getLastJavaSP());
            walk.setPossiblyStaleIP(anchor.getLastJavaIP());
            walk.setAnchor(anchor.getPreviousAnchor());
            walk.setIPCodeInfo(CodeInfoTable.lookupCodeInfo(anchor.getLastJavaIP()));
            return true;
        }
        walk.setSP((Pointer)WordFactory.nullPointer());
        walk.setPossiblyStaleIP((CodePointer)WordFactory.nullPointer());
        walk.setAnchor((JavaFrameAnchor)WordFactory.nullPointer());
        walk.setIPCodeInfo((UntetheredCodeInfo)WordFactory.nullPointer());
        return false;
    }

    @Uninterruptible(reason="Wrap call to interruptible code.", calleeMustBe=false)
    private static void lookupCodeInfoInterruptible(CodeInfo codeInfo, CodePointer ip, SimpleCodeInfoQueryResult queryResult) {
        CodeInfoAccess.lookupCodeInfo(codeInfo, CodeInfoAccess.relativeIP(codeInfo, ip), queryResult);
    }

    @Uninterruptible(reason="Not really uninterruptible, but we are about to fatally fail.", calleeMustBe=false)
    public static RuntimeException reportUnknownFrameEncountered(Pointer sp, CodePointer ip, DeoptimizedFrame deoptFrame) {
        Log log = Log.log().string("Stack walk must walk only frames of known code:");
        log.string("  sp=").hex((WordBase)sp).string("  ip=").hex((WordBase)ip);
        if (DeoptimizationSupport.enabled()) {
            log.string("  deoptFrame=").object(deoptFrame);
        }
        log.newline();
        throw VMError.shouldNotReachHere("Stack walk must walk only frames of known code");
    }

    public static boolean walkCurrentThread(Pointer startSP, StackFrameVisitor visitor) {
        return JavaStackWalker.walkCurrentThread(startSP, visitor, null);
    }

    @Uninterruptible(reason="Prevent deoptimization of stack frames while in this method.")
    public static <T> boolean walkCurrentThread(Pointer startSP, ParameterizedStackFrameVisitor<T> visitor, T data) {
        CodePointer startIP = FrameAccess.singleton().readReturnAddress(startSP);
        JavaStackWalk walk = (JavaStackWalk)StackValue.get(JavaStackWalk.class);
        JavaStackWalker.initWalk(walk, startSP, startIP);
        return JavaStackWalker.doWalk(walk, visitor, data);
    }

    public static boolean walkThread(IsolateThread thread, StackFrameVisitor visitor) {
        return JavaStackWalker.walkThread(thread, visitor, null);
    }

    @Uninterruptible(reason="Prevent deoptimization of stack frames while in this method.")
    public static <T> boolean walkThread(IsolateThread thread, ParameterizedStackFrameVisitor<T> visitor, T data) {
        JavaStackWalk walk = (JavaStackWalk)StackValue.get(JavaStackWalk.class);
        if (JavaStackWalker.initWalk(walk, thread)) {
            return JavaStackWalker.doWalk(walk, visitor, data);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="Prevent deoptimization of stack frames while in this method.", callerMustBe=true)
    static <T> boolean doWalk(JavaStackWalk walk, ParameterizedStackFrameVisitor<T> visitor, T data) {
        UntetheredCodeInfo untetheredInfo;
        while (!(untetheredInfo = walk.getIPCodeInfo()).isNull()) {
            Object tether = CodeInfoAccess.acquireTether(untetheredInfo);
            CodeInfo tetheredInfo = CodeInfoAccess.convert(untetheredInfo, tether);
            try {
                if (!JavaStackWalker.callVisitor(walk, tetheredInfo, visitor, data)) {
                    boolean bl = false;
                    return bl;
                }
                if (JavaStackWalker.continueWalk(walk, tetheredInfo)) continue;
                boolean bl = true;
                return bl;
            }
            finally {
                CodeInfoAccess.releaseTether(untetheredInfo, tether);
                continue;
            }
            break;
        }
        return JavaStackWalker.callUnknownFrame(walk, visitor, data);
    }

    @Uninterruptible(reason="CodeInfo in JavaStackWalk is currently null, and we are going to abort the stack walking.", calleeMustBe=false)
    private static <T> boolean callUnknownFrame(JavaStackWalk walk, ParameterizedStackFrameVisitor<T> visitor, T data) {
        return visitor.unknownFrame(walk.getSP(), walk.getPossiblyStaleIP(), Deoptimizer.checkDeoptimized(walk.getSP()), data);
    }

    @Uninterruptible(reason="Wraps the now safe call to the possibly interruptible visitor.", callerMustBe=true, calleeMustBe=false)
    @RestrictHeapAccess(reason="Whitelisted because some StackFrameVisitor implementations can allocate.", access=RestrictHeapAccess.Access.UNRESTRICTED, overridesCallers=true)
    static <T> boolean callVisitor(JavaStackWalk walk, CodeInfo info, ParameterizedStackFrameVisitor<T> visitor, T data) {
        return visitor.visitFrame(walk.getSP(), walk.getPossiblyStaleIP(), info, Deoptimizer.checkDeoptimized(walk.getSP()), data);
    }
}

