/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.util;

import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.util.HostedImageHeapMap;
import com.oracle.svm.core.util.VMError;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticFeature
final class ImageHeapMapFeature
implements Feature {
    private boolean afterAnalysis;

    ImageHeapMapFeature() {
    }

    public void duringSetup(Feature.DuringSetupAccess config) {
        config.registerObjectReplacer(this::imageHeapMapTransformer);
    }

    public void afterAnalysis(Feature.AfterAnalysisAccess access) {
        this.afterAnalysis = true;
    }

    private Object imageHeapMapTransformer(Object obj) {
        if (obj instanceof HostedImageHeapMap) {
            HostedImageHeapMap hosted = (HostedImageHeapMap)((Object)obj);
            if (this.afterAnalysis) {
                VMError.guarantee(hosted.runtimeMap != null, "Discoverd object not seen during analysis: " + (Object)((Object)hosted));
            } else {
                hosted.initRuntimeMap();
            }
            return hosted.runtimeMap;
        }
        return obj;
    }
}

