/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.classinitialization;

import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.classinitialization.ClassInitalizerHasSideEffectsException;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.graph.Graph;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.Invoke;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.extended.UnsafeAccessNode;
import org.graalvm.compiler.nodes.java.AccessFieldNode;

final class AbortOnDisallowedNode
extends Graph.NodeEventListener {
    AbortOnDisallowedNode() {
    }

    public void nodeAdded(Node node) {
        if (node instanceof Invoke) {
            throw new ClassInitalizerHasSideEffectsException("Non-inlined invoke of method: " + ((Invoke)node).getTargetMethod().format("%H.%n(%p)"));
        }
        if (node instanceof AccessFieldNode) {
            ResolvedJavaField field = ((AccessFieldNode)node).field();
            ResolvedJavaMethod clinit = ((StructuredGraph)node.graph()).method();
            if (field.isStatic() && !field.getDeclaringClass().equals(clinit.getDeclaringClass())) {
                throw new ClassInitalizerHasSideEffectsException("Access of static field from a different class: " + field.format("%H.%n"));
            }
        } else if (node instanceof UnsafeAccessNode) {
            throw VMError.shouldNotReachHere("Intrinsification of Unsafe methods is not enabled during bytecode parsing");
        }
    }
}

