/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.fieldfolding;

import com.oracle.svm.core.meta.SubstrateObjectConstant;
import com.oracle.svm.hosted.fieldfolding.StaticFinalFieldFoldingFeature;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.graph.spi.Simplifiable;
import org.graalvm.compiler.graph.spi.SimplifierTool;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.AbstractStateSplit;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.java.StoreIndexedNode;

@NodeInfo(size=NodeSize.SIZE_1, cycles=NodeCycles.CYCLES_1)
final class MarkStaticFinalFieldInitializedNode
extends AbstractStateSplit
implements Simplifiable {
    public static final NodeClass<MarkStaticFinalFieldInitializedNode> TYPE = NodeClass.create(MarkStaticFinalFieldInitializedNode.class);
    private final ResolvedJavaField field;

    protected MarkStaticFinalFieldInitializedNode(ResolvedJavaField field) {
        super(TYPE, StampFactory.forVoid());
        this.field = field;
    }

    public void simplify(SimplifierTool tool) {
        StaticFinalFieldFoldingFeature feature = StaticFinalFieldFoldingFeature.singleton();
        if (feature.fieldInitializationStatus == null) {
            return;
        }
        Integer fieldCheckIndex = feature.fieldCheckIndexMap.get(StaticFinalFieldFoldingFeature.toAnalysisField(this.field));
        if (fieldCheckIndex != null) {
            ConstantNode fieldInitializationStatusNode = ConstantNode.forConstant((JavaConstant)SubstrateObjectConstant.forObject(feature.fieldInitializationStatus), (MetaAccessProvider)tool.getMetaAccess(), (StructuredGraph)this.graph());
            ConstantNode fieldCheckIndexNode = ConstantNode.forInt((int)fieldCheckIndex, (StructuredGraph)this.graph());
            ConstantNode trueNode = ConstantNode.forBoolean((boolean)true, (StructuredGraph)this.graph());
            StoreIndexedNode replacementNode = (StoreIndexedNode)this.graph().add((Node)new StoreIndexedNode((ValueNode)fieldInitializationStatusNode, (ValueNode)fieldCheckIndexNode, null, null, JavaKind.Boolean, (ValueNode)trueNode));
            this.graph().addBeforeFixed((FixedNode)this, (FixedWithNextNode)replacementNode);
            replacementNode.setStateAfter(this.stateAfter());
        }
        this.graph().removeFixed((FixedWithNextNode)this);
    }
}

