/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.fieldfolding;

import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.svm.core.graal.nodes.LazyConstantNode;
import com.oracle.svm.hosted.fieldfolding.MarkStaticFinalFieldInitializedNode;
import com.oracle.svm.hosted.fieldfolding.StaticFinalFieldFoldingFeature;
import java.util.Arrays;
import java.util.function.Supplier;
import jdk.vm.ci.meta.Assumptions;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.AbstractMergeNode;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.EndNode;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.IfNode;
import org.graalvm.compiler.nodes.LogicNode;
import org.graalvm.compiler.nodes.MergeNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.StateSplit;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.ValuePhiNode;
import org.graalvm.compiler.nodes.calc.IntegerEqualsNode;
import org.graalvm.compiler.nodes.extended.BranchProbabilityNode;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import org.graalvm.compiler.nodes.graphbuilderconf.NodePlugin;
import org.graalvm.compiler.nodes.java.LoadIndexedNode;
import org.graalvm.compiler.nodes.type.StampTool;

final class StaticFinalFieldFoldingNodePlugin
implements NodePlugin {
    private final StaticFinalFieldFoldingFeature feature;

    StaticFinalFieldFoldingNodePlugin(StaticFinalFieldFoldingFeature feature) {
        this.feature = feature;
    }

    public boolean handleLoadStaticField(GraphBuilderContext b, ResolvedJavaField field) {
        assert (field.isStatic());
        if (!field.isFinal()) {
            return false;
        }
        if (b.getMethod().isClassInitializer()) {
            return false;
        }
        final AnalysisField aField = StaticFinalFieldFoldingFeature.toAnalysisField(field);
        AnalysisMethod classInitializer = aField.getDeclaringClass().getClassInitializer();
        if (classInitializer == null) {
            return false;
        }
        classInitializer.ensureGraphParsed(this.feature.bb, false);
        JavaConstant initializedValue = this.feature.foldedFieldValues.get(aField);
        if (initializedValue == null) {
            return false;
        }
        Supplier<JavaConstant> fieldCheckIndexOrNullSupplier = new Supplier<JavaConstant>(){

            @Override
            public JavaConstant get() {
                if (((StaticFinalFieldFoldingNodePlugin)StaticFinalFieldFoldingNodePlugin.this).feature.fieldCheckIndexMap == null) {
                    return null;
                }
                return JavaConstant.forInt((int)((StaticFinalFieldFoldingNodePlugin)StaticFinalFieldFoldingNodePlugin.this).feature.fieldCheckIndexMap.get(aField));
            }
        };
        ValueNode initStatusArrayNode = b.add(LazyConstantNode.create(StampFactory.objectNonNull(), this.feature.fieldInitializationStatusArrayOrNullSupplier, b.getMetaAccess()));
        ValueNode fieldCheckIndexNode = b.add(LazyConstantNode.create((Stamp)StampFactory.forInteger((JavaKind)JavaKind.Int, (long)0L, (long)Integer.MAX_VALUE), fieldCheckIndexOrNullSupplier, b.getMetaAccess()));
        ValueNode fieldCheckStatusNode = b.add(LoadIndexedNode.create((Assumptions)b.getAssumptions(), (ValueNode)initStatusArrayNode, (ValueNode)fieldCheckIndexNode, null, (JavaKind)JavaKind.Boolean, (MetaAccessProvider)b.getMetaAccess(), (ConstantReflectionProvider)b.getConstantReflection()));
        LogicNode isUninitializedNode = (LogicNode)b.add((ValueNode)IntegerEqualsNode.create((ValueNode)fieldCheckStatusNode, (ValueNode)ConstantNode.forBoolean((boolean)false), (NodeView)NodeView.DEFAULT));
        JavaConstant uninitializedValue = b.getConstantReflection().readFieldValue(field, null);
        ConstantNode uninitializedValueNode = ConstantNode.forConstant((JavaConstant)uninitializedValue, (MetaAccessProvider)b.getMetaAccess());
        ConstantNode initializedValueNode = ConstantNode.forConstant((JavaConstant)initializedValue, (MetaAccessProvider)b.getMetaAccess());
        EndNode uninitializedEndNode = (EndNode)b.getGraph().add((Node)new EndNode());
        EndNode initializedEndNode = (EndNode)b.getGraph().add((Node)new EndNode());
        b.add((ValueNode)new IfNode(isUninitializedNode, (FixedNode)uninitializedEndNode, (FixedNode)initializedEndNode, BranchProbabilityNode.EXTREMELY_SLOW_PATH_PROFILE));
        MergeNode merge = (MergeNode)b.append((ValueNode)new MergeNode());
        merge.addForwardEnd(uninitializedEndNode);
        merge.addForwardEnd(initializedEndNode);
        ConstantNode[] phiValueNodes = new ConstantNode[]{uninitializedValueNode, initializedValueNode};
        ValuePhiNode phi = new ValuePhiNode(StampTool.meet(Arrays.asList(phiValueNodes)), (AbstractMergeNode)merge, (ValueNode[])phiValueNodes);
        b.setStateAfter((StateSplit)merge);
        b.addPush(field.getJavaKind(), (ValueNode)phi);
        return true;
    }

    public boolean handleStoreStaticField(GraphBuilderContext b, ResolvedJavaField field, ValueNode value) {
        assert (field.isStatic());
        if (!field.isFinal()) {
            return false;
        }
        b.add((ValueNode)new MarkStaticFinalFieldInitializedNode(field));
        return false;
    }
}

