/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.truffle.api;

import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.annotate.NeverInline;
import com.oracle.svm.core.annotate.RestrictHeapAccess;
import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.graal.snippets.SubstrateAllocationSnippets;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.snippets.SnippetRuntime;
import com.oracle.svm.core.snippets.SubstrateForeignCallTarget;
import com.oracle.svm.core.thread.JavaThreads;
import com.oracle.svm.core.threadlocal.FastThreadLocalFactory;
import com.oracle.svm.core.threadlocal.FastThreadLocalInt;
import com.oracle.svm.core.threadlocal.FastThreadLocalObject;
import com.oracle.svm.core.util.VMError;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.impl.ThreadLocalHandshake;
import com.oracle.truffle.api.nodes.Node;
import org.graalvm.nativeimage.CurrentIsolate;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public final class SubstrateThreadLocalHandshake
extends ThreadLocalHandshake {
    public static final SnippetRuntime.SubstrateForeignCallDescriptor FOREIGN_POLL = SnippetRuntime.findForeignCall(SubstrateThreadLocalHandshake.class, "pollStub", false, SubstrateAllocationSnippets.TLAB_LOCATIONS);
    static final SubstrateThreadLocalHandshake SINGLETON = new SubstrateThreadLocalHandshake();
    static final FastThreadLocalInt PENDING = (FastThreadLocalInt)FastThreadLocalFactory.createInt().setMaxOffset(63);
    static final FastThreadLocalObject<ThreadLocalHandshake.TruffleSafepointImpl> STATE = (FastThreadLocalObject)FastThreadLocalFactory.createObject(ThreadLocalHandshake.TruffleSafepointImpl.class).setMaxOffset(63);
    @Platforms(value={Platform.HOSTED_ONLY.class})
    static final ThreadLocal<Boolean> HOSTED_PENDING = ThreadLocal.withInitial(() -> Boolean.FALSE);
    @Platforms(value={Platform.HOSTED_ONLY.class})
    private static final ThreadLocal<ThreadLocalHandshake.TruffleSafepointImpl> HOSTED_STATE = ThreadLocal.withInitial(() -> SINGLETON.getThreadState(Thread.currentThread()));
    private static final boolean EXCEPTIONS_SUPPORTED = false;

    public void poll(Node location) {
        if (SubstrateUtil.HOSTED) {
            if (HOSTED_PENDING.get().booleanValue()) {
                SubstrateThreadLocalHandshake.invokeProcessHandshake(location);
            }
        } else if (PENDING.get() != 0) {
            SubstrateThreadLocalHandshake.invokeProcessHandshake(location);
        }
    }

    @SubstrateForeignCallTarget(stubCallingConvention=true)
    @Uninterruptible(reason="Must not contain safepoint checks", calleeMustBe=false)
    @NeverInline(value="Reads stack pointer")
    private static void pollStub(Object location) throws Throwable {
        try {
            SubstrateThreadLocalHandshake.invokeProcessHandshake(location);
        }
        catch (Throwable t) {
            Log.log().string("Warning: exceptions thrown in guest safepoints are currently ignored on SVM.").newline().flush();
            Log.log().exception(t);
            return;
        }
    }

    @Uninterruptible(reason="Used both from uninterruptable stub.", calleeMustBe=false)
    @RestrictHeapAccess(reason="Callee may allocate", access=RestrictHeapAccess.Access.UNRESTRICTED, overridesCallers=true)
    private static void invokeProcessHandshake(Object enclosingNode) {
        SINGLETON.processHandshake((Node)enclosingNode);
    }

    public void ensureThreadInitialized() {
        if (!SubstrateUtil.HOSTED) {
            STATE.set(this.getThreadState(Thread.currentThread()));
        }
    }

    public ThreadLocalHandshake.TruffleSafepointImpl getCurrent() {
        if (SubstrateUtil.HOSTED) {
            return HOSTED_STATE.get();
        }
        ThreadLocalHandshake.TruffleSafepointImpl state = STATE.get();
        assert (state != null);
        if (state == null) {
            throw CompilerDirectives.shouldNotReachHere((String)"Thread local handshake is not initialized for this thread. Did you call getCurrent() outside while a polyglot context not entered?");
        }
        return state;
    }

    protected void clearFastPending() {
        if (SubstrateUtil.HOSTED) {
            HOSTED_PENDING.set(Boolean.FALSE);
        } else {
            PENDING.setVolatile(CurrentIsolate.getCurrentThread(), 0);
        }
    }

    protected void setFastPending(Thread t) {
        if (SubstrateUtil.HOSTED) {
            HOSTED_PENDING.set(Boolean.TRUE);
        } else {
            assert (t.isAlive()) : "thread must remain alive while setting fast pending";
            IsolateThread isolateThread = JavaThreads.getIsolateThreadUnsafe(t);
            VMError.guarantee(isolateThread.isNonNull(), "Java thread must remain alive.");
            PENDING.setVolatile(isolateThread, 1);
        }
    }
}

