/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.code.FrameInfoQueryResult;
import com.oracle.svm.core.jdk.BuildStackTraceVisitor;
import com.oracle.svm.core.jdk.GetCallerClassVisitor;
import com.oracle.svm.core.jdk.GetClassContextVisitor;
import com.oracle.svm.core.jdk.GetLatestUserDefinedClassLoaderVisitor;
import com.oracle.svm.core.jdk.InternalVMMethod;
import com.oracle.svm.core.jdk.LambdaFormHiddenMethod;
import com.oracle.svm.core.stack.JavaStackWalker;
import com.oracle.svm.core.thread.JavaContinuations;
import com.oracle.svm.core.thread.Target_java_lang_Continuation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.util.DirectAnnotationAccess;
import org.graalvm.word.Pointer;

public class StackTraceUtils {
    private static final Class<?>[] NO_CLASSES = new Class[0];
    private static final StackTraceElement[] NO_ELEMENTS = new StackTraceElement[0];

    public static StackTraceElement[] getStackTrace(boolean filterExceptions, Pointer startSP) {
        BuildStackTraceVisitor visitor = new BuildStackTraceVisitor(filterExceptions, SubstrateOptions.MaxJavaStackTraceDepth.getValue());
        JavaStackWalker.walkCurrentThread(startSP, visitor);
        return visitor.trace.toArray(NO_ELEMENTS);
    }

    public static StackTraceElement[] getStackTrace(boolean filterExceptions, IsolateThread thread) {
        BuildStackTraceVisitor visitor = new BuildStackTraceVisitor(filterExceptions, SubstrateOptions.MaxJavaStackTraceDepth.getValue());
        JavaStackWalker.walkThread(thread, visitor);
        return visitor.trace.toArray(NO_ELEMENTS);
    }

    public static Class<?>[] getClassContext(int skip, Pointer startSP) {
        GetClassContextVisitor visitor = new GetClassContextVisitor(skip);
        JavaStackWalker.walkCurrentThread(startSP, visitor);
        return visitor.trace.toArray(NO_CLASSES);
    }

    public static Class<?> getCallerClass(Pointer startSP, boolean showLambdaFrames) {
        return StackTraceUtils.getCallerClass(startSP, showLambdaFrames, 0, true);
    }

    public static Class<?> getCallerClass(Pointer startSP, boolean showLambdaFrames, int depth, boolean ignoreFirst) {
        GetCallerClassVisitor visitor = new GetCallerClassVisitor(showLambdaFrames, depth, ignoreFirst);
        JavaStackWalker.walkCurrentThread(startSP, visitor);
        return visitor.result;
    }

    public static boolean shouldShowFrame(FrameInfoQueryResult frameInfo, boolean showLambdaFrames, boolean showReflectFrames, boolean showHiddenFrames) {
        if (showHiddenFrames) {
            return true;
        }
        Class<?> clazz = frameInfo.getSourceClass();
        if (clazz == null) {
            return false;
        }
        if (DirectAnnotationAccess.isAnnotationPresent(clazz, InternalVMMethod.class)) {
            return false;
        }
        if (!showLambdaFrames && DirectAnnotationAccess.isAnnotationPresent(clazz, LambdaFormHiddenMethod.class)) {
            return false;
        }
        if (!showReflectFrames && (clazz == Method.class && "invoke".equals(frameInfo.getSourceMethodName()) || clazz == Constructor.class && "newInstance".equals(frameInfo.getSourceMethodName()) || clazz == Class.class && "newInstance".equals(frameInfo.getSourceMethodName()))) {
            return false;
        }
        if (JavaContinuations.useLoom() && clazz == Target_java_lang_Continuation.class) {
            if ("enterSpecial".equals(frameInfo.getSourceMethodName())) {
                return false;
            }
            if ("doYield".equals(frameInfo.getSourceMethodName())) {
                return false;
            }
        }
        return true;
    }

    public static boolean shouldShowFrame(MetaAccessProvider metaAccess, ResolvedJavaMethod method, boolean showLambdaFrames, boolean showReflectFrames, boolean showHiddenFrames) {
        if (showHiddenFrames) {
            return true;
        }
        ResolvedJavaType clazz = method.getDeclaringClass();
        if (DirectAnnotationAccess.isAnnotationPresent((AnnotatedElement)clazz, InternalVMMethod.class)) {
            return false;
        }
        if (!showLambdaFrames && DirectAnnotationAccess.isAnnotationPresent((AnnotatedElement)clazz, LambdaFormHiddenMethod.class)) {
            return false;
        }
        return showReflectFrames || !(clazz.equals(metaAccess.lookupJavaType(Method.class)) && "invoke".equals(method.getName()) || clazz.equals(metaAccess.lookupJavaType(Constructor.class)) && "newInstance".equals(method.getName())) && (!clazz.equals(metaAccess.lookupJavaType(Class.class)) || !"newInstance".equals(method.getName()));
    }

    public static boolean ignoredBySecurityStackWalk(MetaAccessProvider metaAccess, ResolvedJavaMethod method) {
        return !StackTraceUtils.shouldShowFrame(metaAccess, method, true, false, false);
    }

    public static ClassLoader latestUserDefinedClassLoader(Pointer startSP) {
        GetLatestUserDefinedClassLoaderVisitor visitor = new GetLatestUserDefinedClassLoaderVisitor();
        JavaStackWalker.walkCurrentThread(startSP, visitor);
        return visitor.result;
    }
}

