/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.snippets;

import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.graal.meta.SubstrateForeignCallsProvider;
import com.oracle.svm.core.graal.snippets.SubstrateAllocationSnippets;
import com.oracle.svm.core.snippets.SubstrateForeignCallTarget;
import com.oracle.svm.core.util.VMError;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.core.common.spi.ForeignCallDescriptor;
import org.graalvm.compiler.replacements.nodes.BinaryMathIntrinsicNode;
import org.graalvm.compiler.replacements.nodes.UnaryMathIntrinsicNode;
import org.graalvm.util.DirectAnnotationAccess;
import org.graalvm.word.LocationIdentity;

public class SnippetRuntime {
    public static final SubstrateForeignCallDescriptor UNSUPPORTED_FEATURE = SnippetRuntime.findForeignCall(SnippetRuntime.class, "unsupportedFeature", true, LocationIdentity.any());
    private static final SubstrateForeignCallDescriptor REGISTER_FINALIZER = SnippetRuntime.findForeignCall(SnippetRuntime.class, "registerFinalizer", true, new LocationIdentity[0]);
    private static final SubstrateForeignCallDescriptor ARITHMETIC_SIN = SnippetRuntime.findForeignJdkCall(UnaryMathIntrinsicNode.UnaryOperation.SIN.foreignCallSignature.getName(), Math.class, "sin", true, true, true, new LocationIdentity[0]);
    private static final SubstrateForeignCallDescriptor ARITHMETIC_COS = SnippetRuntime.findForeignJdkCall(UnaryMathIntrinsicNode.UnaryOperation.COS.foreignCallSignature.getName(), Math.class, "cos", true, true, true, new LocationIdentity[0]);
    private static final SubstrateForeignCallDescriptor ARITHMETIC_TAN = SnippetRuntime.findForeignJdkCall(UnaryMathIntrinsicNode.UnaryOperation.TAN.foreignCallSignature.getName(), Math.class, "tan", true, true, true, new LocationIdentity[0]);
    private static final SubstrateForeignCallDescriptor ARITHMETIC_LOG = SnippetRuntime.findForeignJdkCall(UnaryMathIntrinsicNode.UnaryOperation.LOG.foreignCallSignature.getName(), Math.class, "log", true, true, true, new LocationIdentity[0]);
    private static final SubstrateForeignCallDescriptor ARITHMETIC_LOG10 = SnippetRuntime.findForeignJdkCall(UnaryMathIntrinsicNode.UnaryOperation.LOG10.foreignCallSignature.getName(), Math.class, "log10", true, true, true, new LocationIdentity[0]);
    private static final SubstrateForeignCallDescriptor ARITHMETIC_EXP = SnippetRuntime.findForeignJdkCall(UnaryMathIntrinsicNode.UnaryOperation.EXP.foreignCallSignature.getName(), Math.class, "exp", true, true, true, new LocationIdentity[0]);
    private static final SubstrateForeignCallDescriptor ARITHMETIC_POW = SnippetRuntime.findForeignJdkCall(BinaryMathIntrinsicNode.BinaryOperation.POW.foreignCallSignature.getName(), Math.class, "pow", true, true, true, new LocationIdentity[0]);
    private static final SubstrateForeignCallDescriptor[] FOREIGN_CALLS = new SubstrateForeignCallDescriptor[]{UNSUPPORTED_FEATURE, REGISTER_FINALIZER, ARITHMETIC_SIN, ARITHMETIC_COS, ARITHMETIC_TAN, ARITHMETIC_LOG, ARITHMETIC_LOG10, ARITHMETIC_EXP, ARITHMETIC_POW};

    public static void registerForeignCalls(SubstrateForeignCallsProvider foreignCalls) {
        SubstrateAllocationSnippets.registerForeignCalls(foreignCalls);
        foreignCalls.register(FOREIGN_CALLS);
    }

    public static SubstrateForeignCallDescriptor findForeignCall(Class<?> declaringClass, String methodName, boolean isReexecutable, LocationIdentity ... additionalKilledLocations) {
        return SnippetRuntime.findForeignCall(methodName, declaringClass, methodName, isReexecutable, additionalKilledLocations);
    }

    private static SubstrateForeignCallDescriptor findForeignCall(String descriptorName, Class<?> declaringClass, String methodName, boolean isReexecutable, LocationIdentity ... additionalKilledLocations) {
        Method method = SnippetRuntime.findMethod(declaringClass, methodName);
        SubstrateForeignCallTarget foreignCallTargetAnnotation = (SubstrateForeignCallTarget)DirectAnnotationAccess.getAnnotation((AnnotatedElement)method, SubstrateForeignCallTarget.class);
        VMError.guarantee(foreignCallTargetAnnotation != null, "Add missing @SubstrateForeignCallTarget to " + declaringClass.getName() + "." + methodName);
        boolean isUninterruptible = Uninterruptible.Utils.isUninterruptible(method);
        boolean isFullyUninterruptible = foreignCallTargetAnnotation.fullyUninterruptible();
        return SnippetRuntime.findForeignCall(descriptorName, method, isReexecutable, isUninterruptible, isFullyUninterruptible, additionalKilledLocations);
    }

    private static SubstrateForeignCallDescriptor findForeignJdkCall(String descriptorName, Class<?> declaringClass, String methodName, boolean isReexecutable, boolean isUninterruptible, boolean isFullyUninterruptible, LocationIdentity ... additionalKilledLocations) {
        Method method = SnippetRuntime.findMethod(declaringClass, methodName);
        SubstrateForeignCallTarget foreignCallTargetAnnotation = (SubstrateForeignCallTarget)DirectAnnotationAccess.getAnnotation((AnnotatedElement)method, SubstrateForeignCallTarget.class);
        VMError.guarantee(foreignCallTargetAnnotation == null, declaringClass.getName() + "." + methodName + " must not be annotated with @SubstrateForeignCallTarget.");
        return SnippetRuntime.findForeignCall(descriptorName, method, isReexecutable, isUninterruptible, isFullyUninterruptible, additionalKilledLocations);
    }

    private static SubstrateForeignCallDescriptor findForeignCall(String descriptorName, Method method, boolean isReexecutable, boolean isUninterruptible, boolean isFullyUninterruptible, LocationIdentity ... additionalKilledLocations) {
        LocationIdentity[] killedLocations;
        if (isFullyUninterruptible) {
            VMError.guarantee(isUninterruptible, method.toString() + " is fully uninterruptible but not annotated with @Uninterruptible.");
            killedLocations = additionalKilledLocations;
        } else if (additionalKilledLocations.length == 0 || additionalKilledLocations == SubstrateAllocationSnippets.TLAB_LOCATIONS) {
            killedLocations = SubstrateAllocationSnippets.TLAB_LOCATIONS;
        } else if (SnippetRuntime.containsAny(additionalKilledLocations)) {
            killedLocations = additionalKilledLocations;
        } else {
            killedLocations = new LocationIdentity[SubstrateAllocationSnippets.TLAB_LOCATIONS.length + additionalKilledLocations.length];
            System.arraycopy(SubstrateAllocationSnippets.TLAB_LOCATIONS, 0, killedLocations, 0, SubstrateAllocationSnippets.TLAB_LOCATIONS.length);
            System.arraycopy(additionalKilledLocations, 0, killedLocations, SubstrateAllocationSnippets.TLAB_LOCATIONS.length, additionalKilledLocations.length);
        }
        boolean needsDebugInfo = !isFullyUninterruptible;
        boolean isGuaranteedSafepoint = !isUninterruptible;
        return new SubstrateForeignCallDescriptor(descriptorName, method, isReexecutable, killedLocations, needsDebugInfo, isGuaranteedSafepoint);
    }

    private static Method findMethod(Class<?> declaringClass, String methodName) {
        Method foundMethod = null;
        for (Method method : declaringClass.getDeclaredMethods()) {
            if (!method.getName().equals(methodName)) continue;
            assert (foundMethod == null) : "found more than one method " + declaringClass.getName() + "." + methodName;
            foundMethod = method;
        }
        assert (foundMethod != null) : "did not find method " + declaringClass.getName() + "." + methodName;
        return foundMethod;
    }

    private static boolean containsAny(LocationIdentity[] locations) {
        for (LocationIdentity location : locations) {
            if (!location.isAny()) continue;
            return true;
        }
        return false;
    }

    @SubstrateForeignCallTarget(stubCallingConvention=true)
    private static void unsupportedFeature(String msg) {
        throw VMError.unsupportedFeature(msg);
    }

    @SubstrateForeignCallTarget(stubCallingConvention=true)
    private static void registerFinalizer(Object obj) {
    }

    public static class SubstrateForeignCallDescriptor
    extends ForeignCallDescriptor {
        private final Class<?> declaringClass;
        private final String methodName;

        SubstrateForeignCallDescriptor(String descriptorName, Method method, boolean isReexecutable, LocationIdentity[] killedLocations, boolean needsDebugInfo, boolean isGuaranteedSafepoint) {
            super(descriptorName, method.getReturnType(), (Class[])method.getParameterTypes(), isReexecutable, killedLocations, needsDebugInfo, isGuaranteedSafepoint);
            this.declaringClass = method.getDeclaringClass();
            this.methodName = method.getName();
        }

        public Class<?> getDeclaringClass() {
            return this.declaringClass;
        }

        public ResolvedJavaMethod findMethod(MetaAccessProvider metaAccess) {
            for (Method method : this.declaringClass.getDeclaredMethods()) {
                if (!method.getName().equals(this.methodName)) continue;
                return metaAccess.lookupJavaMethod((Executable)method);
            }
            throw VMError.shouldNotReachHere("method " + this.methodName + " not found");
        }

        public boolean needsDebugInfo() {
            return this.canDeoptimize();
        }
    }
}

