/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.ameta;

import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisMetaAccess;
import com.oracle.graal.pointsto.meta.AnalysisUniverse;
import com.oracle.svm.core.meta.ReadableJavaField;
import com.oracle.svm.hosted.SVMHost;
import com.oracle.svm.hosted.ameta.AnalysisConstantReflectionProvider;
import com.oracle.svm.hosted.classinitialization.ClassInitializationSupport;
import com.oracle.svm.hosted.meta.SharedConstantFieldProvider;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import org.graalvm.compiler.core.common.spi.ConstantFieldProvider;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

@Platforms(value={Platform.HOSTED_ONLY.class})
public class AnalysisConstantFieldProvider
extends SharedConstantFieldProvider {
    private final AnalysisUniverse universe;
    private final AnalysisMetaAccess metaAccess;
    private final AnalysisConstantReflectionProvider constantReflection;

    public AnalysisConstantFieldProvider(AnalysisUniverse universe, AnalysisMetaAccess metaAccess, AnalysisConstantReflectionProvider constantReflection, ClassInitializationSupport classInitializationSupport) {
        super((MetaAccessProvider)metaAccess, classInitializationSupport);
        this.universe = universe;
        this.metaAccess = metaAccess;
        this.constantReflection = constantReflection;
    }

    public <T> T readConstantField(ResolvedJavaField field, ConstantFieldProvider.ConstantFieldTool<T> analysisTool) {
        AnalysisField f = (AnalysisField)field;
        if (SVMHost.isUnknownObjectField((ResolvedJavaField)f) || SVMHost.isUnknownPrimitiveField(f)) {
            return null;
        }
        if (f.wrapped instanceof ReadableJavaField) {
            JavaConstant fieldValue;
            ReadableJavaField readableField = (ReadableJavaField)f.wrapped;
            if (readableField.allowConstantFolding() && (fieldValue = readableField.readValue((MetaAccessProvider)this.metaAccess, this.universe.toHosted(analysisTool.getReceiver()))) != null) {
                return (T)analysisTool.foldConstant(this.constantReflection.interceptValue(f, this.universe.lookup(fieldValue)));
            }
            return null;
        }
        return (T)super.readConstantField(field, analysisTool);
    }
}

