/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix.linux;

import com.oracle.svm.core.c.libc.LibCBase;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.headers.LibCSupport;
import com.oracle.svm.core.os.ImageHeapProvider;
import com.oracle.svm.core.posix.linux.BionicLibCSupport;
import com.oracle.svm.core.posix.linux.LinuxImageHeapProvider;
import com.oracle.svm.core.posix.linux.LinuxLibCSupport;
import com.oracle.svm.core.posix.linux.libc.BionicLibC;
import com.oracle.svm.core.posix.linux.libc.LibCFeature;
import java.util.Collections;
import java.util.List;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticallyRegisteredFeature
class LinuxImageSingletonsFeature
implements InternalFeature {
    LinuxImageSingletonsFeature() {
    }

    public List<Class<? extends Feature>> getRequiredFeatures() {
        return Collections.singletonList(LibCFeature.class);
    }

    public void afterRegistration(Feature.AfterRegistrationAccess access) {
        if (LibCBase.singleton() instanceof BionicLibC) {
            ImageSingletons.add(LibCSupport.class, (Object)new BionicLibCSupport());
        } else {
            ImageSingletons.add(LibCSupport.class, (Object)new LinuxLibCSupport());
        }
    }

    public void duringSetup(Feature.DuringSetupAccess access) {
        if (!ImageSingletons.contains(ImageHeapProvider.class)) {
            ImageSingletons.add(ImageHeapProvider.class, (Object)new LinuxImageHeapProvider());
        }
    }
}

