/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.code;

import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.svm.core.code.FrameInfoEncoder;
import com.oracle.svm.core.feature.AutomaticallyRegisteredImageSingleton;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.meta.HostedMethod;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.nodes.FrameState;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.nativeimage.ImageSingletons;

@AutomaticallyRegisteredImageSingleton
public class CompilationInfoSupport {
    protected boolean sealed;
    private final Set<AnalysisMethod> forcedCompilations = ConcurrentHashMap.newKeySet();
    private final Set<AnalysisMethod> frameInformationRequired = ConcurrentHashMap.newKeySet();
    private final Map<AnalysisMethod, Map<Long, DeoptSourceFrameInfo>> deoptEntries = new ConcurrentHashMap<AnalysisMethod, Map<Long, DeoptSourceFrameInfo>>();
    private final Set<AnalysisMethod> deoptInliningExcludes = ConcurrentHashMap.newKeySet();

    public static CompilationInfoSupport singleton() {
        return (CompilationInfoSupport)ImageSingletons.lookup(CompilationInfoSupport.class);
    }

    public void registerForcedCompilation(ResolvedJavaMethod method) {
        assert (!this.sealed);
        this.forcedCompilations.add(CompilationInfoSupport.toAnalysisMethod(method));
    }

    public boolean isForcedCompilation(ResolvedJavaMethod method) {
        assert (this.seal());
        return this.forcedCompilations.contains(CompilationInfoSupport.toAnalysisMethod(method));
    }

    public void registerFrameInformationRequired(AnalysisMethod method) {
        assert (!this.sealed);
        this.frameInformationRequired.add(method);
        this.deoptEntries.computeIfAbsent(method, m -> new ConcurrentHashMap());
    }

    public boolean isFrameInformationRequired(ResolvedJavaMethod method) {
        assert (this.seal());
        return this.frameInformationRequired.contains(CompilationInfoSupport.toAnalysisMethod(method));
    }

    public void registerDeoptEntry(FrameState state) {
        assert (!this.sealed);
        assert (state.bci >= 0);
        long encodedBci = FrameInfoEncoder.encodeBci(state.bci, state.duringCall(), state.rethrowException());
        Map sourceFrameInfoMap = this.deoptEntries.computeIfAbsent(CompilationInfoSupport.toAnalysisMethod(state.getMethod()), m -> new ConcurrentHashMap());
        sourceFrameInfoMap.compute(encodedBci, (k, v) -> v == null ? DeoptSourceFrameInfo.create(state) : v.mergeStateInfo(state));
    }

    public boolean isDeoptTarget(ResolvedJavaMethod method) {
        assert (this.seal());
        return this.deoptEntries.containsKey(CompilationInfoSupport.toAnalysisMethod(method));
    }

    protected boolean isDeoptEntry(ResolvedJavaMethod method, int bci, boolean duringCall, boolean rethrowException) {
        assert (this.seal());
        Map<Long, DeoptSourceFrameInfo> bciMap = this.deoptEntries.get(CompilationInfoSupport.toAnalysisMethod(method));
        assert (bciMap != null) : "can only query for deopt entries for methods registered as deopt targets";
        long encodedBci = FrameInfoEncoder.encodeBci(bci, duringCall, rethrowException);
        return bciMap.containsKey(encodedBci);
    }

    public void registerAsDeoptInlininingExclude(ResolvedJavaMethod method) {
        assert (!this.sealed);
        this.deoptInliningExcludes.add(CompilationInfoSupport.toAnalysisMethod(method));
    }

    public boolean isDeoptInliningExclude(ResolvedJavaMethod method) {
        assert (this.seal());
        return this.deoptInliningExcludes.contains(CompilationInfoSupport.toAnalysisMethod(method));
    }

    public Map<AnalysisMethod, Map<Long, DeoptSourceFrameInfo>> getDeoptEntries() {
        assert (this.seal());
        return this.deoptEntries;
    }

    private static AnalysisMethod toAnalysisMethod(ResolvedJavaMethod method) {
        if (method instanceof AnalysisMethod) {
            return (AnalysisMethod)method;
        }
        if (method instanceof HostedMethod) {
            return ((HostedMethod)method).wrapped;
        }
        throw VMError.shouldNotReachHere();
    }

    private boolean seal() {
        this.sealed = true;
        return true;
    }

    public static final class DeoptSourceFrameInfo {
        public final JavaKind[] expectedKinds;
        public final int numLocals;
        public final int numStack;
        public final int numLocks;
        public static final DeoptSourceFrameInfo INVALID_DEOPT_SOURCE_FRAME = new DeoptSourceFrameInfo(null, 0, 0, 0);

        private DeoptSourceFrameInfo(JavaKind[] expectedKinds, int numLocals, int numStack, int numLocks) {
            this.expectedKinds = expectedKinds;
            this.numLocals = numLocals;
            this.numStack = numStack;
            this.numLocks = numLocks;
        }

        public static DeoptSourceFrameInfo create(FrameState state) {
            return new DeoptSourceFrameInfo(DeoptSourceFrameInfo.getKinds(state), state.localsSize(), state.stackSize(), state.locksSize());
        }

        private static JavaKind[] getKinds(FrameState state) {
            int i;
            JavaKind[] kinds = new JavaKind[state.locksSize() + state.stackSize() + state.localsSize()];
            int index = 0;
            for (i = 0; i < state.localsSize(); ++i) {
                kinds[index++] = DeoptSourceFrameInfo.getKind(state.localAt(i));
            }
            for (i = 0; i < state.stackSize(); ++i) {
                kinds[index++] = DeoptSourceFrameInfo.getKind(state.stackAt(i));
            }
            for (i = 0; i < state.locksSize(); ++i) {
                kinds[index++] = DeoptSourceFrameInfo.getKind(state.lockAt(i));
            }
            return kinds;
        }

        private static JavaKind getKind(ValueNode value) {
            if (value == null) {
                return JavaKind.Illegal;
            }
            return value.getStackKind();
        }

        public DeoptSourceFrameInfo mergeStateInfo(FrameState state) {
            boolean matchingSizes;
            if (this == INVALID_DEOPT_SOURCE_FRAME) {
                return this;
            }
            JavaKind[] otherKinds = DeoptSourceFrameInfo.getKinds(state);
            boolean bl = matchingSizes = this.numLocals == state.localsSize() && this.numStack == state.stackSize() && this.numLocks == state.locksSize() && this.expectedKinds.length == otherKinds.length;
            if (!matchingSizes) {
                return INVALID_DEOPT_SOURCE_FRAME;
            }
            for (int i = 0; i < this.expectedKinds.length; ++i) {
                JavaKind current = this.expectedKinds[i];
                JavaKind other = otherKinds[i];
                if (current == JavaKind.Illegal || current == other) continue;
                this.expectedKinds[i] = JavaKind.Illegal;
            }
            return this;
        }
    }
}

