/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.common;

import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.common.EconomicMapStorage;
import com.oracle.graal.python.builtins.objects.common.EmptyStorage;
import com.oracle.graal.python.builtins.objects.common.HashingCollectionNodesFactory;
import com.oracle.graal.python.builtins.objects.common.HashingStorage;
import com.oracle.graal.python.builtins.objects.common.HashingStorageNodes;
import com.oracle.graal.python.builtins.objects.common.ObjectHashMap;
import com.oracle.graal.python.builtins.objects.common.PHashingCollection;
import com.oracle.graal.python.builtins.objects.dict.DictNodes;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.builtins.objects.dict.PDictView;
import com.oracle.graal.python.lib.GetNextNode;
import com.oracle.graal.python.lib.PyObjectGetIter;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.object.BuiltinClassProfiles;
import com.oracle.graal.python.nodes.util.CastToTruffleStringNode;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedLoopConditionProfile;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.api.strings.TruffleStringIterator;

public abstract class HashingCollectionNodes {

    @GenerateInline(inlineByDefault=true)
    public static abstract class GetSetStorageNode
    extends PNodeWithContext {
        public abstract HashingStorage execute(VirtualFrame var1, Node var2, Object var3);

        public final HashingStorage executeCached(VirtualFrame frame, Object iterator) {
            return this.execute(frame, this, iterator);
        }

        @Specialization
        static HashingStorage doHashingCollection(PHashingCollection other) {
            return other.getDictStorage();
        }

        @Specialization
        static HashingStorage doPDictView(PDictView.PDictKeysView other) {
            return other.getWrappedStorage();
        }

        @Specialization(guards={"!isPHashingCollection(other)", "!isDictKeysView(other)"})
        @HostCompilerDirectives.InliningCutoff
        static HashingStorage doGeneric(VirtualFrame frame, Node inliningTarget, Object other, @Cached GetClonedHashingStorageNode getHashingStorageNode) {
            return getHashingStorageNode.doNoValue(frame, inliningTarget, other);
        }
    }

    @GenerateInline(inlineByDefault=true)
    public static abstract class GetClonedHashingStorageNode
    extends PNodeWithContext {
        public abstract HashingStorage execute(VirtualFrame var1, Node var2, Object var3, Object var4);

        public final HashingStorage doNoValue(VirtualFrame frame, Node inliningTarget, Object iterator) {
            return this.execute(frame, inliningTarget, iterator, PNone.NO_VALUE);
        }

        public final HashingStorage doNoValueCached(VirtualFrame frame, Object iterator) {
            return this.execute(frame, null, iterator, PNone.NO_VALUE);
        }

        @Specialization(guards={"isNoValue(value)"})
        static HashingStorage doHashingCollectionNoValue(Node inliningTarget, PHashingCollection other, Object value, @Cached.Shared(value="copyNode") @Cached HashingStorageNodes.HashingStorageCopy copyNode) {
            return copyNode.execute(inliningTarget, other.getDictStorage());
        }

        @Specialization(guards={"isNoValue(value)"})
        static HashingStorage doPDictKeyViewNoValue(Node inliningTarget, PDictView.PDictKeysView other, Object value, @Cached.Shared(value="copyNode") @Cached HashingStorageNodes.HashingStorageCopy copyNode) {
            return copyNode.execute(inliningTarget, other.getWrappedStorage());
        }

        @Specialization(guards={"!isNoValue(value)"})
        static HashingStorage doHashingCollection(VirtualFrame frame, PHashingCollection other, Object value, @Cached.Shared @Cached(inline=false) GetClonedHashingCollectionNode hashingCollectionNode) {
            return hashingCollectionNode.execute(frame, other.getDictStorage(), value);
        }

        @Specialization(guards={"!isNoValue(value)"})
        static HashingStorage doPDictView(VirtualFrame frame, PDictView.PDictKeysView other, Object value, @Cached.Shared @Cached(inline=false) GetClonedHashingCollectionNode hashingCollectionNode) {
            return hashingCollectionNode.execute(frame, other.getWrappedStorage(), value);
        }

        @Specialization(guards={"isString(strObj)"})
        @HostCompilerDirectives.InliningCutoff
        static HashingStorage doString(Node inliningTarget, Object strObj, Object value, @Cached CastToTruffleStringNode castToStringNode, @Cached.Exclusive @Cached HashingStorageNodes.HashingStorageSetItem setStorageItem, @Cached(inline=false) TruffleString.CodePointLengthNode codePointLengthNode, @Cached(inline=false) TruffleString.CreateCodePointIteratorNode createCodePointIteratorNode, @Cached(inline=false) TruffleStringIterator.NextNode nextNode, @Cached(inline=false) TruffleString.FromCodePointNode fromCodePointNode) {
            TruffleString str = castToStringNode.execute(inliningTarget, strObj);
            HashingStorage storage = PDict.createNewStorage(codePointLengthNode.execute((AbstractTruffleString)str, PythonUtils.TS_ENCODING));
            Object val = value == PNone.NO_VALUE ? PNone.NONE : value;
            TruffleStringIterator it = createCodePointIteratorNode.execute((AbstractTruffleString)str, PythonUtils.TS_ENCODING);
            while (it.hasNext()) {
                int codePoint = nextNode.execute(it);
                TruffleString key = fromCodePointNode.execute(codePoint, PythonUtils.TS_ENCODING, true);
                storage = setStorageItem.execute(inliningTarget, storage, key, val);
            }
            return storage;
        }

        @Specialization(guards={"!isPHashingCollection(other)", "!isDictKeysView(other)", "!isString(other)"})
        @HostCompilerDirectives.InliningCutoff
        static HashingStorage doIterable(VirtualFrame frame, Node inliningTarget, Object other, Object value, @Cached PyObjectGetIter getIter, @Cached(inline=false) GetNextNode nextNode, @Cached BuiltinClassProfiles.IsBuiltinObjectProfile errorProfile, @Cached.Exclusive @Cached HashingStorageNodes.HashingStorageSetItem setStorageItem) {
            HashingStorage curStorage = EmptyStorage.INSTANCE;
            Object iterator = getIter.execute((Frame)frame, inliningTarget, other);
            Object val = value == PNone.NO_VALUE ? PNone.NONE : value;
            while (true) {
                Object key;
                try {
                    key = nextNode.execute((Frame)frame, iterator);
                }
                catch (PException e) {
                    e.expectStopIteration(inliningTarget, errorProfile);
                    return curStorage;
                }
                curStorage = setStorageItem.execute((Frame)frame, inliningTarget, curStorage, key, val);
            }
        }

        @NeverDefault
        public static GetClonedHashingStorageNode create() {
            return HashingCollectionNodesFactory.GetClonedHashingStorageNodeGen.create();
        }

        @GenerateInline(value=false)
        static abstract class GetClonedHashingCollectionNode
        extends Node {
            GetClonedHashingCollectionNode() {
            }

            abstract HashingStorage execute(VirtualFrame var1, HashingStorage var2, Object var3);

            @Specialization
            static HashingStorage doHashingCollection(VirtualFrame frame, HashingStorage other, Object value, @Bind(value="this") Node inliningTarget, @Cached SetValueHashingStorageNode setValue, @Cached HashingStorageNodes.HashingStorageCopy copyNode) {
                assert (!PGuards.isNoValue(value));
                HashingStorage storage = copyNode.execute(inliningTarget, other);
                storage = setValue.execute(frame, inliningTarget, storage, value);
                return storage;
            }
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    @ImportStatic(value={PGuards.class})
    static abstract class SetValueHashingStorageNode
    extends PNodeWithContext {
        SetValueHashingStorageNode() {
        }

        abstract HashingStorage execute(VirtualFrame var1, Node var2, HashingStorage var3, Object var4);

        @Specialization
        static HashingStorage doEconomicStorage(VirtualFrame frame, Node inliningTarget, EconomicMapStorage map, Object value, @Cached.Shared(value="putNode") @Cached ObjectHashMap.PutNode putNode, @Cached.Shared(value="loopProfile") @Cached InlinedLoopConditionProfile loopProfile) {
            map.setValueForAllKeys(frame, inliningTarget, value, putNode, loopProfile);
            return map;
        }

        @Specialization(guards={"!isEconomicMapStorage(map)"})
        @HostCompilerDirectives.InliningCutoff
        static HashingStorage doGeneric(VirtualFrame frame, Node inliningTarget, HashingStorage map, Object value, @Cached HashingStorageNodes.HashingStorageSetItem setItem, @Cached HashingStorageNodes.HashingStorageGetIterator getIterator, @Cached HashingStorageNodes.HashingStorageIteratorNext itNext, @Cached HashingStorageNodes.HashingStorageIteratorKey itKey, @Cached.Shared(value="putNode") @Cached ObjectHashMap.PutNode putNode, @Cached.Shared(value="loopProfile") @Cached InlinedLoopConditionProfile loopProfile) {
            HashingStorageNodes.HashingStorageIterator it = getIterator.execute(inliningTarget, map);
            while (itNext.execute(inliningTarget, map, it)) {
                Object key = itKey.execute(inliningTarget, map, it);
                HashingStorage newStorage = setItem.execute((Frame)frame, inliningTarget, map, key, value);
                if (newStorage == map) continue;
                if (newStorage instanceof EconomicMapStorage) {
                    EconomicMapStorage mapStorage = (EconomicMapStorage)newStorage;
                    mapStorage.setValueForAllKeys(frame, inliningTarget, value, putNode, loopProfile);
                    return mapStorage;
                }
                throw CompilerDirectives.shouldNotReachHere((String)"We only generalize to EconomicMapStorage");
            }
            return map;
        }

        protected static boolean isEconomicMapStorage(Object o) {
            return o instanceof EconomicMapStorage;
        }
    }

    @GenerateUncached
    @GenerateInline(inlineByDefault=true)
    @GenerateCached
    @ImportStatic(value={PGuards.class})
    public static abstract class SetItemNode
    extends PNodeWithContext {
        public abstract void execute(Frame var1, Node var2, Object var3, Object var4, Object var5);

        public final void executeCached(Frame frame, Object c, Object key, Object value) {
            this.execute(frame, this, c, key, value);
        }

        @Specialization
        static void doSetItem(Frame frame, Node inliningTarget, Object c, Object key, Object value, @Cached DictNodes.GetDictStorageNode getStorageNode, @Cached DictNodes.UpdateDictStorageNode updateStorageNode, @Cached HashingStorageNodes.HashingStorageSetItem setItem) {
            HashingStorage storage = getStorageNode.execute(inliningTarget, c);
            HashingStorage newStorage = setItem.execute(frame, inliningTarget, storage, key, value);
            updateStorageNode.execute(inliningTarget, c, storage, newStorage);
        }

        @NeverDefault
        public static SetItemNode create() {
            return HashingCollectionNodesFactory.SetItemNodeGen.create();
        }

        @NeverDefault
        public static SetItemNode getUncached() {
            return HashingCollectionNodesFactory.SetItemNodeGen.getUncached();
        }
    }
}

