/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.compiler;

import com.oracle.graal.python.nodes.StringLiterals;
import com.oracle.graal.python.pegparser.PythonStringFactory;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.api.strings.TruffleStringBuilder;

class PythonStringFactoryImpl
implements PythonStringFactory<TruffleString> {
    PythonStringFactoryImpl() {
    }

    @Override
    public PythonStringFactory.PythonStringBuilder<TruffleString> createBuilder(int initialCodePointLength) {
        return new TruffleStringBuilderWrapper(PythonUtils.tsbCapacity(initialCodePointLength));
    }

    @Override
    public TruffleString fromJavaString(String s) {
        return TruffleString.fromJavaStringUncached((String)s, (TruffleString.Encoding)PythonUtils.TS_ENCODING);
    }

    @Override
    public TruffleString emptyString() {
        return StringLiterals.T_EMPTY_STRING;
    }

    private static class TruffleStringBuilderWrapper
    implements PythonStringFactory.PythonStringBuilder<TruffleString> {
        private final TruffleStringBuilder sb;

        TruffleStringBuilderWrapper(int initialCapacity) {
            this.sb = TruffleStringBuilder.create((TruffleString.Encoding)PythonUtils.TS_ENCODING, (int)initialCapacity);
        }

        @Override
        public PythonStringFactory.PythonStringBuilder<TruffleString> appendString(String s) {
            this.sb.appendStringUncached(TruffleString.fromJavaStringUncached((String)s, (TruffleString.Encoding)PythonUtils.TS_ENCODING));
            return this;
        }

        @Override
        public PythonStringFactory.PythonStringBuilder<TruffleString> appendPythonString(TruffleString s) {
            this.sb.appendStringUncached(s);
            return this;
        }

        @Override
        public PythonStringFactory.PythonStringBuilder<TruffleString> appendCodePoint(int codePoint) {
            this.sb.appendCodePointUncached(codePoint, 1, true);
            return this;
        }

        @Override
        public boolean isEmpty() {
            return this.sb.isEmpty();
        }

        @Override
        public TruffleString build() {
            return this.sb.toStringUncached();
        }
    }
}

