/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.lib;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.lib.PyLongAsIntNodeGen;
import com.oracle.graal.python.lib.PyLongAsLongAndOverflowNode;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.util.OverflowException;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;

@GenerateUncached
@GenerateCached(value=false)
@GenerateInline
public abstract class PyLongAsIntNode
extends PNodeWithContext {
    public static int executeUncached(Object o) {
        return PyLongAsIntNodeGen.getUncached().execute(null, null, o);
    }

    public abstract int execute(Frame var1, Node var2, Object var3);

    @Specialization
    static int doInt(int object) {
        return object;
    }

    @Specialization
    static int doObject(VirtualFrame frame, Node inliningTarget, Object object, @Cached PyLongAsLongAndOverflowNode pyLongAsLongAndOverflow, @Cached PRaiseNode.Lazy raiseNode) {
        try {
            long result = pyLongAsLongAndOverflow.execute((Frame)frame, inliningTarget, object);
            int intResult = (int)result;
            if ((long)intResult != result) {
                throw PyLongAsIntNode.raiseOverflow(inliningTarget, raiseNode);
            }
            return intResult;
        }
        catch (OverflowException e) {
            throw PyLongAsIntNode.raiseOverflow(inliningTarget, raiseNode);
        }
    }

    @HostCompilerDirectives.InliningCutoff
    private static PException raiseOverflow(Node inliningTarget, PRaiseNode.Lazy raiseNode) {
        throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.OverflowError, ErrorMessages.PYTHON_INT_TOO_LARGE_TO_CONV_TO, "Java int");
    }
}

