/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.cext;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.modules.BuiltinFunctions;
import com.oracle.graal.python.builtins.modules.PosixModuleBuiltins;
import com.oracle.graal.python.builtins.modules.SysModuleBuiltins;
import com.oracle.graal.python.builtins.modules.cext.PythonCextBuiltins;
import com.oracle.graal.python.builtins.modules.cext.PythonCextFileBuiltins;
import com.oracle.graal.python.builtins.modules.io.IONodes;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.cext.common.CExtCommonNodes;
import com.oracle.graal.python.builtins.objects.common.HashingStorageNodes;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.builtins.objects.exception.ExceptionNodes;
import com.oracle.graal.python.builtins.objects.exception.GetEscapedExceptionNode;
import com.oracle.graal.python.builtins.objects.exception.PBaseException;
import com.oracle.graal.python.builtins.objects.exception.PrepareExceptionNode;
import com.oracle.graal.python.builtins.objects.function.PKeyword;
import com.oracle.graal.python.builtins.objects.module.PythonModule;
import com.oracle.graal.python.builtins.objects.traceback.PTraceback;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.builtins.objects.type.TypeBuiltins;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.lib.PyDictSetItem;
import com.oracle.graal.python.lib.PyLongAsLongNode;
import com.oracle.graal.python.lib.PyLongCheckNode;
import com.oracle.graal.python.lib.PyObjectCallMethodObjArgs;
import com.oracle.graal.python.lib.PyObjectGetAttr;
import com.oracle.graal.python.lib.PyObjectLookupAttr;
import com.oracle.graal.python.lib.PyObjectSetAttr;
import com.oracle.graal.python.lib.PyObjectStrAsObjectNode;
import com.oracle.graal.python.nodes.BuiltinNames;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialAttributeNames;
import com.oracle.graal.python.nodes.WriteUnraisableNode;
import com.oracle.graal.python.nodes.attributes.WriteAttributeToObjectNode;
import com.oracle.graal.python.nodes.call.CallNode;
import com.oracle.graal.python.nodes.object.BuiltinClassProfiles;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.nodes.util.CannotCastException;
import com.oracle.graal.python.nodes.util.CastToTruffleStringNode;
import com.oracle.graal.python.nodes.util.ExceptionStateNodes;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.PythonOptions;
import com.oracle.graal.python.runtime.exception.ExceptionUtils;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.exception.AbstractTruffleException;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;

public final class PythonCextErrBuiltins {
    private static Object noneToNativeNull(Node node, Object obj) {
        return obj instanceof PNone ? PythonContext.get(node).getNativeNull() : obj;
    }

    static abstract class PyException_SetArgs
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        PyException_SetArgs() {
        }

        @Specialization
        static Object set(PBaseException exc, PTuple args, @Bind Node inliningTarget, @Cached ExceptionNodes.SetArgsNode setArgsNode) {
            setArgsNode.execute(inliningTarget, exc, args);
            return PNone.NO_VALUE;
        }
    }

    static abstract class PyException_GetArgs
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PyException_GetArgs() {
        }

        @Specialization
        static Object get(Object exc, @Bind Node inliningTarget, @Cached ExceptionNodes.GetArgsNode getArgsNode) {
            return getArgsNode.execute(inliningTarget, exc);
        }
    }

    static abstract class PyException_SetTraceback
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        PyException_SetTraceback() {
        }

        @Specialization
        Object setTraceback(Object exc, Object traceback, @Bind Node inliningTarget, @Cached PyObjectSetAttr setAttrNode) {
            setAttrNode.execute(inliningTarget, exc, SpecialAttributeNames.T___TRACEBACK__, traceback);
            return 0;
        }
    }

    static abstract class PyException_GetTraceback
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PyException_GetTraceback() {
        }

        @Specialization
        Object getTraceback(Object exc, @Bind Node inliningTarget, @Cached ExceptionNodes.GetTracebackNode getTracebackNode) {
            return PythonCextErrBuiltins.noneToNativeNull(inliningTarget, getTracebackNode.execute(inliningTarget, exc));
        }
    }

    static abstract class PyException_SetContext
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        PyException_SetContext() {
        }

        @Specialization
        Object setContext(Object exc, Object context, @Bind Node inliningTarget, @Cached ExceptionNodes.SetContextNode setContextNode) {
            setContextNode.execute(inliningTarget, exc, context != PNone.NO_VALUE ? context : PNone.NONE);
            return PNone.NO_VALUE;
        }
    }

    static abstract class PyException_GetContext
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PyException_GetContext() {
        }

        @Specialization
        Object setCause(Object exc, @Bind Node inliningTarget, @Cached ExceptionNodes.GetContextNode getContextNode) {
            return PythonCextErrBuiltins.noneToNativeNull(inliningTarget, getContextNode.execute(inliningTarget, exc));
        }
    }

    static abstract class PyException_GetCause
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PyException_GetCause() {
        }

        @Specialization
        Object getCause(Object exc, @Bind Node inliningTarget, @Cached ExceptionNodes.GetCauseNode getCauseNode) {
            return PythonCextErrBuiltins.noneToNativeNull(inliningTarget, getCauseNode.execute(inliningTarget, exc));
        }
    }

    static abstract class PyException_SetCause
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        PyException_SetCause() {
        }

        @Specialization
        Object setCause(Object exc, Object cause, @Bind Node inliningTarget, @Cached ExceptionNodes.SetCauseNode setCauseNode) {
            setCauseNode.execute(inliningTarget, exc, cause != PNone.NO_VALUE ? cause : PNone.NONE);
            return PNone.NO_VALUE;
        }
    }

    static abstract class PyErr_PrintEx
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PyErr_PrintEx() {
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        static Object print(int set_sys_last_vars, @Cached PythonCextFileBuiltins.PyFile_WriteObject writeFileNode, @Cached PosixModuleBuiltins.ExitNode exitNode, @Cached PyErr_Display errDisplayNode) {
            Object exceptHook;
            PythonContext context = PythonContext.get(null);
            PythonContext.PythonThreadState threadState = context.getThreadState(context.getLanguage());
            Object currentException = CExtCommonNodes.ReadAndClearNativeException.executeUncached(threadState);
            PythonModule sys = context.getSysModule();
            if (currentException == PNone.NO_VALUE) {
                return PNone.NONE;
            }
            if (BuiltinClassProfiles.IsBuiltinObjectProfile.profileObjectUncached(currentException, PythonBuiltinClassType.SystemExit)) {
                PyErr_PrintEx.handleSystemExit(currentException, (SysModuleBuiltins)sys.getBuiltins(), writeFileNode, exitNode);
            }
            Object type = GetClassNode.executeUncached(currentException);
            Object tb = ExceptionNodes.GetTracebackNode.executeUncached(currentException);
            if (set_sys_last_vars != 0) {
                PyErr_PrintEx.writeLastVars(sys, type, currentException, tb);
            }
            if ((exceptHook = PyObjectLookupAttr.executeUncached(sys, BuiltinNames.T_EXCEPTHOOK)) != PNone.NO_VALUE) {
                PyErr_PrintEx.handleExceptHook(exceptHook, type, currentException, tb, sys, errDisplayNode);
            }
            return PNone.NONE;
        }

        private static void writeLastVars(PythonModule sys, Object type, Object val, Object tb) {
            CompilerAsserts.neverPartOfCompilation();
            try {
                WriteAttributeToObjectNode.getUncached().execute(sys, BuiltinNames.T_LAST_TYPE, type);
                WriteAttributeToObjectNode.getUncached().execute(sys, BuiltinNames.T_LAST_VALUE, val);
                WriteAttributeToObjectNode.getUncached().execute(sys, BuiltinNames.T_LAST_TRACEBACK, tb);
            }
            catch (PException pException) {
                // empty catch block
            }
        }

        private static void handleExceptHook(Object exceptHook, Object type, Object val, Object tb, PythonModule sys, PyErr_Display errDisplayNode) {
            CompilerAsserts.neverPartOfCompilation();
            try {
                CallNode.executeUncached(exceptHook, type, val, tb);
            }
            catch (PException e) {
                Object stdErr = ((SysModuleBuiltins)sys.getBuiltins()).getStdErr();
                Object writeMethod = PyObjectGetAttr.executeUncached(stdErr, IONodes.T_WRITE);
                CallNode.executeUncached(writeMethod, PyObjectStrAsObjectNode.getUncached().execute(null, "Error in sys.excepthook:\n"));
                Object exc2 = e.getEscapedException();
                errDisplayNode.execute(GetClassNode.executeUncached(exc2), exc2, ExceptionNodes.GetTracebackNode.executeUncached(exc2));
                CallNode.executeUncached(writeMethod, PyObjectStrAsObjectNode.getUncached().execute(null, "\nOriginal exception was:\n"));
                errDisplayNode.execute(type, val, tb);
                PyObjectCallMethodObjArgs.executeUncached(stdErr, IONodes.T_FLUSH, new Object[0]);
            }
        }

        private static void handleSystemExit(Object currentException, SysModuleBuiltins sys, PythonCextFileBuiltins.PyFile_WriteObject writeFileNode, PosixModuleBuiltins.ExitNode exitNode) {
            CompilerAsserts.neverPartOfCompilation();
            int rc = 0;
            Object returnObject = null;
            Object codeAttr = PyObjectLookupAttr.executeUncached(currentException, PBaseException.T_CODE);
            if (!(codeAttr instanceof PNone)) {
                returnObject = codeAttr;
            }
            if (!(codeAttr instanceof PNone) && PyLongCheckNode.executeUncached(codeAttr)) {
                rc = (int)PyLongAsLongNode.executeUncached(codeAttr);
            } else {
                Object stdErr = sys.getStdErr();
                if (stdErr != null && stdErr != PNone.NONE) {
                    writeFileNode.execute(returnObject, stdErr, 1);
                } else {
                    Object stdOut = sys.getStdOut();
                    Object writeMethod = PyObjectGetAttr.executeUncached(stdOut, IONodes.T_WRITE);
                    CallNode.executeUncached(writeMethod, PyObjectStrAsObjectNode.getUncached().execute(null, returnObject));
                    PyObjectCallMethodObjArgs.executeUncached(stdOut, IONodes.T_FLUSH, new Object[0]);
                }
            }
            exitNode.execute(null, rc);
        }
    }

    static abstract class _PyErr_WriteUnraisableMsg
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        _PyErr_WriteUnraisableMsg() {
        }

        @Specialization
        static Object write(Object msg, Object obj, @Bind Node inliningTarget, @Cached PythonContext.GetThreadStateNode getThreadStateNode, @Cached WriteUnraisableNode writeUnraisableNode, @Cached CastToTruffleStringNode castToTruffleStringNode, @Cached CExtCommonNodes.ReadAndClearNativeException readAndClearNativeException) {
            TruffleString m;
            PythonContext.PythonThreadState threadState = getThreadStateNode.execute(inliningTarget, PythonContext.get(inliningTarget));
            Object currentException = readAndClearNativeException.execute(inliningTarget, threadState);
            if (currentException == PNone.NO_VALUE) {
                return PNone.NONE;
            }
            try {
                m = castToTruffleStringNode.execute(inliningTarget, msg);
            }
            catch (CannotCastException e) {
                m = null;
            }
            writeUnraisableNode.execute(currentException, m, obj == PNone.NO_VALUE ? PNone.NONE : obj);
            return PNone.NONE;
        }
    }

    static abstract class _PyErr_GetHandledException
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        _PyErr_GetHandledException() {
        }

        @Specialization
        static Object get(Object threadState, @Bind Node inliningTarget, @Cached ExceptionStateNodes.GetCaughtExceptionNode getCaughtExceptionNode, @Cached GetEscapedExceptionNode getEscapedExceptionNode) {
            AbstractTruffleException caughtException = getCaughtExceptionNode.executeFromNative();
            if (caughtException == null) {
                return PythonContext.get(inliningTarget).getNativeNull();
            }
            assert (caughtException != PException.NO_EXCEPTION);
            return getEscapedExceptionNode.execute(inliningTarget, caughtException);
        }
    }

    static abstract class GraalPyPrivate_Err_GetExcInfo
    extends PythonCextBuiltins.CApiNullaryBuiltinNode {
        GraalPyPrivate_Err_GetExcInfo() {
        }

        @Specialization
        Object info(@Bind Node inliningTarget, @Cached ExceptionStateNodes.GetCaughtExceptionNode getCaughtExceptionNode, @Cached GetClassNode getClassNode, @Cached ExceptionNodes.GetTracebackNode getTracebackNode, @Cached InlinedBranchProfile noExceptionProfile, @Cached GetEscapedExceptionNode getEscapedExceptionNode, @Bind PythonLanguage language) {
            AbstractTruffleException currentException = getCaughtExceptionNode.executeFromNative();
            if (currentException == null) {
                noExceptionProfile.enter(inliningTarget);
                return this.getNativeNull();
            }
            assert (currentException != PException.NO_EXCEPTION);
            Object exception = getEscapedExceptionNode.execute(inliningTarget, currentException);
            Object traceback = PythonCextErrBuiltins.noneToNativeNull(inliningTarget, getTracebackNode.execute(inliningTarget, exception));
            return PFactory.createTuple(language, new Object[]{getClassNode.execute(inliningTarget, exception), exception, traceback});
        }
    }

    static abstract class PyErr_NewExceptionWithDoc
    extends PythonCextBuiltins.CApiQuaternaryBuiltinNode {
        PyErr_NewExceptionWithDoc() {
        }

        @Specialization
        static Object raise(TruffleString name, Object doc, Object base, Object dict, @Cached PyErr_NewException newExNode, @Cached WriteAttributeToObjectNode writeAtrrNode, @Bind PythonLanguage language) {
            if (base == PNone.NO_VALUE) {
                base = PythonErrorType.Exception;
            }
            if (dict == PNone.NO_VALUE) {
                dict = PFactory.createDict(language);
            }
            Object ex = newExNode.execute(name, base, dict);
            if (doc != PNone.NO_VALUE) {
                writeAtrrNode.execute(ex, SpecialAttributeNames.T___DOC__, doc);
            }
            return ex;
        }
    }

    static abstract class PyErr_NewException
    extends PythonCextBuiltins.CApiTernaryBuiltinNode {
        PyErr_NewException() {
        }

        @Specialization
        static Object newEx(TruffleString name, Object base, Object dict, @Bind Node inliningTarget, @Bind PythonLanguage language, @Cached HashingStorageNodes.HashingStorageGetItem getItem, @Cached TruffleString.IndexOfCodePointNode indexOfCodepointNode, @Cached TruffleString.CodePointLengthNode codePointLengthNode, @Cached TruffleString.SubstringNode substringNode, @Cached PyDictSetItem setItemNode, @Cached TypeBuiltins.TypeNode typeNode, @Cached InlinedBranchProfile notDotProfile, @Cached InlinedBranchProfile notModuleProfile, @Cached InlinedConditionProfile baseProfile, @Cached PRaiseNode raiseNode) {
            int length;
            int dotIdx;
            if (base == PNone.NO_VALUE) {
                base = PythonErrorType.Exception;
            }
            if (dict == PNone.NO_VALUE) {
                dict = PFactory.createDict(language);
            }
            if ((dotIdx = indexOfCodepointNode.execute((AbstractTruffleString)name, 46, 0, length = codePointLengthNode.execute((AbstractTruffleString)name, PythonUtils.TS_ENCODING), PythonUtils.TS_ENCODING)) < 0) {
                notDotProfile.enter(inliningTarget);
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.SystemError, ErrorMessages.MUST_BE_MODULE_CLASS, "PyErr_NewException", "name");
            }
            if (getItem.execute(null, inliningTarget, ((PDict)dict).getDictStorage(), base) == null) {
                notModuleProfile.enter(inliningTarget);
                setItemNode.execute(null, inliningTarget, (PDict)dict, SpecialAttributeNames.T___MODULE__, substringNode.execute((AbstractTruffleString)name, 0, dotIdx, PythonUtils.TS_ENCODING, false));
            }
            PTuple bases = baseProfile.profile(inliningTarget, base instanceof PTuple) ? (PTuple)base : PFactory.createTuple(language, new Object[]{base});
            return typeNode.execute(null, (Object)PythonBuiltinClassType.PythonClass, substringNode.execute((AbstractTruffleString)name, dotIdx + 1, length - dotIdx - 1, PythonUtils.TS_ENCODING, false), bases, dict, PKeyword.EMPTY_KEYWORDS);
        }
    }

    static abstract class GraalPyPrivate_Err_CreateAndSetException
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        GraalPyPrivate_Err_CreateAndSetException() {
        }

        @Specialization(guards={"!isExceptionClass(inliningTarget, type, isTypeNode, isSubClassNode)"})
        static Object create(Object type, Object value, @Cached.Shared @Cached TypeNodes.IsTypeNode isTypeNode, @Cached.Shared @Cached BuiltinFunctions.IsSubClassNode isSubClassNode, @Bind Node inliningTarget) {
            throw PRaiseNode.raiseStatic(inliningTarget, PythonBuiltinClassType.SystemError, ErrorMessages.EXCEPTION_NOT_BASEEXCEPTION, type);
        }

        @Specialization(guards={"isExceptionClass(inliningTarget, type, isTypeNode, isSubClassNode)"})
        static Object create(Object type, Object value, @Bind Node inliningTarget, @Cached.Shared @Cached TypeNodes.IsTypeNode isTypeNode, @Cached.Shared @Cached BuiltinFunctions.IsSubClassNode isSubClassNode, @Cached PrepareExceptionNode prepareExceptionNode) {
            Object exception = prepareExceptionNode.execute(null, type, value);
            throw PRaiseNode.raiseExceptionObjectStatic(inliningTarget, exception);
        }

        protected static boolean isExceptionClass(Node inliningTarget, Object obj, TypeNodes.IsTypeNode isTypeNode, BuiltinFunctions.IsSubClassNode isSubClassNode) {
            return isTypeNode.execute(inliningTarget, obj) && isSubClassNode.executeWith(null, obj, (Object)PythonBuiltinClassType.PBaseException);
        }
    }

    static abstract class PyErr_Display
    extends PythonCextBuiltins.CApiTernaryBuiltinNode {
        PyErr_Display() {
        }

        @Specialization
        Object run(Object typ, PBaseException val, Object tb) {
            if (val.getException() != null) {
                ExceptionUtils.printPythonLikeStackTrace((Throwable)((Object)val.getException()));
            }
            return PNone.NO_VALUE;
        }
    }

    static abstract class _PyErr_SetHandledException
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        _PyErr_SetHandledException() {
        }

        @Specialization
        static Object doClear(Object threadState, PNone val, @Bind Node inliningTarget, @Bind PythonContext context) {
            PythonLanguage lang = context.getLanguage(inliningTarget);
            context.getThreadState(lang).setCaughtException(PException.NO_EXCEPTION);
            return PNone.NONE;
        }

        @Specialization
        static Object doFull(Object threadState, PBaseException val, @Bind Node inliningTarget, @Bind PythonContext context) {
            PythonLanguage language = context.getLanguage(inliningTarget);
            PException e = PException.fromExceptionInfo(val, PythonOptions.isPExceptionWithJavaStacktrace(language));
            context.getThreadState(language).setCaughtException(e);
            return PNone.NONE;
        }
    }

    static abstract class GraalPyPrivate_Err_SetTraceback
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        GraalPyPrivate_Err_SetTraceback() {
        }

        @Specialization
        static Object set(Object exception, PTraceback tb) {
            if (exception instanceof PBaseException) {
                PBaseException pythonException = (PBaseException)exception;
                pythonException.setTraceback(tb);
            }
            return PNone.NO_VALUE;
        }

        @Specialization
        static Object clear(Object exception, PNone tb) {
            if (exception instanceof PBaseException) {
                PBaseException pythonException = (PBaseException)exception;
                pythonException.clearTraceback();
            }
            return PNone.NO_VALUE;
        }
    }
}

