/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.contextvars;

import com.oracle.graal.python.builtins.objects.contextvars.Hamt;
import com.oracle.graal.python.builtins.objects.contextvars.PContextVarsContext;
import com.oracle.graal.python.builtins.objects.object.PythonBuiltinObject;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.strings.TruffleString;

public final class PContextVar
extends PythonBuiltinObject {
    private static int nextId = 0;
    private final int hashForHamt = nextId++;
    private final TruffleString name;
    private final Object def;
    public static final Object NO_DEFAULT = new Object();

    public PContextVar(Object cls, Shape instanceShape, TruffleString name, Object def) {
        super(cls, instanceShape);
        this.name = name;
        this.def = def;
    }

    public int getHash() {
        return this.hashForHamt * (this.hashForHamt + 3);
    }

    public TruffleString getName() {
        return this.name;
    }

    public Object getDefault() {
        return this.def;
    }

    public Object getValue(Node node, PythonContext.PythonThreadState state) {
        return state.getContextVarsContext((Node)node).contextVarValues.lookup(this, this.getHash());
    }

    public void setValue(Node node, PythonContext.PythonThreadState state, Object value) {
        PContextVarsContext current = state.getContextVarsContext(node);
        current.contextVarValues = current.contextVarValues.withEntry(new Hamt.Entry(this, this.getHash(), value));
    }

    public Object get(Node node, PythonContext.PythonThreadState state, Object defaultValue) {
        Object result = this.getValue(node, state);
        if (result != null) {
            return result;
        }
        if (defaultValue != NO_DEFAULT) {
            return defaultValue;
        }
        if (this.def != NO_DEFAULT) {
            return this.def;
        }
        return null;
    }
}

