/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.object.enterprise;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import java.lang.reflect.Field;
import sun.misc.Unsafe;

class UnsafeAccess {
    private static final Unsafe UNSAFE = UnsafeAccess.getUnsafe();
    public static final Object ANY_LOCATION = new Object();
    private static final int MAX_UNROLL = 32;
    private static final boolean USE_ARRAYCOPY = !TruffleOptions.AOT;

    UnsafeAccess() {
    }

    protected static long objectFieldOffset(Field field) {
        return UNSAFE.objectFieldOffset(field);
    }

    public static int intCast(boolean bl) {
        return bl ? 1 : 0;
    }

    public static boolean booleanCast(int n2) {
        return n2 != 0;
    }

    public static <T> T unsafeCast(Object object, Class<T> clazz, boolean bl, boolean bl2, boolean bl3) {
        return (T)object;
    }

    public static <T> T unsafeCast(Object object, Class<T> clazz, boolean bl, boolean bl2) {
        return UnsafeAccess.unsafeCast(object, clazz, bl, bl2, false);
    }

    public static void arraycopy(Object object, int n2, Object object2, int n3, int n4) {
        System.arraycopy(object, n2, object2, n3, n4);
    }

    public static boolean unsafeGetBoolean(Object object, long l2, boolean bl, Object object2) {
        assert (object != null);
        return UNSAFE.getBoolean(object, l2);
    }

    public static byte unsafeGetByte(Object object, long l2, boolean bl, Object object2) {
        assert (object != null);
        return UNSAFE.getByte(object, l2);
    }

    public static short unsafeGetShort(Object object, long l2, boolean bl, Object object2) {
        assert (object != null);
        return UNSAFE.getShort(object, l2);
    }

    public static int unsafeGetInt(Object object, long l2, boolean bl, Object object2) {
        assert (object != null);
        return UNSAFE.getInt(object, l2);
    }

    public static long unsafeGetLong(Object object, long l2, boolean bl, Object object2) {
        assert (object != null);
        return UNSAFE.getLong(object, l2);
    }

    public static float unsafeGetFloat(Object object, long l2, boolean bl, Object object2) {
        assert (object != null);
        return UNSAFE.getFloat(object, l2);
    }

    public static double unsafeGetDouble(Object object, long l2, boolean bl, Object object2) {
        assert (object != null);
        return UNSAFE.getDouble(object, l2);
    }

    public static Object unsafeGetObject(Object object, long l2, boolean bl, Object object2) {
        assert (object != null);
        return UNSAFE.getObject(object, l2);
    }

    public static void unsafePutBoolean(Object object, long l2, boolean bl, Object object2) {
        assert (object != null);
        UNSAFE.putBoolean(object, l2, bl);
    }

    public static void unsafePutByte(Object object, long l2, byte by, Object object2) {
        assert (object != null);
        UNSAFE.putByte(object, l2, by);
    }

    public static void unsafePutShort(Object object, long l2, short s2, Object object2) {
        assert (object != null);
        UNSAFE.putShort(object, l2, s2);
    }

    public static void unsafePutInt(Object object, long l2, int n2, Object object2) {
        assert (object != null);
        UNSAFE.putInt(object, l2, n2);
    }

    public static void unsafePutLong(Object object, long l2, long l3, Object object2) {
        assert (object != null);
        UNSAFE.putLong(object, l2, l3);
    }

    public static void unsafePutFloat(Object object, long l2, float f2, Object object2) {
        assert (object != null);
        UNSAFE.putFloat(object, l2, f2);
    }

    public static void unsafePutDouble(Object object, long l2, double d2, Object object2) {
        assert (object != null);
        UNSAFE.putDouble(object, l2, d2);
    }

    public static void unsafePutObject(Object object, long l2, Object object2, Object object3) {
        assert (object != null);
        UNSAFE.putObject(object, l2, object2);
    }

    public static boolean unsafeGetFinalBoolean(Object object, long l2, boolean bl, Object object2) {
        return UnsafeAccess.unsafeGetBoolean(object, l2, bl, object2);
    }

    public static byte unsafeGetFinalByte(Object object, long l2, boolean bl, Object object2) {
        return UnsafeAccess.unsafeGetByte(object, l2, bl, object2);
    }

    public static short unsafeGetFinalShort(Object object, long l2, boolean bl, Object object2) {
        return UnsafeAccess.unsafeGetShort(object, l2, bl, object2);
    }

    public static int unsafeGetFinalInt(Object object, long l2, boolean bl, Object object2) {
        return UnsafeAccess.unsafeGetInt(object, l2, bl, object2);
    }

    public static long unsafeGetFinalLong(Object object, long l2, boolean bl, Object object2) {
        return UnsafeAccess.unsafeGetLong(object, l2, bl, object2);
    }

    public static float unsafeGetFinalFloat(Object object, long l2, boolean bl, Object object2) {
        return UnsafeAccess.unsafeGetFloat(object, l2, bl, object2);
    }

    public static double unsafeGetFinalDouble(Object object, long l2, boolean bl, Object object2) {
        return UnsafeAccess.unsafeGetDouble(object, l2, bl, object2);
    }

    public static Object unsafeGetFinalObject(Object object, long l2, boolean bl, Object object2) {
        return UnsafeAccess.unsafeGetObject(object, l2, bl, object2);
    }

    static void arrayCopy(Object[] objectArray, Object[] objectArray2, int n2) {
        if (CompilerDirectives.isPartialEvaluationConstant((Object)n2) && n2 <= 32) {
            UnsafeAccess.arrayCopyUnroll(objectArray, objectArray2, n2);
        } else if (USE_ARRAYCOPY) {
            UnsafeAccess.arraycopy(objectArray, 0, objectArray2, 0, n2);
        } else {
            UnsafeAccess.arrayCopyLoop(objectArray, objectArray2, n2);
        }
    }

    @ExplodeLoop
    private static void arrayCopyUnroll(Object[] objectArray, Object[] objectArray2, int n2) {
        for (int i2 = 0; i2 < n2; ++i2) {
            Object object = UnsafeAccess.unsafeGetObject(objectArray, (long)Unsafe.ARRAY_OBJECT_BASE_OFFSET + (long)i2 * (long)Unsafe.ARRAY_OBJECT_INDEX_SCALE, false, null);
            UnsafeAccess.unsafePutObject(objectArray2, (long)Unsafe.ARRAY_OBJECT_BASE_OFFSET + (long)i2 * (long)Unsafe.ARRAY_OBJECT_INDEX_SCALE, object, ANY_LOCATION);
        }
    }

    private static void arrayCopyLoop(Object[] objectArray, Object[] objectArray2, int n2) {
        for (int i2 = 0; i2 < n2; ++i2) {
            Object object = UnsafeAccess.unsafeGetObject(objectArray, (long)Unsafe.ARRAY_OBJECT_BASE_OFFSET + (long)i2 * (long)Unsafe.ARRAY_OBJECT_INDEX_SCALE, false, null);
            UnsafeAccess.unsafePutObject(objectArray2, (long)Unsafe.ARRAY_OBJECT_BASE_OFFSET + (long)i2 * (long)Unsafe.ARRAY_OBJECT_INDEX_SCALE, object, ANY_LOCATION);
        }
    }

    static void arrayCopy(int[] nArray, int[] nArray2, int n2) {
        if (CompilerDirectives.isPartialEvaluationConstant((Object)n2) && n2 <= 32) {
            UnsafeAccess.arrayCopyUnroll(nArray, nArray2, n2);
        } else if (USE_ARRAYCOPY) {
            UnsafeAccess.arraycopy(nArray, 0, nArray2, 0, n2);
        } else {
            UnsafeAccess.arrayCopyLoop(nArray, nArray2, n2);
        }
    }

    @ExplodeLoop
    private static void arrayCopyUnroll(int[] nArray, int[] nArray2, int n2) {
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = UnsafeAccess.unsafeGetInt(nArray, (long)Unsafe.ARRAY_INT_BASE_OFFSET + (long)i2 * (long)Unsafe.ARRAY_INT_INDEX_SCALE, false, null);
            UnsafeAccess.unsafePutInt(nArray2, (long)Unsafe.ARRAY_INT_BASE_OFFSET + (long)i2 * (long)Unsafe.ARRAY_INT_INDEX_SCALE, n3, ANY_LOCATION);
        }
    }

    private static void arrayCopyLoop(int[] nArray, int[] nArray2, int n2) {
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = UnsafeAccess.unsafeGetInt(nArray, (long)Unsafe.ARRAY_INT_BASE_OFFSET + (long)i2 * (long)Unsafe.ARRAY_INT_INDEX_SCALE, false, null);
            UnsafeAccess.unsafePutInt(nArray2, (long)Unsafe.ARRAY_INT_BASE_OFFSET + (long)i2 * (long)Unsafe.ARRAY_INT_INDEX_SCALE, n3, ANY_LOCATION);
        }
    }

    private static Unsafe getUnsafe() {
        try {
            return Unsafe.getUnsafe();
        }
        catch (SecurityException securityException) {
            try {
                Field field = Unsafe.class.getDeclaredField("theUnsafe");
                field.setAccessible(true);
                return (Unsafe)field.get(Unsafe.class);
            }
            catch (Exception exception) {
                throw new RuntimeException("exception while trying to get Unsafe.theUnsafe via reflection:", exception);
            }
        }
    }
}

