/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.orm.hibernate;

import groovy.lang.GroovySystem;
import groovy.lang.MetaClass;
import groovy.lang.MetaClassRegistry;
import java.beans.IntrospectionException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.grails.commons.AbstractGrailsClass;
import org.codehaus.groovy.grails.commons.ExternalGrailsDomainClass;
import org.codehaus.groovy.grails.commons.GrailsDomainClass;
import org.codehaus.groovy.grails.commons.GrailsDomainClassProperty;
import org.codehaus.groovy.grails.commons.metaclass.AbstractDynamicMethodsInterceptor;
import org.codehaus.groovy.grails.commons.metaclass.DynamicProperty;
import org.codehaus.groovy.grails.commons.metaclass.Interceptor;
import org.codehaus.groovy.grails.commons.metaclass.ProxyMetaClass;
import org.codehaus.groovy.grails.orm.hibernate.GrailsHibernateDomainClassProperty;
import org.codehaus.groovy.grails.validation.GrailsDomainClassValidator;
import org.codehaus.groovy.grails.validation.metaclass.ConstraintsEvaluatingDynamicProperty;
import org.hibernate.EntityMode;
import org.hibernate.MappingException;
import org.hibernate.SessionFactory;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.metadata.ClassMetadata;
import org.hibernate.type.AnyType;
import org.hibernate.type.AssociationType;
import org.hibernate.type.Type;
import org.springframework.beans.BeanWrapper;
import org.springframework.validation.Validator;

public class GrailsHibernateDomainClass
extends AbstractGrailsClass
implements ExternalGrailsDomainClass {
    private static final Log LOG = LogFactory.getLog(GrailsHibernateDomainClass.class);
    private static final String HIBERNATE = "hibernate";
    private GrailsHibernateDomainClassProperty identifier;
    private GrailsDomainClassProperty[] properties;
    private Map propertyMap = new LinkedHashMap();
    private Validator validator;
    private Set subClasses = new HashSet();
    private Map constraints = Collections.EMPTY_MAP;

    public GrailsHibernateDomainClass(Class clazz, SessionFactory sessionFactory, ClassMetadata metaData) {
        super(clazz, "");
        BeanWrapper bean = this.getReference();
        String ident = metaData.getIdentifierPropertyName();
        if (ident != null) {
            Class identType = bean.getPropertyType(ident);
            this.identifier = new GrailsHibernateDomainClassProperty(this, ident);
            this.identifier.setIdentity(true);
            this.identifier.setType(identType);
            this.propertyMap.put(ident, this.identifier);
        }
        String[] propertyNames = metaData.getPropertyNames();
        for (int i = 0; i < propertyNames.length; ++i) {
            String propertyName = propertyNames[i];
            if (propertyName.equals(ident)) continue;
            GrailsHibernateDomainClassProperty prop = new GrailsHibernateDomainClassProperty(this, propertyName);
            prop.setType(bean.getPropertyType(propertyName));
            Type hibernateType = metaData.getPropertyType(propertyName);
            if (hibernateType.isAssociationType()) {
                block8: {
                    prop.setAssociation(true);
                    AssociationType assType = (AssociationType)hibernateType;
                    if (assType instanceof AnyType) continue;
                    try {
                        String associatedEntity = assType.getAssociatedEntityName((SessionFactoryImplementor)sessionFactory);
                        ClassMetadata associatedMetaData = sessionFactory.getClassMetadata(associatedEntity);
                        prop.setRelatedClassType(associatedMetaData.getMappedClass(EntityMode.POJO));
                    }
                    catch (MappingException me) {
                        if (!hibernateType.isCollectionType()) break block8;
                        prop.setRelatedClassType(Collection.class);
                    }
                }
                if (hibernateType.isCollectionType()) {
                    prop.setOneToMany(true);
                } else if (hibernateType.isEntityType()) {
                    prop.setManyToOne(true);
                    prop.setOneToOne(true);
                }
            }
            this.propertyMap.put(propertyName, prop);
        }
        this.properties = this.propertyMap.values().toArray(new GrailsDomainClassProperty[this.propertyMap.size()]);
        this.evaluateConstraints();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void evaluateConstraints() {
        Map existing = (Map)this.getPropertyOrStaticPropertyOrFieldValue("constraints", Map.class);
        if (existing == null) {
            Object instance = this.getReference().getWrappedInstance();
            try {
                AbstractDynamicMethodsInterceptor interceptor = new AbstractDynamicMethodsInterceptor(){};
                interceptor.addDynamicProperty((DynamicProperty)new ConstraintsEvaluatingDynamicProperty());
                MetaClassRegistry metaRegistry = GroovySystem.getMetaClassRegistry();
                MetaClass meta = metaRegistry.getMetaClass(instance.getClass());
                try {
                    ProxyMetaClass pmc = new ProxyMetaClass(metaRegistry, instance.getClass(), meta);
                    pmc.setInterceptor((Interceptor)interceptor);
                    this.constraints = (Map)pmc.getProperty(this.getClazz(), instance, "constraints", false, false);
                    Object var8_8 = null;
                }
                catch (Throwable throwable) {
                    Object var8_9 = null;
                    metaRegistry.setMetaClass(instance.getClass(), meta);
                    throw throwable;
                }
                metaRegistry.setMetaClass(instance.getClass(), meta);
                {
                }
            }
            catch (IntrospectionException e) {
                LOG.error((Object)("Introspection error reading domain class [" + this.getFullName() + "] constraints: " + e.getMessage()), (Throwable)e);
            }
        } else {
            this.constraints = existing;
        }
    }

    public boolean isOwningClass(Class domainClass) {
        return false;
    }

    public GrailsDomainClassProperty[] getProperties() {
        return this.properties;
    }

    public GrailsDomainClassProperty[] getPersistantProperties() {
        return this.properties;
    }

    public GrailsDomainClassProperty[] getPersistentProperties() {
        return this.properties;
    }

    public GrailsDomainClassProperty getIdentifier() {
        return this.identifier;
    }

    public GrailsDomainClassProperty getVersion() {
        throw new UnsupportedOperationException("Method 'getVersion' is not supported by implementation");
    }

    public GrailsDomainClassProperty getPropertyByName(String name) {
        return (GrailsDomainClassProperty)this.propertyMap.get(name);
    }

    public String getFieldName(String propertyName) {
        throw new UnsupportedOperationException("Method 'getFieldName' is not supported by implementation");
    }

    public boolean hasSubClasses() {
        return false;
    }

    public Map getMappedBy() {
        return Collections.EMPTY_MAP;
    }

    public boolean hasPersistentProperty(String propertyName) {
        for (int i = 0; i < this.properties.length; ++i) {
            GrailsDomainClassProperty persistantProperty = this.properties[i];
            if (!persistantProperty.getName().equals(propertyName)) continue;
            return true;
        }
        return false;
    }

    public void setMappingStrategy(String strategy) {
    }

    public boolean isOneToMany(String propertyName) {
        GrailsDomainClassProperty prop = this.getPropertyByName(propertyName);
        return prop != null && prop.isOneToMany();
    }

    public boolean isManyToOne(String propertyName) {
        GrailsDomainClassProperty prop = this.getPropertyByName(propertyName);
        return prop != null && prop.isManyToOne();
    }

    public boolean isBidirectional(String propertyName) {
        throw new UnsupportedOperationException("Method 'isBidirectional' is not supported by implementation");
    }

    public Class getRelatedClassType(String propertyName) {
        GrailsDomainClassProperty prop = this.getPropertyByName(propertyName);
        if (prop == null) {
            return null;
        }
        return prop.getReferencedPropertyType();
    }

    public Map getConstrainedProperties() {
        return this.constraints;
    }

    public Validator getValidator() {
        if (this.validator == null) {
            GrailsDomainClassValidator gdcv = new GrailsDomainClassValidator();
            gdcv.setDomainClass((GrailsDomainClass)this);
            this.validator = gdcv;
        }
        return this.validator;
    }

    public void setValidator(Validator validator) {
        this.validator = validator;
    }

    public String getMappingStrategy() {
        return HIBERNATE;
    }

    public Set getSubClasses() {
        return this.subClasses;
    }

    public void refreshConstraints() {
        this.evaluateConstraints();
    }

    public boolean isRoot() {
        return this.getClazz().getSuperclass().equals(Object.class);
    }

    public Map getAssociationMap() {
        return Collections.EMPTY_MAP;
    }
}

