/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.orm.hibernate.cfg;

import grails.util.GrailsUtil;
import groovy.lang.Closure;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.SortedSet;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.grails.commons.GrailsClassUtils;
import org.codehaus.groovy.grails.commons.GrailsDomainClass;
import org.codehaus.groovy.grails.commons.GrailsDomainClassProperty;
import org.codehaus.groovy.grails.exceptions.GrailsDomainException;
import org.codehaus.groovy.grails.orm.hibernate.cfg.CacheConfig;
import org.codehaus.groovy.grails.orm.hibernate.cfg.ColumnConfig;
import org.codehaus.groovy.grails.orm.hibernate.cfg.CompositeIdentity;
import org.codehaus.groovy.grails.orm.hibernate.cfg.HibernateMappingBuilder;
import org.codehaus.groovy.grails.orm.hibernate.cfg.Identity;
import org.codehaus.groovy.grails.orm.hibernate.cfg.IdentityEnumType;
import org.codehaus.groovy.grails.orm.hibernate.cfg.JoinTable;
import org.codehaus.groovy.grails.orm.hibernate.cfg.Mapping;
import org.codehaus.groovy.grails.orm.hibernate.cfg.NaturalId;
import org.codehaus.groovy.grails.orm.hibernate.cfg.PropertyConfig;
import org.codehaus.groovy.grails.orm.hibernate.validation.UniqueConstraint;
import org.codehaus.groovy.grails.validation.ConstrainedProperty;
import org.hibernate.FetchMode;
import org.hibernate.Hibernate;
import org.hibernate.MappingException;
import org.hibernate.cfg.ImprovedNamingStrategy;
import org.hibernate.cfg.Mappings;
import org.hibernate.cfg.NamingStrategy;
import org.hibernate.cfg.SecondPass;
import org.hibernate.mapping.Backref;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.DependantValue;
import org.hibernate.mapping.IndexBackref;
import org.hibernate.mapping.IndexedCollection;
import org.hibernate.mapping.JoinedSubclass;
import org.hibernate.mapping.KeyValue;
import org.hibernate.mapping.ManyToOne;
import org.hibernate.mapping.Map;
import org.hibernate.mapping.OneToMany;
import org.hibernate.mapping.OneToOne;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.RootClass;
import org.hibernate.mapping.Selectable;
import org.hibernate.mapping.Set;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.SingleTableSubclass;
import org.hibernate.mapping.Subclass;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.UniqueKey;
import org.hibernate.mapping.Value;
import org.hibernate.persister.entity.JoinedSubclassEntityPersister;
import org.hibernate.persister.entity.SingleTableEntityPersister;
import org.hibernate.type.ForeignKeyDirection;
import org.hibernate.type.Type;
import org.hibernate.type.TypeFactory;
import org.hibernate.util.StringHelper;

public final class GrailsDomainBinder {
    private static final String FOREIGN_KEY_SUFFIX = "_id";
    private static final Log LOG = LogFactory.getLog(GrailsDomainBinder.class);
    private static final NamingStrategy namingStrategy = ImprovedNamingStrategy.INSTANCE;
    private static final String STRING_TYPE = "string";
    private static final String EMPTY_PATH = "";
    private static final char UNDERSCORE = '_';
    private static final String CASCADE_ALL = "all";
    private static final String CASCADE_SAVE_UPDATE = "save-update";
    private static final String CASCADE_MERGE = "merge";
    private static final String CASCADE_NONE = "none";
    private static final String BACKTICK = "`";
    private static final java.util.Map<Class, Mapping> MAPPING_CACHE = new HashMap<Class, Mapping>();
    private static final String ENUM_TYPE_CLASS = "org.hibernate.type.EnumType";
    private static final String ENUM_CLASS_PROP = "enumClass";
    private static final String ENUM_TYPE_PROP = "type";

    private static void bindMapSecondPass(GrailsDomainClassProperty property, Mappings mappings, java.util.Map persistentClasses, Map map, java.util.Map inheritedMetas) {
        GrailsDomainBinder.bindCollectionSecondPass(property, mappings, persistentClasses, (Collection)map, inheritedMetas);
        SimpleValue value = new SimpleValue(map.getCollectionTable());
        GrailsDomainBinder.bindSimpleValue(GrailsDomainBinder.getIndexColumnType(property, STRING_TYPE), value, true, GrailsDomainBinder.getIndexColumnName(property), mappings);
        PropertyConfig pc = GrailsDomainBinder.getPropertyConfig(property);
        if (pc != null && pc.getIndexColumn() != null) {
            GrailsDomainBinder.bindColumnConfigToColumn(GrailsDomainBinder.getColumnForSimpleValue(value), GrailsDomainBinder.getSingleColumnConfig(pc.getIndexColumn()));
        }
        if (!value.isTypeSpecified()) {
            throw new MappingException("map index element must specify a type: " + map.getRole());
        }
        map.setIndex((Value)value);
        if (!property.isOneToMany() && !property.isManyToMany()) {
            SimpleValue elt = new SimpleValue(map.getCollectionTable());
            map.setElement((Value)elt);
            String typeName = GrailsDomainBinder.getTypeName(GrailsDomainBinder.getPropertyConfig(property));
            if (typeName == null) {
                typeName = property.isBasicCollectionType() ? property.getReferencedPropertyType().getName() : Hibernate.STRING.getName();
            }
            GrailsDomainBinder.bindSimpleValue(typeName, elt, false, GrailsDomainBinder.getMapElementName(property), mappings);
            if (pc != null) {
                GrailsDomainBinder.bindColumnConfigToColumn(GrailsDomainBinder.getColumnForSimpleValue(elt), GrailsDomainBinder.getSingleColumnConfig(pc));
            }
            elt.setTypeName(typeName);
            map.setInverse(false);
        } else {
            map.setInverse(false);
        }
    }

    private static ColumnConfig getSingleColumnConfig(PropertyConfig propertyConfig) {
        List columns;
        if (propertyConfig != null && (columns = propertyConfig.getColumns()) != null && !columns.isEmpty()) {
            return (ColumnConfig)columns.get(0);
        }
        return null;
    }

    private static void bindListSecondPass(GrailsDomainClassProperty property, Mappings mappings, java.util.Map persistentClasses, org.hibernate.mapping.List list, java.util.Map inheritedMetas) {
        GrailsDomainBinder.bindCollectionSecondPass(property, mappings, persistentClasses, (Collection)list, inheritedMetas);
        String columnName = GrailsDomainBinder.getIndexColumnName(property);
        SimpleValue iv = new SimpleValue(list.getCollectionTable());
        GrailsDomainBinder.bindSimpleValue("integer", iv, true, columnName, mappings);
        iv.setTypeName("integer");
        list.setIndex((Value)iv);
        list.setBaseIndex(0);
        list.setInverse(false);
        Value v = list.getElement();
        v.createForeignKey();
        if (property.isBidirectional()) {
            String entityName;
            Value element = list.getElement();
            if (element instanceof ManyToOne) {
                ManyToOne manyToOne = (ManyToOne)element;
                entityName = manyToOne.getReferencedEntityName();
            } else {
                entityName = ((OneToMany)element).getReferencedEntityName();
            }
            PersistentClass referenced = mappings.getClass(entityName);
            boolean isManyToMany = property.isManyToMany();
            Class mappedClass = referenced.getMappedClass();
            Mapping m = GrailsDomainBinder.getMapping(mappedClass);
            if (!GrailsDomainBinder.isCompositeIdProperty(m, property.getOtherSide())) {
                Backref prop = new Backref();
                prop.setEntityName(property.getDomainClass().getFullName());
                prop.setName('_' + property.getDomainClass().getShortName() + '_' + property.getName() + "Backref");
                prop.setSelectable(false);
                prop.setUpdateable(false);
                if (isManyToMany) {
                    prop.setInsertable(false);
                }
                prop.setCollectionRole(list.getRole());
                prop.setValue((Value)list.getKey());
                DependantValue value = (DependantValue)prop.getValue();
                if (!property.isCircular()) {
                    value.setNullable(false);
                }
                value.setUpdateable(true);
                prop.setOptional(false);
                referenced.addProperty((Property)prop);
            }
            IndexBackref ib = new IndexBackref();
            ib.setName('_' + property.getName() + "IndexBackref");
            ib.setUpdateable(false);
            ib.setSelectable(false);
            if (isManyToMany) {
                ib.setInsertable(false);
            }
            ib.setCollectionRole(list.getRole());
            ib.setEntityName(list.getOwner().getEntityName());
            ib.setValue(list.getIndex());
            referenced.addProperty((Property)ib);
        }
    }

    private static void bindCollectionSecondPass(GrailsDomainClassProperty property, Mappings mappings, java.util.Map persistentClasses, Collection collection, java.util.Map inheritedMetas) {
        CacheConfig cacheConfig;
        GrailsDomainClassProperty otherSide;
        PersistentClass associatedClass = null;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Mapping collection: " + collection.getRole() + " -> " + collection.getCollectionTable().getName()));
        }
        PropertyConfig propConfig = GrailsDomainBinder.getPropertyConfig(property);
        if (collection.isOneToMany()) {
            OneToMany oneToMany;
            String associatedClassName;
            boolean tablePerSubclass;
            GrailsDomainClass referenced = property.getReferencedDomainClass();
            Mapping m = GrailsDomainBinder.getRootMapping(referenced);
            boolean bl = tablePerSubclass = m != null && !m.getTablePerHierarchy();
            if (referenced != null && !referenced.isRoot() && !tablePerSubclass) {
                collection.setWhere("class = '" + referenced.getFullName() + "'");
            }
            if ((associatedClass = (PersistentClass)persistentClasses.get(associatedClassName = (oneToMany = (OneToMany)collection.getElement()).getReferencedEntityName())) == null) {
                throw new MappingException("Association references unmapped class: " + oneToMany.getReferencedEntityName());
            }
            oneToMany.setAssociatedClass(associatedClass);
            if (GrailsDomainBinder.shouldBindCollectionWithForeignKey(property)) {
                collection.setCollectionTable(associatedClass.getTable());
            }
            GrailsDomainBinder.bindCollectionForPropertyConfig(collection, propConfig);
        }
        if (GrailsDomainBinder.isSorted(property)) {
            collection.setSorted(true);
        }
        DependantValue key = GrailsDomainBinder.createPrimaryKeyValue(property, collection, persistentClasses);
        if (property.isBidirectional()) {
            otherSide = property.getOtherSide();
            if (otherSide.isManyToOne() && GrailsDomainBinder.shouldBindCollectionWithForeignKey(property)) {
                GrailsDomainBinder.linkBidirectionalOneToMany(collection, associatedClass, key, otherSide);
            } else if (property.isManyToMany() || java.util.Map.class.isAssignableFrom(property.getType())) {
                GrailsDomainBinder.bindDependentKeyValue(property, key, mappings);
            }
        } else if (GrailsDomainBinder.hasJoinKeyMapping(propConfig)) {
            GrailsDomainBinder.bindSimpleValue("long", (SimpleValue)key, false, propConfig.getJoinTable().getKey().getName(), mappings);
        } else {
            GrailsDomainBinder.bindDependentKeyValue(property, key, mappings);
        }
        collection.setKey((KeyValue)key);
        if (propConfig != null && (cacheConfig = propConfig.getCache()) != null) {
            collection.setCacheConcurrencyStrategy(cacheConfig.getUsage());
        }
        if (property.isManyToMany() || GrailsDomainBinder.isBidirectionalOneToManyMap(property)) {
            otherSide = property.getOtherSide();
            if (property.isBidirectional()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("[GrailsDomainBinder] Mapping other side " + otherSide.getDomainClass().getName() + "." + otherSide.getName() + " -> " + collection.getCollectionTable().getName() + " as ManyToOne"));
                }
                ManyToOne element = new ManyToOne(collection.getCollectionTable());
                GrailsDomainBinder.bindManyToMany(otherSide, element, mappings);
                collection.setElement((Value)element);
                GrailsDomainBinder.bindCollectionForPropertyConfig(collection, propConfig);
                if (property.isCircular()) {
                    collection.setInverse(false);
                }
            }
        } else if (GrailsDomainBinder.shouldCollectionBindWithJoinColumn(property)) {
            GrailsDomainBinder.bindCollectionWithJoinTable(property, mappings, collection, propConfig);
        } else if (GrailsDomainBinder.isUnidirectionalOneToMany(property)) {
            GrailsDomainBinder.bindUnidirectionalOneToMany(property, mappings, collection);
        }
    }

    private static Mapping getRootMapping(GrailsDomainClass referenced) {
        Class superClass;
        if (referenced == null) {
            return null;
        }
        Class current = referenced.getClazz();
        while (!Object.class.equals(superClass = current.getSuperclass())) {
            current = superClass;
        }
        return GrailsDomainBinder.getMapping(current);
    }

    private static boolean isBidirectionalOneToManyMap(GrailsDomainClassProperty property) {
        return java.util.Map.class.isAssignableFrom(property.getType()) && property.isBidirectional();
    }

    private static void bindCollectionWithJoinTable(GrailsDomainClassProperty property, Mappings mappings, Collection collection, PropertyConfig config) {
        SimpleValue element;
        if (property.isBasicCollectionType()) {
            element = new SimpleValue(collection.getCollectionTable());
        } else {
            element = new ManyToOne(collection.getCollectionTable());
            GrailsDomainBinder.bindUnidirectionalOneToManyInverseValues(property, (ManyToOne)element);
        }
        collection.setInverse(false);
        boolean hasJoinColumnMapping = GrailsDomainBinder.hasJoinColumnMapping(config);
        if (property.isBasicCollectionType()) {
            String columnName;
            Class referencedType = property.getReferencedPropertyType();
            String className = referencedType.getName();
            boolean isEnum = GrailsClassUtils.isJdk5Enum((Class)referencedType);
            if (hasJoinColumnMapping) {
                columnName = config.getJoinTable().getColumn().getName();
            } else {
                String string = columnName = isEnum ? namingStrategy.propertyToColumnName(className) : namingStrategy.propertyToColumnName(property.getName()) + '_' + namingStrategy.propertyToColumnName(className);
            }
            if (isEnum) {
                GrailsDomainBinder.bindEnumType(property, referencedType, element, columnName, EMPTY_PATH);
            } else {
                Type type;
                String typeName = GrailsDomainBinder.getTypeName(config);
                if (typeName == null && (type = TypeFactory.basic((String)className)) != null) {
                    typeName = type.getName();
                }
                if (typeName == null) {
                    throw new MappingException("Type [" + typeName + "] is not a basic type or a domain class and cannot be mapped. Either specify a type within the [mapping] block or use a basic type (String, Integer etc.)");
                }
                GrailsDomainBinder.bindSimpleValue(typeName, element, true, columnName, mappings);
                if (hasJoinColumnMapping) {
                    GrailsDomainBinder.bindColumnConfigToColumn(GrailsDomainBinder.getColumnForSimpleValue(element), config.getJoinTable().getColumn());
                }
            }
        } else {
            GrailsDomainClass domainClass = property.getReferencedDomainClass();
            Mapping m = GrailsDomainBinder.getMapping(domainClass.getClazz());
            if (GrailsDomainBinder.hasCompositeIdentifier(m)) {
                CompositeIdentity ci = (CompositeIdentity)m.getIdentity();
                GrailsDomainBinder.bindCompositeIdentifierToManyToOne(property, (SimpleValue)((ManyToOne)element), ci, domainClass, EMPTY_PATH);
            } else {
                String columnName = hasJoinColumnMapping ? config.getJoinTable().getColumn().getName() : namingStrategy.propertyToColumnName(domainClass.getPropertyName()) + FOREIGN_KEY_SUFFIX;
                GrailsDomainBinder.bindSimpleValue("long", element, true, columnName, mappings);
            }
        }
        collection.setElement((Value)element);
        GrailsDomainBinder.bindCollectionForPropertyConfig(collection, config);
    }

    private static Column getColumnForSimpleValue(SimpleValue element) {
        return (Column)element.getColumnIterator().next();
    }

    private static String getTypeName(PropertyConfig config) {
        if (config != null && config.getType() != null) {
            Object typeObj = config.getType();
            if (typeObj instanceof Class) {
                return ((Class)typeObj).getName();
            }
            return typeObj.toString();
        }
        return null;
    }

    private static void bindColumnConfigToColumn(Column column, ColumnConfig columnConfig) {
        if (columnConfig != null) {
            column.setLength(columnConfig.getLength());
            column.setPrecision(columnConfig.getPrecision());
            column.setSqlType(columnConfig.getSqlType());
            column.setUnique(columnConfig.getUnique());
            column.setScale(columnConfig.getScale());
        }
    }

    private static boolean hasJoinColumnMapping(PropertyConfig config) {
        return config != null && config.getJoinTable() != null && config.getJoinTable().getColumn() != null;
    }

    private static boolean shouldCollectionBindWithJoinColumn(GrailsDomainClassProperty property) {
        PropertyConfig config = GrailsDomainBinder.getPropertyConfig(property);
        JoinTable jt = config != null ? config.getJoinTable() : new JoinTable();
        return (GrailsDomainBinder.isUnidirectionalOneToMany(property) || property.isBasicCollectionType()) && jt != null;
    }

    private static void bindUnidirectionalOneToManyInverseValues(GrailsDomainClassProperty property, ManyToOne manyToOne) {
        PropertyConfig config = GrailsDomainBinder.getPropertyConfig(property);
        if (config != null) {
            manyToOne.setLazy(config.getLazy());
            manyToOne.setIgnoreNotFound(config.getIgnoreNotFound());
        } else {
            manyToOne.setLazy(true);
        }
        manyToOne.setReferencedEntityName(property.getReferencedPropertyType().getName());
    }

    private static void bindCollectionForPropertyConfig(Collection collection, PropertyConfig config) {
        if (config != null) {
            collection.setLazy(config.getLazy());
        } else {
            collection.setLazy(true);
        }
    }

    private static PropertyConfig getPropertyConfig(GrailsDomainClassProperty property) {
        Mapping m = GrailsDomainBinder.getMapping(property.getDomainClass().getClazz());
        PropertyConfig config = m != null ? m.getPropertyConfig(property.getName()) : null;
        return config;
    }

    private static boolean isUnidirectionalOneToMany(GrailsDomainClassProperty property) {
        return property.isOneToMany() && !property.isBidirectional();
    }

    private static void bindDependentKeyValue(GrailsDomainClassProperty property, DependantValue key, Mappings mappings) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("[GrailsDomainBinder] binding  [" + property.getName() + "] with dependant key"));
        }
        GrailsDomainClass refDomainClass = property.getDomainClass();
        Mapping mapping = GrailsDomainBinder.getMapping(refDomainClass.getClazz());
        if (GrailsDomainBinder.shouldCollectionBindWithJoinColumn(property) && GrailsDomainBinder.hasCompositeIdentifier(mapping)) {
            CompositeIdentity ci = (CompositeIdentity)mapping.getIdentity();
            GrailsDomainBinder.bindCompositeIdentifierToManyToOne(property, (SimpleValue)key, ci, refDomainClass, EMPTY_PATH);
        } else {
            GrailsDomainBinder.bindSimpleValue(property, (SimpleValue)key, EMPTY_PATH, mappings);
        }
    }

    private static DependantValue createPrimaryKeyValue(GrailsDomainClassProperty property, Collection collection, java.util.Map persistentClasses) {
        String propertyRef = collection.getReferencedPropertyName();
        KeyValue keyValue = propertyRef == null ? collection.getOwner().getIdentifier() : (KeyValue)collection.getOwner().getProperty(propertyRef).getValue();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("[GrailsDomainBinder] creating dependant key value  to table [" + keyValue.getTable().getName() + "]"));
        }
        DependantValue key = new DependantValue(collection.getCollectionTable(), keyValue);
        key.setTypeName(null);
        key.setNullable(true);
        key.setUpdateable(false);
        return key;
    }

    private static void bindUnidirectionalOneToMany(GrailsDomainClassProperty property, Mappings mappings, Collection collection) {
        String entityName;
        Value v = collection.getElement();
        v.createForeignKey();
        if (v instanceof ManyToOne) {
            ManyToOne manyToOne = (ManyToOne)v;
            entityName = manyToOne.getReferencedEntityName();
        } else {
            entityName = ((OneToMany)v).getReferencedEntityName();
        }
        collection.setInverse(false);
        PersistentClass referenced = mappings.getClass(entityName);
        Backref prop = new Backref();
        prop.setEntityName(property.getDomainClass().getFullName());
        prop.setName('_' + property.getDomainClass().getShortName() + '_' + property.getName() + "Backref");
        prop.setUpdateable(false);
        prop.setInsertable(true);
        prop.setCollectionRole(collection.getRole());
        prop.setValue((Value)collection.getKey());
        prop.setOptional(true);
        referenced.addProperty((Property)prop);
    }

    private static Property getProperty(PersistentClass associatedClass, String propertyName) throws MappingException {
        try {
            return associatedClass.getProperty(propertyName);
        }
        catch (MappingException e) {
            if (associatedClass.getKey() instanceof Component) {
                return ((Component)associatedClass.getKey()).getProperty(propertyName);
            }
            throw e;
        }
    }

    private static void linkBidirectionalOneToMany(Collection collection, PersistentClass associatedClass, DependantValue key, GrailsDomainClassProperty otherSide) {
        collection.setInverse(true);
        Iterator mappedByColumns = GrailsDomainBinder.getProperty(associatedClass, otherSide.getName()).getValue().getColumnIterator();
        while (mappedByColumns.hasNext()) {
            Column column = (Column)mappedByColumns.next();
            GrailsDomainBinder.linkValueUsingAColumnCopy(otherSide, column, key);
        }
    }

    private static boolean isSorted(GrailsDomainClassProperty property) {
        return SortedSet.class.isAssignableFrom(property.getType());
    }

    private static void bindManyToMany(GrailsDomainClassProperty property, ManyToOne element, Mappings mappings) {
        GrailsDomainBinder.bindManyToOne(property, element, EMPTY_PATH, mappings);
        element.setReferencedEntityName(property.getDomainClass().getFullName());
    }

    private static void linkValueUsingAColumnCopy(GrailsDomainClassProperty prop, Column column, DependantValue key) {
        Column mappingColumn = new Column();
        mappingColumn.setName(column.getName());
        mappingColumn.setLength(column.getLength());
        mappingColumn.setNullable(prop.isOptional());
        mappingColumn.setSqlType(column.getSqlType());
        mappingColumn.setValue((Value)key);
        key.addColumn(mappingColumn);
        key.getTable().addColumn(mappingColumn);
    }

    private static void bindCollection(GrailsDomainClassProperty property, Collection collection, PersistentClass owner, Mappings mappings, String path) {
        String propertyName = GrailsDomainBinder.getNameForPropertyAndPath(property, path);
        collection.setRole(StringHelper.qualify((String)property.getDomainClass().getFullName(), (String)propertyName));
        PropertyConfig pc = GrailsDomainBinder.getPropertyConfig(property);
        if (property.getFetchMode() == 1) {
            collection.setFetchMode(FetchMode.JOIN);
        } else if (pc != null && pc.getFetch() != null) {
            collection.setFetchMode(pc.getFetch());
        } else {
            collection.setFetchMode(FetchMode.DEFAULT);
        }
        if (GrailsDomainBinder.shouldBindCollectionWithForeignKey(property)) {
            OneToMany oneToMany = new OneToMany(collection.getOwner());
            collection.setElement((Value)oneToMany);
            GrailsDomainBinder.bindOneToMany(property, oneToMany, mappings);
        } else {
            GrailsDomainBinder.bindCollectionTable(property, mappings, collection);
            if (!property.isOwningSide()) {
                collection.setInverse(true);
            }
        }
        if (pc != null && !StringUtils.isBlank((String)pc.getSort())) {
            collection.setOrderBy(pc.getSort());
        }
        if (pc != null && pc.getBatchSize() != null) {
            collection.setBatchSize(pc.getBatchSize().intValue());
        }
        if (collection instanceof Set) {
            mappings.addSecondPass((SecondPass)new GrailsCollectionSecondPass(property, mappings, collection));
        } else if (collection instanceof org.hibernate.mapping.List) {
            mappings.addSecondPass((SecondPass)new ListSecondPass(property, mappings, collection));
        } else if (collection instanceof Map) {
            mappings.addSecondPass((SecondPass)new MapSecondPass(property, mappings, collection));
        }
    }

    private static boolean shouldBindCollectionWithForeignKey(GrailsDomainClassProperty property) {
        return (property.isOneToMany() && property.isBidirectional() || !GrailsDomainBinder.shouldCollectionBindWithJoinColumn(property)) && !java.util.Map.class.isAssignableFrom(property.getType()) && !property.isManyToMany() && !property.isBasicCollectionType();
    }

    private static boolean isListOrMapCollection(GrailsDomainClassProperty property) {
        return java.util.Map.class.isAssignableFrom(property.getType()) || List.class.isAssignableFrom(property.getType());
    }

    private static String getNameForPropertyAndPath(GrailsDomainClassProperty property, String path) {
        String propertyName = StringHelper.isNotEmpty((String)path) ? StringHelper.qualify((String)path, (String)property.getName()) : property.getName();
        return propertyName;
    }

    private static void bindCollectionTable(GrailsDomainClassProperty property, Mappings mappings, Collection collection) {
        String tableName = GrailsDomainBinder.calculateTableForMany(property);
        Table t = mappings.addTable(mappings.getSchemaName(), mappings.getCatalogName(), tableName, null, false);
        collection.setCollectionTable(t);
    }

    private static String calculateTableForMany(GrailsDomainClassProperty property) {
        String propertyColumnName = namingStrategy.propertyToColumnName(property.getName());
        if (java.util.Map.class.isAssignableFrom(property.getType())) {
            String tablePrefix = GrailsDomainBinder.getTableName(property.getDomainClass());
            return tablePrefix + "_" + propertyColumnName;
        }
        PropertyConfig config = GrailsDomainBinder.getPropertyConfig(property);
        JoinTable jt = config != null ? config.getJoinTable() : null;
        boolean hasJoinTableMapping = jt != null && jt.getName() != null;
        String left = GrailsDomainBinder.getTableName(property.getDomainClass());
        if (property.isBasicCollectionType()) {
            if (hasJoinTableMapping) {
                return jt.getName();
            }
            return left + '_' + propertyColumnName;
        }
        String right = GrailsDomainBinder.getTableName(property.getReferencedDomainClass());
        if (property.isManyToMany()) {
            if (hasJoinTableMapping) {
                return jt.getName();
            }
            if (property.isOwningSide()) {
                return left + '_' + propertyColumnName;
            }
            return right + '_' + namingStrategy.propertyToColumnName(property.getOtherSide().getName());
        }
        if (GrailsDomainBinder.shouldCollectionBindWithJoinColumn(property)) {
            if (hasJoinTableMapping) {
                return jt.getName();
            }
            left = GrailsDomainBinder.trimBackTigs(left);
            right = GrailsDomainBinder.trimBackTigs(right);
            return left + '_' + right;
        }
        if (property.isOwningSide()) {
            return left + '_' + right;
        }
        return right + '_' + left;
    }

    private static String trimBackTigs(String tableName) {
        if (tableName.startsWith(BACKTICK)) {
            return tableName.substring(1, tableName.length() - 1);
        }
        return tableName;
    }

    private static String getTableName(GrailsDomainClass domainClass) {
        Mapping m = GrailsDomainBinder.getMapping(domainClass.getClazz());
        String tableName = null;
        if (m != null && m.getTableName() != null) {
            tableName = m.getTableName();
        }
        if (tableName == null) {
            tableName = namingStrategy.classToTableName(domainClass.getShortName());
        }
        return tableName;
    }

    public static void bindClass(GrailsDomainClass domainClass, Mappings mappings) throws MappingException {
        if (domainClass.isRoot()) {
            GrailsDomainBinder.bindRoot(domainClass, mappings);
        }
    }

    public static Mapping evaluateMapping(GrailsDomainClass domainClass) {
        try {
            Object o = GrailsClassUtils.getStaticPropertyValue((Class)domainClass.getClazz(), (String)"mapping");
            if (o instanceof Closure) {
                HibernateMappingBuilder builder = new HibernateMappingBuilder(domainClass.getFullName());
                Mapping m = builder.evaluate((Closure)o);
                MAPPING_CACHE.put(domainClass.getClazz(), m);
                return m;
            }
        }
        catch (Exception e) {
            GrailsUtil.deepSanitize((Throwable)e);
            throw new GrailsDomainException("Error evaluating ORM mappings block for domain [" + domainClass.getFullName() + "]:  " + e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public static Mapping getMapping(Class theClass) {
        return MAPPING_CACHE.get(theClass);
    }

    public static Mapping getMapping(GrailsDomainClass domainClass) {
        return MAPPING_CACHE.get(domainClass.getClazz());
    }

    private static void bindClass(GrailsDomainClass domainClass, PersistentClass persistentClass, Mappings mappings) {
        persistentClass.setLazy(true);
        persistentClass.setEntityName(domainClass.getFullName());
        persistentClass.setProxyInterfaceName(domainClass.getFullName());
        persistentClass.setClassName(domainClass.getFullName());
        persistentClass.setDynamicInsert(false);
        persistentClass.setDynamicUpdate(false);
        persistentClass.setSelectBeforeUpdate(false);
        if (mappings.isAutoImport() && persistentClass.getEntityName().indexOf(46) > 0) {
            mappings.addImport(persistentClass.getEntityName(), StringHelper.unqualify((String)persistentClass.getEntityName()));
        }
    }

    public static void bindRoot(GrailsDomainClass domainClass, Mappings mappings) {
        if (mappings.getClass(domainClass.getFullName()) == null) {
            RootClass root = new RootClass();
            GrailsDomainBinder.bindClass(domainClass, (PersistentClass)root, mappings);
            Mapping m = GrailsDomainBinder.getMapping(domainClass);
            if (m != null) {
                Integer bs;
                CacheConfig cc = m.getCache();
                if (cc != null && cc.getEnabled()) {
                    root.setCacheConcurrencyStrategy(cc.getUsage());
                    root.setLazyPropertiesCacheable(!"non-lazy".equals(cc.getInclude()));
                }
                if ((bs = m.getBatchSize()) != null) {
                    root.setBatchSize(bs.intValue());
                }
                if (m.getDynamicUpdate()) {
                    root.setDynamicUpdate(true);
                }
                if (m.getDynamicInsert()) {
                    root.setDynamicInsert(true);
                }
            }
            GrailsDomainBinder.bindRootPersistentClassCommonValues(domainClass, root, mappings);
            if (!domainClass.getSubClasses().isEmpty()) {
                boolean tablePerSubclass;
                boolean bl = tablePerSubclass = m != null && !m.getTablePerHierarchy();
                if (!tablePerSubclass) {
                    GrailsDomainBinder.bindDiscriminatorProperty(root.getTable(), root, mappings);
                }
                GrailsDomainBinder.bindSubClasses(domainClass, (PersistentClass)root, mappings);
            }
            mappings.addClass((PersistentClass)root);
        } else {
            LOG.info((Object)("[GrailsDomainBinder] Class [" + domainClass.getFullName() + "] is already mapped, skipping.. "));
        }
    }

    private static void bindSubClasses(GrailsDomainClass domainClass, PersistentClass parent, Mappings mappings) {
        java.util.Set subClasses = domainClass.getSubClasses();
        for (GrailsDomainClass sub : subClasses) {
            java.util.Set subSubs = sub.getSubClasses();
            if (!sub.getClazz().getSuperclass().equals(domainClass.getClazz())) continue;
            GrailsDomainBinder.bindSubClass(sub, parent, mappings);
        }
    }

    private static void bindSubClass(GrailsDomainClass sub, PersistentClass parent, Mappings mappings) {
        JoinedSubclass subClass;
        boolean tablePerSubclass;
        GrailsDomainBinder.evaluateMapping(sub);
        Mapping m = GrailsDomainBinder.getMapping(parent.getMappedClass());
        boolean bl = tablePerSubclass = m != null && !m.getTablePerHierarchy();
        if (tablePerSubclass) {
            subClass = new JoinedSubclass(parent);
        } else {
            subClass = new SingleTableSubclass(parent);
            Mapping subMapping = GrailsDomainBinder.getMapping(sub);
            subClass.setDiscriminatorValue(subMapping != null && subMapping.getDiscriminator() != null ? subMapping.getDiscriminator() : sub.getFullName());
        }
        subClass.setEntityName(sub.getFullName());
        parent.addSubclass((Subclass)subClass);
        mappings.addClass((PersistentClass)subClass);
        if (tablePerSubclass) {
            GrailsDomainBinder.bindJoinedSubClass(sub, subClass, mappings, m);
        } else {
            GrailsDomainBinder.bindSubClass(sub, (Subclass)subClass, mappings);
        }
        if (!sub.getSubClasses().isEmpty()) {
            GrailsDomainBinder.bindSubClasses(sub, (PersistentClass)subClass, mappings);
        }
    }

    private static void bindJoinedSubClass(GrailsDomainClass sub, JoinedSubclass joinedSubclass, Mappings mappings, Mapping gormMapping) {
        GrailsDomainBinder.bindClass(sub, (PersistentClass)joinedSubclass, mappings);
        if (joinedSubclass.getEntityPersisterClass() == null) {
            joinedSubclass.getRootClass().setEntityPersisterClass(JoinedSubclassEntityPersister.class);
        }
        Table mytable = mappings.addTable(mappings.getSchemaName(), mappings.getCatalogName(), GrailsDomainBinder.getJoinedSubClassTableName(sub, (PersistentClass)joinedSubclass, null, mappings), null, false);
        joinedSubclass.setTable(mytable);
        LOG.info((Object)("Mapping joined-subclass: " + joinedSubclass.getEntityName() + " -> " + joinedSubclass.getTable().getName()));
        DependantValue key = new DependantValue(mytable, joinedSubclass.getIdentifier());
        joinedSubclass.setKey((KeyValue)key);
        GrailsDomainClassProperty identifier = sub.getIdentifier();
        String columnName = GrailsDomainBinder.getColumnNameForPropertyAndPath(identifier, EMPTY_PATH, null);
        GrailsDomainBinder.bindSimpleValue(identifier.getType().getName(), (SimpleValue)key, false, columnName, mappings);
        joinedSubclass.createPrimaryKey();
        GrailsDomainBinder.createClassProperties(sub, (PersistentClass)joinedSubclass, mappings);
    }

    private static String getJoinedSubClassTableName(GrailsDomainClass sub, PersistentClass model, Table denormalizedSuperTable, Mappings mappings) {
        String logicalTableName = StringHelper.unqualify((String)model.getEntityName());
        String physicalTableName = GrailsDomainBinder.getTableName(sub);
        mappings.addTableBinding(mappings.getSchemaName(), mappings.getCatalogName(), logicalTableName, physicalTableName, denormalizedSuperTable);
        return physicalTableName;
    }

    private static void bindSubClass(GrailsDomainClass sub, Subclass subClass, Mappings mappings) {
        GrailsDomainBinder.bindClass(sub, (PersistentClass)subClass, mappings);
        if (subClass.getEntityPersisterClass() == null) {
            subClass.getRootClass().setEntityPersisterClass(SingleTableEntityPersister.class);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Mapping subclass: " + subClass.getEntityName() + " -> " + subClass.getTable().getName()));
        }
        GrailsDomainBinder.createClassProperties(sub, (PersistentClass)subClass, mappings);
    }

    private static void bindDiscriminatorProperty(Table table, RootClass entity, Mappings mappings) {
        ColumnConfig cc;
        Mapping m = GrailsDomainBinder.getMapping(entity.getMappedClass());
        SimpleValue d = new SimpleValue(table);
        entity.setDiscriminator((Value)d);
        entity.setDiscriminatorValue(m != null && m.getDiscriminator() != null ? m.getDiscriminator() : entity.getClassName());
        GrailsDomainBinder.bindSimpleValue(STRING_TYPE, d, false, "class", mappings);
        ColumnConfig columnConfig = cc = m != null ? m.getDiscriminatorColumn() : null;
        if (cc != null) {
            Column c = (Column)d.getColumnIterator().next();
            if (cc.getName() != null) {
                c.setName(cc.getName());
            }
            GrailsDomainBinder.bindColumnConfigToColumn(c, cc);
        }
        entity.setPolymorphic(true);
    }

    private static void bindRootPersistentClassCommonValues(GrailsDomainClass domainClass, RootClass root, Mappings mappings) {
        boolean hasTableDefinition;
        Mapping m = GrailsDomainBinder.getMapping(domainClass.getClazz());
        String schema = mappings.getSchemaName();
        String catalog = mappings.getCatalogName();
        boolean bl = hasTableDefinition = m != null && m.getTable() != null;
        if (hasTableDefinition && m.getTable().getSchema() != null) {
            schema = m.getTable().getSchema();
        }
        if (hasTableDefinition && m.getTable().getCatalog() != null) {
            catalog = m.getTable().getCatalog();
        }
        Table table = mappings.addTable(schema, catalog, GrailsDomainBinder.getTableName(domainClass), null, false);
        root.setTable(table);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("[GrailsDomainBinder] Mapping Grails domain class: " + domainClass.getFullName() + " -> " + root.getTable().getName()));
        }
        GrailsDomainBinder.bindIdentity(domainClass, root, mappings, m);
        if (m != null) {
            if (m.getVersioned()) {
                GrailsDomainBinder.bindVersion(domainClass.getVersion(), root, mappings);
            }
        } else {
            GrailsDomainBinder.bindVersion(domainClass.getVersion(), root, mappings);
        }
        root.createPrimaryKey();
        GrailsDomainBinder.createClassProperties(domainClass, (PersistentClass)root, mappings);
    }

    private static void bindIdentity(GrailsDomainClass domainClass, RootClass root, Mappings mappings, Mapping gormMapping) {
        GrailsDomainClassProperty identifierProp = domainClass.getIdentifier();
        if (gormMapping != null) {
            Object id = gormMapping.getIdentity();
            if (id instanceof CompositeIdentity) {
                GrailsDomainBinder.bindCompositeId(domainClass, root, (CompositeIdentity)id, gormMapping, mappings);
            } else {
                Identity identity = (Identity)id;
                String propertyName = identity.getName();
                if (propertyName != null) {
                    GrailsDomainClassProperty namedIdentityProp = domainClass.getPropertyByName(propertyName);
                    if (namedIdentityProp == null) {
                        throw new MappingException("Mapping specifies an identifier property name that doesn't exist [" + propertyName + "]");
                    }
                    if (!namedIdentityProp.equals(identifierProp)) {
                        identifierProp = namedIdentityProp;
                    }
                }
                GrailsDomainBinder.bindSimpleId(identifierProp, root, mappings, identity);
            }
        } else {
            GrailsDomainBinder.bindSimpleId(identifierProp, root, mappings, null);
        }
    }

    private static void bindCompositeId(GrailsDomainClass domainClass, RootClass root, CompositeIdentity compositeIdentity, Mapping gormMapping, Mappings mappings) {
        String[] props;
        Component id = new Component((PersistentClass)root);
        id.setNullValue("undefined");
        root.setIdentifier((KeyValue)id);
        root.setEmbeddedIdentifier(true);
        id.setComponentClassName(domainClass.getFullName());
        id.setKey(true);
        id.setEmbedded(true);
        String path = StringHelper.qualify((String)root.getEntityName(), (String)"id");
        id.setRoleName(path);
        for (String propName : props = compositeIdentity.getPropertyNames()) {
            GrailsDomainClassProperty property = domainClass.getPropertyByName(propName);
            if (property == null) {
                throw new MappingException("Property [" + propName + "] referenced in composite-id mapping of class [" + domainClass.getFullName() + "] is not a valid property!");
            }
            GrailsDomainBinder.bindComponentProperty(id, null, property, (PersistentClass)root, EMPTY_PATH, root.getTable(), mappings);
        }
    }

    protected static void createClassProperties(GrailsDomainClass domainClass, PersistentClass persistentClass, Mappings mappings) {
        GrailsDomainClassProperty[] persistentProperties = domainClass.getPersistentProperties();
        Table table = persistentClass.getTable();
        Mapping gormMapping = GrailsDomainBinder.getMapping(domainClass.getClazz());
        for (GrailsDomainClassProperty currentGrailsProp : persistentProperties) {
            SimpleValue value;
            boolean isBidirectionalManyToOne = GrailsDomainBinder.isBidirectionalManyToOne(currentGrailsProp);
            if (currentGrailsProp.isInherited() || currentGrailsProp.isInherited() && isBidirectionalManyToOne && currentGrailsProp.isCircular() || GrailsDomainBinder.isCompositeIdProperty(gormMapping, currentGrailsProp) || GrailsDomainBinder.isIdentityProperty(gormMapping, currentGrailsProp)) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("[GrailsDomainBinder] Binding persistent property [" + currentGrailsProp.getName() + "]"));
            }
            CollectionType collectionType = CollectionType.collectionTypeForClass(currentGrailsProp.getType());
            Class userType = GrailsDomainBinder.getUserType(currentGrailsProp);
            if (collectionType != null) {
                Collection collection = collectionType.create(currentGrailsProp, persistentClass, EMPTY_PATH, mappings);
                mappings.addCollection(collection);
                value = collection;
            } else if (currentGrailsProp.isEnum()) {
                value = new SimpleValue(table);
                GrailsDomainBinder.bindEnumType(currentGrailsProp, value, EMPTY_PATH, mappings);
            } else if (currentGrailsProp.isManyToOne()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("[GrailsDomainBinder] Binding property [" + currentGrailsProp.getName() + "] as ManyToOne"));
                }
                value = new ManyToOne(table);
                GrailsDomainBinder.bindManyToOne(currentGrailsProp, (ManyToOne)value, EMPTY_PATH, mappings);
            } else if (currentGrailsProp.isOneToOne() && userType == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("[GrailsDomainBinder] Binding property [" + currentGrailsProp.getName() + "] as OneToOne"));
                }
                if (GrailsDomainBinder.canBindOneToOneWithSingleColumnAndForeignKey(currentGrailsProp)) {
                    value = new OneToOne(table, persistentClass);
                    GrailsDomainBinder.bindOneToOne(currentGrailsProp, (OneToOne)value, EMPTY_PATH, mappings);
                } else {
                    value = new ManyToOne(table);
                    GrailsDomainBinder.bindManyToOne(currentGrailsProp, (ManyToOne)value, EMPTY_PATH, mappings);
                }
            } else if (currentGrailsProp.isEmbedded()) {
                value = new Component(persistentClass);
                GrailsDomainBinder.bindComponent((Component)value, currentGrailsProp, true, mappings);
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("[GrailsDomainBinder] Binding property [" + currentGrailsProp.getName() + "] as SimpleValue"));
                }
                value = new SimpleValue(table);
                GrailsDomainBinder.bindSimpleValue(currentGrailsProp, value, EMPTY_PATH, mappings);
            }
            if (value == null) continue;
            Property property = GrailsDomainBinder.createProperty((Value)value, persistentClass, currentGrailsProp, mappings);
            persistentClass.addProperty(property);
        }
        GrailsDomainBinder.bindNaturalIdentifier(table, gormMapping, persistentClass);
    }

    private static void bindNaturalIdentifier(Table table, Mapping mapping, PersistentClass persistentClass) {
        Identity identity;
        NaturalId naturalId;
        Object o;
        Object object = o = mapping != null ? mapping.getIdentity() : null;
        if (o instanceof Identity && (naturalId = (identity = (Identity)o).getNatural()) != null && !naturalId.getPropertyNames().isEmpty()) {
            UniqueKey uk = new UniqueKey();
            uk.setName("_UniqueKey");
            uk.setTable(table);
            boolean mutable = naturalId.isMutable();
            for (String propertyName : naturalId.getPropertyNames()) {
                Property property = persistentClass.getProperty(propertyName);
                property.setNaturalIdentifier(true);
                if (!mutable) {
                    property.setUpdateable(false);
                }
                uk.addColumns(property.getColumnIterator());
            }
            table.addUniqueKey(uk);
        }
    }

    private static boolean canBindOneToOneWithSingleColumnAndForeignKey(GrailsDomainClassProperty currentGrailsProp) {
        if (currentGrailsProp.isBidirectional()) {
            GrailsDomainClassProperty otherSide = currentGrailsProp.getOtherSide();
            if (!currentGrailsProp.isOwningSide() && otherSide != null && otherSide.isOwningSide()) {
                return true;
            }
        }
        return false;
    }

    private static boolean isIdentityProperty(Mapping gormMapping, GrailsDomainClassProperty currentGrailsProp) {
        Identity identity;
        Object identityMapping;
        return gormMapping != null && (identityMapping = gormMapping.getIdentity()) instanceof Identity && (identity = (Identity)identityMapping).getName() != null && identity.getName() != null && identity.getName().equals(currentGrailsProp.getName());
    }

    private static void bindEnumType(GrailsDomainClassProperty property, SimpleValue simpleValue, String path, Mappings mappings) {
        Class propertyType = property.getType();
        GrailsDomainBinder.bindEnumType(property, propertyType, simpleValue, GrailsDomainBinder.getColumnNameForPropertyAndPath(property, path, null), path);
    }

    private static void bindEnumType(GrailsDomainClassProperty property, Class propertyType, SimpleValue simpleValue, String columnName, String path) {
        String enumType;
        Properties enumProperties = new Properties();
        enumProperties.put(ENUM_CLASS_PROP, propertyType.getName());
        PropertyConfig pc = GrailsDomainBinder.getPropertyConfig(property);
        String string = enumType = pc != null ? pc.getEnumType() : null;
        if (enumType == null && IdentityEnumType.supports(propertyType)) {
            simpleValue.setTypeName(IdentityEnumType.class.getName());
        } else {
            simpleValue.setTypeName(ENUM_TYPE_CLASS);
            if (enumType == null || STRING_TYPE.equalsIgnoreCase(enumType)) {
                enumProperties.put(ENUM_TYPE_PROP, String.valueOf(12));
            } else if (!"ordinal".equalsIgnoreCase(enumType)) {
                LOG.warn((Object)("Invalid enumType specified when mapping property [" + property.getName() + "] of class [" + property.getDomainClass().getClazz() + "]. Using defaults instead."));
            }
        }
        simpleValue.setTypeParameters(enumProperties);
        Table t = simpleValue.getTable();
        Column column = new Column();
        column.setNullable(property.isOptional());
        column.setValue((Value)simpleValue);
        column.setName(columnName);
        if (t != null) {
            t.addColumn(column);
        }
        simpleValue.addColumn(column);
    }

    private static Class getUserType(GrailsDomainClassProperty currentGrailsProp) {
        Object typeObj;
        Class<?> userType = null;
        PropertyConfig config = GrailsDomainBinder.getPropertyConfig(currentGrailsProp);
        Object object = typeObj = config != null ? config.getType() : null;
        if (typeObj instanceof Class) {
            userType = (Class<?>)typeObj;
        } else if (typeObj != null) {
            String typeName = typeObj.toString();
            try {
                userType = Class.forName(typeName);
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        return userType;
    }

    private static boolean isCompositeIdProperty(Mapping gormMapping, GrailsDomainClassProperty currentGrailsProp) {
        CompositeIdentity cid;
        Object id;
        return gormMapping != null && gormMapping.getIdentity() != null && (id = gormMapping.getIdentity()) instanceof CompositeIdentity && ArrayUtils.contains((Object[])(cid = (CompositeIdentity)id).getPropertyNames(), (Object)currentGrailsProp.getName());
    }

    private static boolean isBidirectionalManyToOne(GrailsDomainClassProperty currentGrailsProp) {
        return currentGrailsProp.isBidirectional() && currentGrailsProp.isManyToOne();
    }

    private static void bindComponent(Component component, GrailsDomainClassProperty property, boolean isNullable, Mappings mappings) {
        component.setEmbedded(true);
        Class type = property.getType();
        String role = StringHelper.qualify((String)type.getName(), (String)property.getName());
        component.setRoleName(role);
        component.setComponentClassName(type.getName());
        GrailsDomainClass domainClass = property.getReferencedDomainClass() != null ? property.getReferencedDomainClass() : property.getComponent();
        GrailsDomainClassProperty[] properties = domainClass.getPersistentProperties();
        Table table = component.getOwner().getTable();
        PersistentClass persistentClass = component.getOwner();
        String path = property.getName();
        Class propertyType = property.getDomainClass().getClazz();
        for (GrailsDomainClassProperty currentGrailsProp : properties) {
            if (currentGrailsProp.isIdentity() || currentGrailsProp.getName().equals("version")) continue;
            if (currentGrailsProp.getType().equals(propertyType)) {
                component.setParentProperty(currentGrailsProp.getName());
                continue;
            }
            GrailsDomainBinder.bindComponentProperty(component, property, currentGrailsProp, persistentClass, path, table, mappings);
        }
    }

    private static void bindComponentProperty(Component component, GrailsDomainClassProperty componentProperty, GrailsDomainClassProperty currentGrailsProp, PersistentClass persistentClass, String path, Table table, Mappings mappings) {
        ManyToOne value = null;
        CollectionType collectionType = CollectionType.collectionTypeForClass(currentGrailsProp.getType());
        if (collectionType != null) {
            Collection collection = collectionType.create(currentGrailsProp, persistentClass, path, mappings);
            mappings.addCollection(collection);
            value = collection;
        } else if (currentGrailsProp.isManyToOne()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("[GrailsDomainBinder] Binding property [" + currentGrailsProp.getName() + "] as ManyToOne"));
            }
            value = new ManyToOne(table);
            GrailsDomainBinder.bindManyToOne(currentGrailsProp, value, path, mappings);
        } else if (currentGrailsProp.isOneToOne()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("[GrailsDomainBinder] Binding property [" + currentGrailsProp.getName() + "] as OneToOne"));
            }
            if (GrailsDomainBinder.canBindOneToOneWithSingleColumnAndForeignKey(currentGrailsProp)) {
                value = new OneToOne(table, persistentClass);
                GrailsDomainBinder.bindOneToOne(currentGrailsProp, (OneToOne)value, path, mappings);
            } else {
                value = new ManyToOne(table);
                GrailsDomainBinder.bindManyToOne(currentGrailsProp, value, path, mappings);
            }
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("[GrailsDomainBinder] Binding property [" + currentGrailsProp.getName() + "] as SimpleValue"));
            }
            value = new SimpleValue(table);
            GrailsDomainBinder.bindSimpleValue(currentGrailsProp, (SimpleValue)value, path, mappings);
        }
        if (value != null) {
            Property persistentProperty = GrailsDomainBinder.createProperty((Value)value, persistentClass, currentGrailsProp, mappings);
            component.addProperty(persistentProperty);
            if (GrailsDomainBinder.isComponentPropertyNullable(componentProperty)) {
                Iterator columnIterator = value.getColumnIterator();
                while (columnIterator.hasNext()) {
                    Column c = (Column)columnIterator.next();
                    c.setNullable(true);
                }
            }
        }
    }

    private static boolean isComponentPropertyNullable(GrailsDomainClassProperty componentProperty) {
        if (componentProperty == null) {
            return false;
        }
        GrailsDomainClass domainClass = componentProperty.getDomainClass();
        Mapping mapping = GrailsDomainBinder.getMapping(domainClass.getClazz());
        return !domainClass.isRoot() && (mapping == null || mapping.isTablePerHierarchy()) || componentProperty.isOptional();
    }

    private static Property createProperty(Value value, PersistentClass persistentClass, GrailsDomainClassProperty grailsProperty, Mappings mappings) {
        value.setTypeUsingReflection(persistentClass.getClassName(), grailsProperty.getName());
        if (value.getTable() != null) {
            value.createForeignKey();
        }
        Property prop = new Property();
        PropertyConfig config = GrailsDomainBinder.getPropertyConfig(grailsProperty);
        if (config != null) {
            prop.setLazy(config.getLazy());
        } else if (grailsProperty.isManyToOne() || grailsProperty.isOneToOne()) {
            prop.setLazy(true);
        }
        prop.setValue(value);
        GrailsDomainBinder.bindProperty(grailsProperty, prop, mappings);
        return prop;
    }

    private static void bindOneToMany(GrailsDomainClassProperty currentGrailsProp, OneToMany one, Mappings mappings) {
        one.setReferencedEntityName(currentGrailsProp.getReferencedPropertyType().getName());
        PropertyConfig config = GrailsDomainBinder.getPropertyConfig(currentGrailsProp);
        one.setIgnoreNotFound(true);
    }

    private static void bindManyToOne(GrailsDomainClassProperty property, ManyToOne manyToOne, String path, Mappings mappings) {
        GrailsDomainBinder.bindManyToOneValues(property, manyToOne);
        GrailsDomainClass refDomainClass = property.isManyToMany() ? property.getDomainClass() : property.getReferencedDomainClass();
        Mapping mapping = GrailsDomainBinder.getMapping(refDomainClass);
        if (GrailsDomainBinder.hasCompositeIdentifier(mapping)) {
            CompositeIdentity ci = (CompositeIdentity)mapping.getIdentity();
            GrailsDomainBinder.bindCompositeIdentifierToManyToOne(property, (SimpleValue)manyToOne, ci, refDomainClass, path);
        } else if (property.isCircular() && property.isManyToMany()) {
            PropertyConfig pc = GrailsDomainBinder.getPropertyConfig(property);
            if (pc == null) {
                if (mapping == null) {
                    mapping = new Mapping();
                    MAPPING_CACHE.put(refDomainClass.getClazz(), mapping);
                }
                pc = new PropertyConfig();
                mapping.getColumns().put(property.getName(), pc);
            }
            if (!GrailsDomainBinder.hasJoinKeyMapping(pc)) {
                JoinTable jt = new JoinTable();
                ColumnConfig columnConfig = new ColumnConfig();
                columnConfig.setName(namingStrategy.propertyToColumnName(property.getName()) + '_' + FOREIGN_KEY_SUFFIX);
                jt.setKey(columnConfig);
                pc.setJoinTable(jt);
            }
            GrailsDomainBinder.bindSimpleValue(property, (SimpleValue)manyToOne, path, pc);
        } else {
            GrailsDomainBinder.bindSimpleValue(property, (SimpleValue)manyToOne, path, mappings);
        }
        PropertyConfig config = GrailsDomainBinder.getPropertyConfig(property);
        if (property.isOneToOne()) {
            manyToOne.setAlternateUniqueKey(true);
            Column c = GrailsDomainBinder.getColumnForSimpleValue((SimpleValue)manyToOne);
            if (config != null) {
                c.setUnique(config.isUnique());
            }
        }
    }

    private static void bindCompositeIdentifierToManyToOne(GrailsDomainClassProperty property, SimpleValue value, CompositeIdentity compositeId, GrailsDomainClass refDomainClass, String path) {
        String[] propertyNames = compositeId.getPropertyNames();
        PropertyConfig config = GrailsDomainBinder.getPropertyConfig(property);
        if (config == null) {
            config = new PropertyConfig();
        }
        for (String propertyName : propertyNames) {
            ColumnConfig cc = new ColumnConfig();
            cc.setName(namingStrategy.classToTableName(refDomainClass.getShortName()) + '_' + GrailsDomainBinder.getDefaultColumnName(refDomainClass.getPropertyByName(propertyName)));
            config.getColumns().add(cc);
        }
        GrailsDomainBinder.bindSimpleValue(property, value, path, config);
    }

    private static boolean hasCompositeIdentifier(Mapping mapping) {
        return mapping != null && mapping.getIdentity() instanceof CompositeIdentity;
    }

    private static void bindOneToOne(GrailsDomainClassProperty property, OneToOne oneToOne, String path, Mappings mappings) {
        PropertyConfig config = GrailsDomainBinder.getPropertyConfig(property);
        oneToOne.setConstrained(false);
        oneToOne.setForeignKeyType(ForeignKeyDirection.FOREIGN_KEY_TO_PARENT);
        oneToOne.setAlternateUniqueKey(true);
        if (config != null && config.getFetch() != null) {
            oneToOne.setFetchMode(config.getFetch());
        } else {
            oneToOne.setFetchMode(FetchMode.DEFAULT);
        }
        if (config != null) {
            oneToOne.setLazy(config.getLazy());
        } else {
            oneToOne.setLazy(true);
        }
        GrailsDomainClassProperty otherSide = property.getOtherSide();
        oneToOne.setReferencedEntityName(otherSide.getDomainClass().getFullName());
        oneToOne.setReferencedPropertyName(otherSide.getName());
    }

    private static void bindManyToOneValues(GrailsDomainClassProperty property, ManyToOne manyToOne) {
        PropertyConfig config = GrailsDomainBinder.getPropertyConfig(property);
        if (config != null && config.getFetch() != null) {
            manyToOne.setFetchMode(config.getFetch());
        } else {
            manyToOne.setFetchMode(FetchMode.DEFAULT);
        }
        if (config != null) {
            manyToOne.setLazy(config.getLazy());
            manyToOne.setIgnoreNotFound(config.getIgnoreNotFound());
        } else {
            manyToOne.setLazy(true);
        }
        manyToOne.setReferencedEntityName(property.getReferencedPropertyType().getName());
    }

    private static void bindVersion(GrailsDomainClassProperty version, RootClass entity, Mappings mappings) {
        SimpleValue val = new SimpleValue(entity.getTable());
        GrailsDomainBinder.bindSimpleValue(version, val, EMPTY_PATH, mappings);
        if (!val.isTypeSpecified()) {
            val.setTypeName("version".equals(version.getName()) ? "integer" : "timestamp");
        }
        Property prop = new Property();
        prop.setValue((Value)val);
        GrailsDomainBinder.bindProperty(version, prop, mappings);
        val.setNullValue("undefined");
        entity.setVersion(prop);
        entity.addProperty(prop);
    }

    private static void bindSimpleId(GrailsDomainClassProperty identifier, RootClass entity, Mappings mappings, Identity mappedId) {
        SimpleValue id = new SimpleValue(entity.getTable());
        Properties params = new Properties();
        entity.setIdentifier((KeyValue)id);
        if (mappedId != null) {
            id.setIdentifierGeneratorStrategy(mappedId.getGenerator());
            params.putAll((java.util.Map<?, ?>)mappedId.getParams());
            if ("assigned".equals(mappedId.getGenerator())) {
                id.setNullValue("undefined");
            }
        } else {
            id.setIdentifierGeneratorStrategy("native");
        }
        if (mappings.getSchemaName() != null) {
            params.setProperty("schema", mappings.getSchemaName());
        }
        if (mappings.getCatalogName() != null) {
            params.setProperty("catalog", mappings.getCatalogName());
        }
        id.setIdentifierGeneratorProperties(params);
        GrailsDomainBinder.bindSimpleValue(identifier, id, EMPTY_PATH, mappings);
        Property prop = new Property();
        prop.setValue((Value)id);
        GrailsDomainBinder.bindProperty(identifier, prop, mappings);
        entity.setIdentifierProperty(prop);
        id.getTable().setIdentifierValue((KeyValue)id);
    }

    private static void bindProperty(GrailsDomainClassProperty grailsProperty, Property prop, Mappings mappings) {
        prop.setName(grailsProperty.getName());
        if (GrailsDomainBinder.isBidirectionalManyToOneWithListMapping(grailsProperty, prop)) {
            prop.setInsertable(false);
            prop.setUpdateable(false);
        } else {
            prop.setInsertable(true);
            prop.setUpdateable(true);
        }
        prop.setPropertyAccessorName(mappings.getDefaultAccess());
        prop.setOptional(grailsProperty.isOptional());
        GrailsDomainBinder.setCascadeBehaviour(grailsProperty, prop);
        prop.setLazy(true);
    }

    private static boolean isBidirectionalManyToOneWithListMapping(GrailsDomainClassProperty grailsProperty, Property prop) {
        GrailsDomainClassProperty otherSide = grailsProperty.getOtherSide();
        return grailsProperty.isBidirectional() && otherSide != null && prop.getValue() instanceof ManyToOne && List.class.isAssignableFrom(otherSide.getType());
    }

    private static void setCascadeBehaviour(GrailsDomainClassProperty grailsProperty, Property prop) {
        String cascadeStrategy = CASCADE_NONE;
        GrailsDomainClass domainClass = grailsProperty.getDomainClass();
        PropertyConfig config = GrailsDomainBinder.getPropertyConfig(grailsProperty);
        GrailsDomainClass referenced = grailsProperty.getReferencedDomainClass();
        if (config != null && config.getCascade() != null) {
            cascadeStrategy = config.getCascade();
        } else if (grailsProperty.isAssociation()) {
            if (grailsProperty.isOneToOne()) {
                if (referenced != null && referenced.isOwningClass(domainClass.getClazz())) {
                    cascadeStrategy = CASCADE_ALL;
                }
            } else if (grailsProperty.isOneToMany()) {
                cascadeStrategy = referenced != null && referenced.isOwningClass(domainClass.getClazz()) ? CASCADE_ALL : CASCADE_SAVE_UPDATE;
            } else if (grailsProperty.isManyToMany()) {
                if (referenced != null && referenced.isOwningClass(domainClass.getClazz()) || grailsProperty.isCircular()) {
                    cascadeStrategy = CASCADE_SAVE_UPDATE;
                }
            } else if (grailsProperty.isManyToOne()) {
                cascadeStrategy = referenced != null && referenced.isOwningClass(domainClass.getClazz()) && !GrailsDomainBinder.isCircularAssociation(grailsProperty) ? CASCADE_ALL : CASCADE_NONE;
            }
        } else if (grailsProperty.isBasicCollectionType()) {
            cascadeStrategy = CASCADE_ALL;
        } else if (java.util.Map.class.isAssignableFrom(grailsProperty.getType())) {
            referenced = grailsProperty.getReferencedDomainClass();
            cascadeStrategy = referenced != null && referenced.isOwningClass(grailsProperty.getDomainClass().getClazz()) ? CASCADE_ALL : CASCADE_SAVE_UPDATE;
        }
        GrailsDomainBinder.logCascadeMapping(grailsProperty, cascadeStrategy, referenced);
        prop.setCascade(cascadeStrategy);
    }

    private static boolean isCircularAssociation(GrailsDomainClassProperty grailsProperty) {
        return grailsProperty.getType().equals(grailsProperty.getDomainClass().getClazz());
    }

    private static void logCascadeMapping(GrailsDomainClassProperty grailsProperty, String cascadeStrategy, GrailsDomainClass referenced) {
        if (LOG.isDebugEnabled() && grailsProperty.isAssociation() && referenced != null) {
            String assType = GrailsDomainBinder.getAssociationDescription(grailsProperty);
            LOG.debug((Object)("Mapping cascade strategy for " + assType + " property " + grailsProperty.getDomainClass().getFullName() + "." + grailsProperty.getName() + " referencing type [" + referenced.getClazz() + "] -> [CASCADE: " + cascadeStrategy + "]"));
        }
    }

    private static String getAssociationDescription(GrailsDomainClassProperty grailsProperty) {
        String assType = "unknown";
        if (grailsProperty.isManyToMany()) {
            assType = "many-to-many";
        } else if (grailsProperty.isOneToMany()) {
            assType = "one-to-many";
        } else if (grailsProperty.isOneToOne()) {
            assType = "one-to-one";
        } else if (grailsProperty.isManyToOne()) {
            assType = "many-to-one";
        } else if (grailsProperty.isEmbedded()) {
            assType = "embedded";
        }
        return assType;
    }

    private static void bindSimpleValue(GrailsDomainClassProperty grailsProp, SimpleValue simpleValue, String path, Mappings mappings) {
        PropertyConfig propertyConfig = GrailsDomainBinder.getPropertyConfig(grailsProp);
        GrailsDomainBinder.bindSimpleValue(grailsProp, simpleValue, path, propertyConfig);
    }

    private static void bindSimpleValue(GrailsDomainClassProperty grailsProp, SimpleValue simpleValue, String path, PropertyConfig propertyConfig) {
        List<Object> columnDefinitions;
        GrailsDomainBinder.setTypeForPropertyConfig(grailsProp, simpleValue, propertyConfig);
        Table table = simpleValue.getTable();
        List<Object> list = columnDefinitions = propertyConfig != null ? propertyConfig.getColumns() : Arrays.asList(new Object[]{null});
        if (columnDefinitions.isEmpty()) {
            columnDefinitions = Arrays.asList(new Object[]{null});
        }
        int n = columnDefinitions.size();
        for (int i = 0; i < n; ++i) {
            ColumnConfig cc = (ColumnConfig)columnDefinitions.get(i);
            Column column = new Column();
            if (cc != null) {
                if (cc.getName() != null) {
                    column.setName(cc.getName());
                }
                if (cc.getSqlType() != null) {
                    column.setSqlType(cc.getSqlType());
                }
            }
            column.setValue((Value)simpleValue);
            GrailsDomainBinder.bindColumn(grailsProp, column, cc, path, table);
            if (table != null) {
                table.addColumn(column);
            }
            simpleValue.addColumn(column);
        }
    }

    private static void setTypeForPropertyConfig(GrailsDomainClassProperty grailsProp, SimpleValue simpleValue, PropertyConfig config) {
        if (config != null && config.getType() != null) {
            Object type = config.getType();
            if (type instanceof Class) {
                simpleValue.setTypeName(((Class)type).getName());
            } else {
                simpleValue.setTypeName(type.toString());
            }
        } else {
            simpleValue.setTypeName(grailsProp.getType().getName());
        }
    }

    private static void bindSimpleValue(String type, SimpleValue simpleValue, boolean nullable, String columnName, Mappings mappings) {
        simpleValue.setTypeName(type);
        Table t = simpleValue.getTable();
        Column column = new Column();
        column.setNullable(nullable);
        column.setValue((Value)simpleValue);
        column.setName(columnName);
        if (t != null) {
            t.addColumn(column);
        }
        simpleValue.addColumn(column);
    }

    private static void bindColumn(GrailsDomainClassProperty property, Column column, ColumnConfig cc, String path, Table table) {
        Class userType = GrailsDomainBinder.getUserType(property);
        String columnName = GrailsDomainBinder.getColumnNameForPropertyAndPath(property, path, cc);
        if ((property.isAssociation() || property.isBasicCollectionType()) && userType == null) {
            if (column.getName() == null) {
                column.setName(columnName);
            }
            if (property.isManyToMany()) {
                column.setNullable(false);
            } else if (property.isOneToOne() && property.isBidirectional() && !property.isOwningSide()) {
                column.setNullable(true);
            } else if ((property.isManyToOne() || property.isOneToOne()) && property.isCircular()) {
                column.setNullable(true);
            } else {
                column.setNullable(property.isOptional());
            }
        } else {
            column.setName(columnName);
            column.setNullable(property.isOptional());
            ConstrainedProperty constrainedProperty = GrailsDomainBinder.getConstrainedProperty(property);
            if (constrainedProperty != null) {
                if (String.class.isAssignableFrom(property.getType()) || byte[].class.isAssignableFrom(property.getType())) {
                    GrailsDomainBinder.bindStringColumnConstraints(column, constrainedProperty);
                }
                if (Number.class.isAssignableFrom(property.getType())) {
                    GrailsDomainBinder.bindNumericColumnConstraints(column, constrainedProperty);
                }
            }
        }
        ConstrainedProperty cp = GrailsDomainBinder.getConstrainedProperty(property);
        if (cp != null && cp.hasAppliedConstraint("unique")) {
            UniqueConstraint uc = (UniqueConstraint)cp.getAppliedConstraint("unique");
            if (uc != null && uc.isUnique()) {
                if (!uc.isUniqueWithinGroup()) {
                    column.setUnique(true);
                } else if (uc.getUniquenessGroup().size() > 0) {
                    GrailsDomainBinder.createKeyForProps(property, path, table, columnName, uc.getUniquenessGroup());
                }
            }
        } else {
            Object val;
            Object object = val = cp != null ? cp.getMetaConstraintValue("unique") : null;
            if (val instanceof Boolean) {
                column.setUnique(((Boolean)val).booleanValue());
            } else if (val instanceof String) {
                GrailsDomainBinder.createKeyForProps(property, path, table, columnName, Arrays.asList((String)val));
            } else if (val instanceof List && ((List)val).size() > 0) {
                GrailsDomainBinder.createKeyForProps(property, path, table, columnName, (List)val);
            }
        }
        GrailsDomainBinder.bindIndex(column, cc, table);
        if (!property.getDomainClass().isRoot()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("[GrailsDomainBinder] Sub class property [" + property.getName() + "] for column name [" + column.getName() + "] in table [" + table.getName() + "] set to nullable"));
            }
            column.setNullable(true);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("[GrailsDomainBinder] bound property [" + property.getName() + "] to column name [" + column.getName() + "] in table [" + table.getName() + "]"));
        }
    }

    private static void createKeyForProps(GrailsDomainClassProperty grailsProp, String path, Table table, String columnName, List propertyNames) {
        ArrayList<Column> keyList = new ArrayList<Column>();
        keyList.add(new Column(columnName));
        for (String propertyName : propertyNames) {
            GrailsDomainClassProperty otherProp = grailsProp.getDomainClass().getPropertyByName(propertyName);
            String otherColumnName = GrailsDomainBinder.getColumnNameForPropertyAndPath(otherProp, path, null);
            keyList.add(new Column(otherColumnName));
        }
        GrailsDomainBinder.createUniqueKeyForColumns(table, columnName, keyList);
    }

    private static void createUniqueKeyForColumns(Table table, String columnName, List keyList) {
        Collections.reverse(keyList);
        UniqueKey key = table.getOrCreateUniqueKey("unique-" + columnName);
        List columns = key.getColumns();
        if (columns.size() == 0) {
            LOG.debug((Object)("create unique key for " + table.getName() + " columns = " + keyList));
            key.addColumns(keyList.iterator());
        }
    }

    private static void bindIndex(Column column, ColumnConfig cc, Table table) {
        String indexDefinition;
        if (cc != null && (indexDefinition = cc.getIndex()) != null) {
            String[] tokens = indexDefinition.split(",");
            for (int i = 0; i < tokens.length; ++i) {
                String index = tokens[i];
                table.getOrCreateIndex(index).addColumn(column);
            }
        }
    }

    private static String getColumnNameForPropertyAndPath(GrailsDomainClassProperty grailsProp, String path, ColumnConfig cc) {
        String columnName = null;
        if (cc != null) {
            PropertyConfig pc;
            columnName = GrailsDomainBinder.supportsJoinColumnMapping(grailsProp) ? (GrailsDomainBinder.hasJoinKeyMapping(pc = GrailsDomainBinder.getPropertyConfig(grailsProp)) ? pc.getJoinTable().getKey().getName() : cc.getName()) : cc.getName();
        } else {
            GrailsDomainClass domainClass = grailsProp.getDomainClass();
            Mapping m = GrailsDomainBinder.getMapping(domainClass.getClazz());
            if (m != null) {
                PropertyConfig c = m.getPropertyConfig(grailsProp.getName());
                if (GrailsDomainBinder.supportsJoinColumnMapping(grailsProp) && GrailsDomainBinder.hasJoinKeyMapping(c)) {
                    columnName = c.getJoinTable().getKey().getName();
                } else if (c != null && c.getColumn() != null) {
                    columnName = c.getColumn();
                }
            }
        }
        if (columnName == null) {
            columnName = StringHelper.isNotEmpty((String)path) ? namingStrategy.propertyToColumnName(path) + '_' + GrailsDomainBinder.getDefaultColumnName(grailsProp) : GrailsDomainBinder.getDefaultColumnName(grailsProp);
        }
        return columnName;
    }

    private static boolean hasJoinKeyMapping(PropertyConfig c) {
        return c != null && c.getJoinTable() != null && c.getJoinTable().getKey() != null;
    }

    private static boolean supportsJoinColumnMapping(GrailsDomainClassProperty grailsProp) {
        return grailsProp.isManyToMany() || GrailsDomainBinder.isUnidirectionalOneToMany(grailsProp) || grailsProp.isBasicCollectionType();
    }

    private static String getDefaultColumnName(GrailsDomainClassProperty property) {
        String columnName = namingStrategy.propertyToColumnName(property.getName());
        if (property.isAssociation() && property.getReferencedDomainClass() != null) {
            if (property.isManyToMany()) {
                return GrailsDomainBinder.getForeignKeyForPropertyDomainClass(property);
            }
            if (!property.isBidirectional() && property.isOneToMany()) {
                String prefix = namingStrategy.classToTableName(property.getDomainClass().getName());
                return prefix + '_' + columnName + FOREIGN_KEY_SUFFIX;
            }
            if (property.isInherited() && GrailsDomainBinder.isBidirectionalManyToOne(property)) {
                return namingStrategy.propertyToColumnName(property.getDomainClass().getName()) + '_' + columnName + FOREIGN_KEY_SUFFIX;
            }
            return columnName + FOREIGN_KEY_SUFFIX;
        }
        if (property.isBasicCollectionType()) {
            return GrailsDomainBinder.getForeignKeyForPropertyDomainClass(property);
        }
        return columnName;
    }

    private static String getForeignKeyForPropertyDomainClass(GrailsDomainClassProperty property) {
        String propertyName = property.getDomainClass().getPropertyName();
        return namingStrategy.propertyToColumnName(propertyName) + FOREIGN_KEY_SUFFIX;
    }

    private static String getIndexColumnName(GrailsDomainClassProperty property) {
        PropertyConfig pc = GrailsDomainBinder.getPropertyConfig(property);
        if (pc != null && pc.getIndexColumn() != null && pc.getIndexColumn().getColumn() != null) {
            return pc.getIndexColumn().getColumn();
        }
        return namingStrategy.propertyToColumnName(property.getName()) + '_' + "idx";
    }

    private static String getIndexColumnType(GrailsDomainClassProperty property, String defaultType) {
        PropertyConfig pc = GrailsDomainBinder.getPropertyConfig(property);
        if (pc != null && pc.getIndexColumn() != null && pc.getIndexColumn().getType() != null) {
            return GrailsDomainBinder.getTypeName(pc.getIndexColumn());
        }
        return defaultType;
    }

    private static String getMapElementName(GrailsDomainClassProperty property) {
        PropertyConfig pc = GrailsDomainBinder.getPropertyConfig(property);
        if (GrailsDomainBinder.hasJoinTableColumnNameMapping(pc)) {
            return pc.getJoinTable().getColumn().getName();
        }
        return namingStrategy.propertyToColumnName(property.getName()) + '_' + "elt";
    }

    private static boolean hasJoinTableColumnNameMapping(PropertyConfig pc) {
        return pc != null && pc.getJoinTable() != null && pc.getJoinTable().getColumn() != null && pc.getJoinTable().getColumn().getName() != null;
    }

    private static ConstrainedProperty getConstrainedProperty(GrailsDomainClassProperty grailsProp) {
        ConstrainedProperty constrainedProperty = null;
        java.util.Map constraints = grailsProp.getDomainClass().getConstrainedProperties();
        Iterator constrainedPropertyIter = constraints.values().iterator();
        while (constrainedPropertyIter.hasNext() && constrainedProperty == null) {
            ConstrainedProperty tmpConstrainedProperty = (ConstrainedProperty)constrainedPropertyIter.next();
            if (!tmpConstrainedProperty.getPropertyName().equals(grailsProp.getName())) continue;
            constrainedProperty = tmpConstrainedProperty;
        }
        return constrainedProperty;
    }

    protected static void bindStringColumnConstraints(Column column, ConstrainedProperty constrainedProperty) {
        Integer columnLength = constrainedProperty.getMaxSize();
        List inListValues = constrainedProperty.getInList();
        if (columnLength != null) {
            column.setLength(columnLength.intValue());
        } else if (inListValues != null) {
            column.setLength(GrailsDomainBinder.getMaxSize(inListValues));
        }
    }

    protected static void bindNumericColumnConstraints(Column column, ConstrainedProperty constrainedProperty) {
        int scale = 2;
        int precision = 19;
        if (constrainedProperty.getScale() != null) {
            scale = constrainedProperty.getScale();
            column.setScale(scale);
        }
        Comparable minConstraintValue = constrainedProperty.getMin();
        Comparable maxConstraintValue = constrainedProperty.getMax();
        int minConstraintValueLength = 0;
        if (minConstraintValue != null && minConstraintValue instanceof Number) {
            minConstraintValueLength = Math.max(GrailsDomainBinder.countDigits((Number)((Object)minConstraintValue)), GrailsDomainBinder.countDigits(new Long(((Number)((Object)minConstraintValue)).longValue())) + scale);
        }
        int maxConstraintValueLength = 0;
        if (maxConstraintValue != null && maxConstraintValue instanceof Number) {
            maxConstraintValueLength = Math.max(GrailsDomainBinder.countDigits((Number)((Object)maxConstraintValue)), GrailsDomainBinder.countDigits(new Long(((Number)((Object)maxConstraintValue)).longValue())) + scale);
        }
        precision = minConstraintValueLength > 0 && maxConstraintValueLength > 0 ? NumberUtils.max((int[])new int[]{minConstraintValueLength, maxConstraintValueLength}) : NumberUtils.max((int[])new int[]{precision, minConstraintValueLength, maxConstraintValueLength});
        column.setPrecision(precision);
    }

    private static int countDigits(Number number) {
        int numDigits = 0;
        if (number != null) {
            String digitsOnly = number.toString().replaceAll("\\D", EMPTY_PATH);
            numDigits = digitsOnly.length();
        }
        return numDigits;
    }

    private static int getMaxSize(List inListValues) {
        int maxSize = 0;
        for (String value : inListValues) {
            maxSize = Math.max(value.length(), maxSize);
        }
        return maxSize;
    }

    static class MapSecondPass
    extends GrailsCollectionSecondPass {
        public MapSecondPass(GrailsDomainClassProperty property, Mappings mappings, Collection coll) {
            super(property, mappings, coll);
        }

        public void doSecondPass(java.util.Map persistentClasses, java.util.Map inheritedMetas) throws MappingException {
            GrailsDomainBinder.bindMapSecondPass(this.property, this.mappings, persistentClasses, (Map)this.collection, inheritedMetas);
        }

        public void doSecondPass(java.util.Map persistentClasses) throws MappingException {
            GrailsDomainBinder.bindMapSecondPass(this.property, this.mappings, persistentClasses, (Map)this.collection, Collections.EMPTY_MAP);
        }
    }

    static class ListSecondPass
    extends GrailsCollectionSecondPass {
        public ListSecondPass(GrailsDomainClassProperty property, Mappings mappings, Collection coll) {
            super(property, mappings, coll);
        }

        public void doSecondPass(java.util.Map persistentClasses, java.util.Map inheritedMetas) throws MappingException {
            GrailsDomainBinder.bindListSecondPass(this.property, this.mappings, persistentClasses, (org.hibernate.mapping.List)this.collection, inheritedMetas);
        }

        public void doSecondPass(java.util.Map persistentClasses) throws MappingException {
            GrailsDomainBinder.bindListSecondPass(this.property, this.mappings, persistentClasses, (org.hibernate.mapping.List)this.collection, Collections.EMPTY_MAP);
        }
    }

    static class GrailsCollectionSecondPass
    implements SecondPass {
        protected static final long serialVersionUID = -5540526942092611348L;
        protected GrailsDomainClassProperty property;
        protected Mappings mappings;
        protected Collection collection;

        public GrailsCollectionSecondPass(GrailsDomainClassProperty property, Mappings mappings, Collection coll) {
            this.property = property;
            this.mappings = mappings;
            this.collection = coll;
        }

        public void doSecondPass(java.util.Map persistentClasses, java.util.Map inheritedMetas) throws MappingException {
            GrailsDomainBinder.bindCollectionSecondPass(this.property, this.mappings, persistentClasses, this.collection, inheritedMetas);
            this.createCollectionKeys();
        }

        private void createCollectionKeys() {
            this.collection.createAllKeys();
            if (LOG.isDebugEnabled()) {
                String msg = "Mapped collection key: " + GrailsCollectionSecondPass.columns((Value)this.collection.getKey());
                if (this.collection.isIndexed()) {
                    msg = msg + ", index: " + GrailsCollectionSecondPass.columns(((IndexedCollection)this.collection).getIndex());
                }
                msg = this.collection.isOneToMany() ? msg + ", one-to-many: " + ((OneToMany)this.collection.getElement()).getReferencedEntityName() : msg + ", element: " + GrailsCollectionSecondPass.columns(this.collection.getElement());
                LOG.debug((Object)msg);
            }
        }

        private static String columns(Value val) {
            StringBuilder columns = new StringBuilder();
            Iterator iter = val.getColumnIterator();
            while (iter.hasNext()) {
                columns.append(((Selectable)iter.next()).getText());
                if (!iter.hasNext()) continue;
                columns.append(", ");
            }
            return columns.toString();
        }

        public void doSecondPass(java.util.Map persistentClasses) throws MappingException {
            GrailsDomainBinder.bindCollectionSecondPass(this.property, this.mappings, persistentClasses, this.collection, Collections.EMPTY_MAP);
            this.createCollectionKeys();
        }
    }

    static abstract class CollectionType {
        private Class clazz;
        private static CollectionType SET = new CollectionType(java.util.Set.class){

            public Collection create(GrailsDomainClassProperty property, PersistentClass owner, String path, Mappings mappings) throws MappingException {
                Set coll = new Set(owner);
                coll.setCollectionTable(owner.getTable());
                GrailsDomainBinder.bindCollection(property, (Collection)coll, owner, mappings, path);
                return coll;
            }
        };
        private static CollectionType LIST = new CollectionType(List.class){

            public Collection create(GrailsDomainClassProperty property, PersistentClass owner, String path, Mappings mappings) throws MappingException {
                org.hibernate.mapping.List coll = new org.hibernate.mapping.List(owner);
                coll.setCollectionTable(owner.getTable());
                GrailsDomainBinder.bindCollection(property, (Collection)coll, owner, mappings, path);
                return coll;
            }
        };
        private static CollectionType MAP = new CollectionType(java.util.Map.class){

            public Collection create(GrailsDomainClassProperty property, PersistentClass owner, String path, Mappings mappings) throws MappingException {
                Map map = new Map(owner);
                GrailsDomainBinder.bindCollection(property, (Collection)map, owner, mappings, path);
                return map;
            }
        };
        private static final java.util.Map INSTANCES = new HashMap();

        public abstract Collection create(GrailsDomainClassProperty var1, PersistentClass var2, String var3, Mappings var4) throws MappingException;

        CollectionType(Class clazz) {
            this.clazz = clazz;
        }

        public String toString() {
            return this.clazz.getName();
        }

        public static CollectionType collectionTypeForClass(Class clazz) {
            return (CollectionType)INSTANCES.get(clazz);
        }

        static {
            INSTANCES.put(java.util.Set.class, SET);
            INSTANCES.put(SortedSet.class, SET);
            INSTANCES.put(List.class, LIST);
            INSTANCES.put(java.util.Map.class, MAP);
        }
    }
}

