/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.orm.hibernate.metaclass;

import java.util.regex.Pattern;
import org.codehaus.groovy.grails.commons.metaclass.AbstractDynamicMethodInvocation;
import org.codehaus.groovy.grails.orm.hibernate.cfg.GrailsHibernateUtil;
import org.hibernate.SessionFactory;
import org.springframework.orm.hibernate3.HibernateTemplate;
import org.springframework.util.Assert;

public abstract class AbstractDynamicPersistentMethod
extends AbstractDynamicMethodInvocation {
    private SessionFactory sessionFactory = null;
    private ClassLoader classLoader = null;

    public AbstractDynamicPersistentMethod(Pattern pattern, SessionFactory sessionFactory, ClassLoader classLoader) {
        super(pattern);
        this.sessionFactory = sessionFactory;
        this.classLoader = classLoader;
    }

    protected HibernateTemplate getHibernateTemplate() {
        Assert.notNull((Object)this.sessionFactory, (String)"Session factory is required!");
        return new HibernateTemplate(this.sessionFactory);
    }

    public Object invoke(Object target, String methodName, Object[] arguments) {
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.classLoader);
        Object returnValue = this.doInvokeInternal(target, arguments);
        Thread.currentThread().setContextClassLoader(originalClassLoader);
        return returnValue;
    }

    protected abstract Object doInvokeInternal(Object var1, Object[] var2);

    protected void setObjectToReadOnly(Object target) {
        SessionFactory sessionFactory = this.getHibernateTemplate().getSessionFactory();
        GrailsHibernateUtil.setObjectToReadyOnly(target, sessionFactory);
    }

    protected void setObjectToReadWrite(Object target) {
        SessionFactory sessionFactory = this.getHibernateTemplate().getSessionFactory();
        GrailsHibernateUtil.setObjectToReadWrite(target, sessionFactory);
    }
}

