/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.orm.hibernate.metaclass;

import groovy.lang.GroovyObject;
import groovy.lang.GroovySystem;
import groovy.lang.MetaClass;
import java.io.Serializable;
import java.util.Map;
import java.util.regex.Pattern;
import org.codehaus.groovy.grails.commons.GrailsApplication;
import org.codehaus.groovy.grails.commons.GrailsClassUtils;
import org.codehaus.groovy.grails.commons.GrailsDomainClass;
import org.codehaus.groovy.grails.commons.GrailsDomainClassProperty;
import org.codehaus.groovy.grails.orm.hibernate.metaclass.AbstractDynamicPersistentMethod;
import org.codehaus.groovy.grails.validation.CascadingValidator;
import org.hibernate.SessionFactory;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.InvalidPropertyException;
import org.springframework.orm.hibernate3.HibernateTemplate;
import org.springframework.validation.BeanPropertyBindingResult;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;

public abstract class AbstractSavePersistentMethod
extends AbstractDynamicPersistentMethod {
    private GrailsApplication application;
    private static final String ARGUMENT_VALIDATE = "validate";
    private static final String ARGUMENT_DEEP_VALIDATE = "deepValidate";
    private static final String ARGUMENT_FLUSH = "flush";
    private static final String ARGUMENT_INSERT = "insert";
    private static final String ERRORS_PROPERTY = "errors";

    public AbstractSavePersistentMethod(Pattern pattern, SessionFactory sessionFactory, ClassLoader classLoader, GrailsApplication application) {
        super(pattern, sessionFactory, classLoader);
        if (application == null) {
            throw new IllegalArgumentException("Constructor argument 'application' cannot be null");
        }
        this.application = application;
    }

    protected Object doInvokeInternal(Object target, Object[] arguments) {
        GrailsDomainClass domainClass = (GrailsDomainClass)this.application.getArtefact("Domain", target.getClass().getName());
        if (this.shouldValidate(arguments, domainClass)) {
            Validator validator = domainClass.getValidator();
            MetaClass mc = GroovySystem.getMetaClassRegistry().getMetaClass(target.getClass());
            BeanPropertyBindingResult errors = new BeanPropertyBindingResult(target, target.getClass().getName());
            mc.setProperty(target, ERRORS_PROPERTY, (Object)errors);
            if (validator != null) {
                Map argsMap;
                boolean deepValidate = true;
                if (arguments.length > 0 && arguments[0] instanceof Map && (argsMap = (Map)arguments[0]).containsKey(ARGUMENT_DEEP_VALIDATE)) {
                    deepValidate = GrailsClassUtils.getBooleanFromMap((String)ARGUMENT_DEEP_VALIDATE, (Map)argsMap);
                }
                if (deepValidate && validator instanceof CascadingValidator) {
                    ((CascadingValidator)validator).validate(target, (Errors)errors, deepValidate);
                } else {
                    validator.validate(target, (Errors)errors);
                }
                if (errors.hasErrors()) {
                    return this.handleValidationError(target, (Errors)errors);
                }
                this.setObjectToReadWrite(target);
            }
        }
        if (domainClass != null) {
            this.autoRetrieveAssocations(domainClass, target);
        }
        if (this.shouldInsert(arguments)) {
            return this.performInsert(target, this.shouldFlush(arguments));
        }
        return this.performSave(target, this.shouldFlush(arguments));
    }

    private boolean shouldInsert(Object[] arguments) {
        return arguments.length > 0 && arguments[0] instanceof Map && GrailsClassUtils.getBooleanFromMap((String)ARGUMENT_INSERT, (Map)((Map)arguments[0]));
    }

    private boolean shouldFlush(Object[] arguments) {
        if (arguments.length > 0) {
            if (arguments[0] instanceof Boolean) {
                return (Boolean)arguments[0];
            }
            if (arguments[0] instanceof Map) {
                Map argsMap = (Map)arguments[0];
                if (argsMap.containsKey(ARGUMENT_FLUSH)) {
                    return GrailsClassUtils.getBooleanFromMap((String)ARGUMENT_FLUSH, (Map)argsMap);
                }
            } else {
                return false;
            }
        }
        return false;
    }

    private void autoRetrieveAssocations(GrailsDomainClass domainClass, Object target) {
        BeanWrapperImpl bean = new BeanWrapperImpl(target);
        HibernateTemplate t = this.getHibernateTemplate();
        GrailsDomainClassProperty[] props = domainClass.getPersistentProperties();
        for (int i = 0; i < props.length; ++i) {
            GrailsDomainClass otherSide;
            Object propValue;
            GrailsDomainClassProperty prop = props[i];
            if (!prop.isManyToOne() && !prop.isOneToOne() || (propValue = bean.getPropertyValue(prop.getName())) == null || t.contains(propValue) || (otherSide = (GrailsDomainClass)this.application.getArtefact("Domain", prop.getType().getName())) == null) continue;
            BeanWrapperImpl propBean = new BeanWrapperImpl(propValue);
            try {
                Serializable id = (Serializable)propBean.getPropertyValue(otherSide.getIdentifier().getName());
                if (id == null) continue;
                bean.setPropertyValue(prop.getName(), t.get(prop.getType(), id));
                continue;
            }
            catch (InvalidPropertyException ipe) {
                // empty catch block
            }
        }
    }

    protected Object handleValidationError(Object target, Errors errors) {
        this.setObjectToReadOnly(target);
        this.setErrorsOnInstance(target, errors);
        return null;
    }

    protected void setErrorsOnInstance(Object target, Errors errors) {
        if (target instanceof GroovyObject) {
            ((GroovyObject)target).setProperty(ERRORS_PROPERTY, (Object)errors);
        } else {
            MetaClass metaClass = GroovySystem.getMetaClassRegistry().getMetaClass(target.getClass());
            metaClass.setProperty(target.getClass(), target, ERRORS_PROPERTY, (Object)errors, false, false);
        }
    }

    private boolean shouldValidate(Object[] arguments, GrailsDomainClass domainClass) {
        if (domainClass != null) {
            if (arguments.length > 0) {
                if (arguments[0] instanceof Boolean) {
                    return (Boolean)arguments[0];
                }
                if (arguments[0] instanceof Map) {
                    Map argsMap = (Map)arguments[0];
                    if (argsMap.containsKey(ARGUMENT_VALIDATE)) {
                        return GrailsClassUtils.getBooleanFromMap((String)ARGUMENT_VALIDATE, (Map)argsMap);
                    }
                    return true;
                }
                return true;
            }
            return true;
        }
        return false;
    }

    protected abstract Object performSave(Object var1, boolean var2);

    protected abstract Object performInsert(Object var1, boolean var2);
}

