/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.orm.hibernate.metaclass;

import java.sql.SQLException;
import java.util.regex.Pattern;
import org.codehaus.groovy.grails.commons.GrailsApplication;
import org.codehaus.groovy.grails.orm.hibernate.metaclass.AbstractSavePersistentMethod;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.HibernateTemplate;

public class MergePersistentMethod
extends AbstractSavePersistentMethod {
    public static final String METHOD_SIGNATURE = "merge";
    public static final Pattern METHOD_PATTERN = Pattern.compile("^merge$");

    public MergePersistentMethod(SessionFactory sessionFactory, ClassLoader classLoader, GrailsApplication application) {
        super(METHOD_PATTERN, sessionFactory, classLoader, application);
    }

    protected Object performSave(final Object target, final boolean flush) {
        HibernateTemplate ht = this.getHibernateTemplate();
        return ht.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Object merged = session.merge(target);
                session.lock(merged, LockMode.NONE);
                if (flush) {
                    MergePersistentMethod.this.getHibernateTemplate().flush();
                }
                return merged;
            }
        });
    }

    protected Object performInsert(Object target, boolean shouldFlush) {
        throw new IllegalArgumentException("The [insert] argument is not supported by the [merge] method");
    }
}

