/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.graph.implementations;

import org.graphstream.graph.Edge;
import org.graphstream.graph.Node;
import org.graphstream.graph.implementations.AbstractElement;
import org.graphstream.graph.implementations.AbstractGraph;
import org.graphstream.graph.implementations.AbstractNode;
import org.graphstream.stream.SourceBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractEdge
extends AbstractElement
implements Edge {
    protected AbstractNode source;
    protected AbstractNode target;
    protected boolean directed;
    protected AbstractGraph graph;

    protected AbstractEdge(String id, AbstractNode source, AbstractNode target, boolean directed) {
        super(id);
        assert (source != null && target != null) : "An edge cannot have null endpoints";
        this.source = source;
        this.target = target;
        this.directed = directed;
        this.graph = (AbstractGraph)source.getGraph();
    }

    @Override
    protected void attributeChanged(String sourceId, long timeId, String attribute, AbstractElement.AttributeChangeEvent event, Object oldValue, Object newValue) {
        this.graph.listeners.sendAttributeChangedEvent(sourceId, timeId, this.id, SourceBase.ElementType.EDGE, attribute, event, oldValue, newValue);
    }

    @Override
    protected String myGraphId() {
        return this.graph.getId();
    }

    @Override
    protected long newEvent() {
        return this.graph.newEvent();
    }

    @Override
    protected boolean nullAttributesAreErrors() {
        return this.graph.nullAttributesAreErrors();
    }

    @Override
    public String toString() {
        return String.format("%s[%s-%s%s]", this.getId(), this.source, this.directed ? ">" : "-", this.target);
    }

    @Override
    public <T extends Node> T getNode0() {
        return (T)this.source;
    }

    @Override
    public <T extends Node> T getNode1() {
        return (T)this.target;
    }

    @Override
    public <T extends Node> T getOpposite(Node node) {
        if (node == this.source) {
            return (T)this.target;
        }
        if (node == this.target) {
            return (T)this.source;
        }
        return null;
    }

    @Override
    public <T extends Node> T getSourceNode() {
        return (T)this.source;
    }

    @Override
    public <T extends Node> T getTargetNode() {
        return (T)this.target;
    }

    @Override
    public boolean isDirected() {
        return this.directed;
    }

    @Override
    public boolean isLoop() {
        return this.source == this.target;
    }
}

