/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.graph.implementations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.graphstream.graph.CompoundAttribute;
import org.graphstream.graph.Element;
import org.graphstream.graph.NullAttributeException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractElement
implements Element {
    protected final String id;
    private int index;
    protected HashMap<String, Object> attributes = null;
    protected ArrayList<String> attributesBeingRemoved = null;

    public AbstractElement(String id) {
        assert (id != null) : "Graph elements cannot have a null identifier";
        this.id = id;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    protected void setIndex(int index) {
        this.index = index;
    }

    protected abstract String myGraphId();

    protected abstract long newEvent();

    protected abstract boolean nullAttributesAreErrors();

    @Override
    public <T> T getAttribute(String key) {
        Object value;
        if (this.attributes != null && (value = this.attributes.get(key)) != null) {
            return (T)value;
        }
        if (this.nullAttributesAreErrors()) {
            throw new NullAttributeException(key);
        }
        return null;
    }

    @Override
    public <T> T getFirstAttributeOf(String ... keys) {
        Object o = null;
        if (this.attributes != null) {
            for (String key : keys) {
                o = this.attributes.get(key);
                if (o == null) continue;
                return (T)o;
            }
        }
        if (o == null && this.nullAttributesAreErrors()) {
            throw new NullAttributeException();
        }
        return (T)o;
    }

    @Override
    public <T> T getAttribute(String key, Class<T> clazz) {
        Object o;
        if (this.attributes != null && (o = this.attributes.get(key)) != null && clazz.isInstance(o)) {
            return (T)o;
        }
        if (this.nullAttributesAreErrors()) {
            throw new NullAttributeException(key);
        }
        return null;
    }

    @Override
    public <T> T getFirstAttributeOf(Class<T> clazz, String ... keys) {
        Object o = null;
        if (this.attributes == null) {
            return null;
        }
        for (String key : keys) {
            o = this.attributes.get(key);
            if (o == null || !clazz.isInstance(o)) continue;
            return (T)o;
        }
        if (this.nullAttributesAreErrors()) {
            throw new NullAttributeException();
        }
        return null;
    }

    @Override
    public CharSequence getLabel(String key) {
        Object o;
        if (this.attributes != null && (o = this.attributes.get(key)) != null && o instanceof CharSequence) {
            return (CharSequence)o;
        }
        if (this.nullAttributesAreErrors()) {
            throw new NullAttributeException(key);
        }
        return null;
    }

    @Override
    public double getNumber(String key) {
        Object o;
        if (this.attributes != null && (o = this.attributes.get(key)) != null) {
            if (o instanceof Number) {
                return ((Number)o).doubleValue();
            }
            if (o instanceof String) {
                try {
                    return Double.parseDouble((String)o);
                }
                catch (NumberFormatException e) {
                }
            } else if (o instanceof CharSequence) {
                try {
                    return Double.parseDouble(((Object)((CharSequence)o)).toString());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        if (this.nullAttributesAreErrors()) {
            throw new NullAttributeException(key);
        }
        return Double.NaN;
    }

    @Override
    public ArrayList<? extends Number> getVector(String key) {
        Object o;
        if (this.attributes != null && (o = this.attributes.get(key)) != null && o instanceof ArrayList) {
            return (ArrayList)o;
        }
        if (this.nullAttributesAreErrors()) {
            throw new NullAttributeException(key);
        }
        return null;
    }

    @Override
    public Object[] getArray(String key) {
        Object o;
        if (this.attributes != null && (o = this.attributes.get(key)) != null && o instanceof Object[]) {
            return (Object[])o;
        }
        if (this.nullAttributesAreErrors()) {
            throw new NullAttributeException(key);
        }
        return null;
    }

    @Override
    public HashMap<?, ?> getHash(String key) {
        Object o;
        if (this.attributes != null && (o = this.attributes.get(key)) != null) {
            if (o instanceof HashMap) {
                return (HashMap)o;
            }
            if (o instanceof CompoundAttribute) {
                return ((CompoundAttribute)o).toHashMap();
            }
        }
        if (this.nullAttributesAreErrors()) {
            throw new NullAttributeException(key);
        }
        return null;
    }

    @Override
    public boolean hasAttribute(String key) {
        if (this.attributes != null) {
            return this.attributes.containsKey(key);
        }
        return false;
    }

    @Override
    public boolean hasAttribute(String key, Class<?> clazz) {
        Object o;
        if (this.attributes != null && (o = this.attributes.get(key)) != null) {
            return clazz.isInstance(o);
        }
        return false;
    }

    @Override
    public boolean hasLabel(String key) {
        Object o;
        if (this.attributes != null && (o = this.attributes.get(key)) != null) {
            return o instanceof CharSequence;
        }
        return false;
    }

    @Override
    public boolean hasNumber(String key) {
        Object o;
        if (this.attributes != null && (o = this.attributes.get(key)) != null) {
            return o instanceof Number;
        }
        return false;
    }

    @Override
    public boolean hasVector(String key) {
        Object o;
        return this.attributes != null && (o = this.attributes.get(key)) != null && o instanceof ArrayList;
    }

    @Override
    public boolean hasArray(String key) {
        Object o;
        return this.attributes != null && (o = this.attributes.get(key)) != null && o instanceof Object[];
    }

    @Override
    public boolean hasHash(String key) {
        Object o;
        return this.attributes != null && (o = this.attributes.get(key)) != null && (o instanceof HashMap || o instanceof CompoundAttribute);
    }

    @Override
    public Iterator<String> getAttributeKeyIterator() {
        if (this.attributes != null) {
            return this.attributes.keySet().iterator();
        }
        return null;
    }

    public Iterable<String> getEachAttributeKey() {
        if (this.attributes != null) {
            return this.attributes.keySet();
        }
        return Collections.emptySet();
    }

    public Collection<String> getAttributeKeySet() {
        if (this.attributes != null) {
            return Collections.unmodifiableCollection(this.attributes.keySet());
        }
        return Collections.emptySet();
    }

    public String toString() {
        return this.id;
    }

    @Override
    public int getAttributeCount() {
        if (this.attributes != null) {
            return this.attributes.size();
        }
        return 0;
    }

    @Override
    public void clearAttributes() {
        this.clearAttributes_(this.myGraphId(), this.newEvent());
    }

    protected void clearAttributes_(String sourceId, long timeId) {
        if (this.attributes != null) {
            Iterator<String> keys = this.attributes.keySet().iterator();
            Iterator<Object> vals = this.attributes.values().iterator();
            while (keys.hasNext() && vals.hasNext()) {
                String key = keys.next();
                Object val = vals.next();
                this.attributeChanged(sourceId, timeId, key, AttributeChangeEvent.REMOVE, val, null);
            }
            this.attributes.clear();
        }
    }

    @Override
    public void addAttribute(String attribute, Object ... values) {
        this.addAttribute_(this.myGraphId(), this.newEvent(), attribute, values);
    }

    protected void addAttribute_(String sourceId, long timeId, String attribute, Object ... values) {
        if (this.attributes == null) {
            this.attributes = new HashMap(1);
        }
        Object value = values.length == 0 ? Boolean.valueOf(true) : (values.length == 1 ? values[0] : values);
        AttributeChangeEvent event = AttributeChangeEvent.ADD;
        if (this.attributes.containsKey(attribute)) {
            event = AttributeChangeEvent.CHANGE;
        }
        Object oldValue = this.attributes.put(attribute, value);
        this.attributeChanged(sourceId, timeId, attribute, event, oldValue, value);
    }

    @Override
    public void changeAttribute(String attribute, Object ... values) {
        this.changeAttribute_(this.myGraphId(), this.newEvent(), attribute, values);
    }

    protected void changeAttribute_(String sourceId, long timeId, String attribute, Object ... values) {
        this.addAttribute_(sourceId, timeId, attribute, values);
    }

    @Override
    public void setAttribute(String attribute, Object ... values) {
        this.setAttribute_(this.myGraphId(), this.newEvent(), attribute, values);
    }

    protected void setAttribute_(String sourceId, long timeId, String attribute, Object ... values) {
        this.addAttribute_(sourceId, timeId, attribute, values);
    }

    @Override
    public void addAttributes(Map<String, Object> attributes) {
        this.addAttributes_(this.myGraphId(), this.newEvent(), attributes);
    }

    protected void addAttributes_(String sourceId, long timeId, Map<String, Object> attributes) {
        if (this.attributes == null) {
            this.attributes = new HashMap(1);
        }
        Iterator<String> i = attributes.keySet().iterator();
        Iterator<Object> j = attributes.values().iterator();
        while (i.hasNext() && j.hasNext()) {
            this.addAttribute_(sourceId, timeId, i.next(), j.next());
        }
    }

    @Override
    public void removeAttribute(String attribute) {
        this.removeAttribute_(this.myGraphId(), this.newEvent(), attribute);
    }

    protected void removeAttribute_(String sourceId, long timeId, String attribute) {
        if (this.attributes != null) {
            if (this.attributesBeingRemoved == null) {
                this.attributesBeingRemoved = new ArrayList();
            }
            if (this.attributes.containsKey(attribute) && !this.attributesBeingRemoved.contains(attribute)) {
                this.attributesBeingRemoved.add(attribute);
                this.attributeChanged(sourceId, timeId, attribute, AttributeChangeEvent.REMOVE, this.attributes.get(attribute), null);
                this.attributesBeingRemoved.remove(this.attributesBeingRemoved.size() - 1);
                this.attributes.remove(attribute);
            }
        }
    }

    protected abstract void attributeChanged(String var1, long var2, String var4, AttributeChangeEvent var5, Object var6, Object var7);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AttributeChangeEvent {
        ADD,
        CHANGE,
        REMOVE;

    }
}

