/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.stream;

import java.util.Iterator;
import java.util.TreeSet;
import org.graphstream.stream.Sink;
import org.graphstream.stream.SourceBase;

public class Timeline
extends SourceBase
implements Sink {
    public static final String TIME_PREFIX = "time";
    protected TreeSet<Event> events = new TreeSet();
    protected boolean changed = false;
    protected long currentDate = 0L;
    protected int currentEvent = 0;

    private void insert(Event e) {
        this.events.add(e);
    }

    public void reset() {
        this.currentEvent = 0;
        this.events.clear();
    }

    public boolean next() {
        return false;
    }

    public void play(long dateFrom, long dateTo) {
        long timeId;
        Iterator<Event> it;
        if (dateFrom < dateTo) {
            it = this.events.iterator();
        } else {
            timeId = dateTo;
            dateTo = dateFrom;
            dateFrom = timeId;
            it = this.events.descendingIterator();
        }
        timeId = 0L;
        while (it.hasNext()) {
            Event e = it.next();
            if (e.date < dateFrom || e.date > dateTo) continue;
            e.doEvent(timeId++);
        }
    }

    public void playAll() {
        this.play(this.events.first().date, this.events.last().date);
    }

    public void addNodeAt(long date, String nodeId) {
        this.insert(new NodeAdded(date, nodeId));
    }

    public void removeNodeAt(long date, String nodeId) {
        this.insert(new NodeRemoved(date, nodeId));
    }

    public void addEdgeAt(long date, String edgeId, String source, String target, boolean directed) {
        this.insert(new EdgeAdded(date, edgeId, source, target, directed));
    }

    public void removeEdgeAt(long date, String edgeId) {
        this.insert(new EdgeRemoved(date, edgeId));
    }

    public void addNodeAttributeAt(long date, String nodeId, String attributeId, Object value) {
        this.insert(new AttributeAdded(date, ElementType.NODE, nodeId, attributeId, value));
    }

    public void addEdgeAttributeAt(long date, String edgeId, String attributeId, Object value) {
        this.insert(new AttributeAdded(date, ElementType.EDGE, edgeId, attributeId, value));
    }

    public void addGraphAttributeAt(long date, String attributeId, Object value) {
        this.insert(new AttributeAdded(date, ElementType.GRAPH, null, attributeId, value));
    }

    public void changeNodeAttributeAt(long date, String nodeId, String attributeId, Object oldValue, Object newValue) {
        this.insert(new AttributeChanged(date, ElementType.NODE, nodeId, attributeId, oldValue, newValue));
    }

    public void changeEdgeAttributeAt(long date, String edgeId, String attributeId, Object oldValue, Object newValue) {
        this.insert(new AttributeChanged(date, ElementType.EDGE, edgeId, attributeId, oldValue, newValue));
    }

    public void changeGraphAttributeAt(long date, String attributeId, Object oldValue, Object newValue) {
        this.insert(new AttributeChanged(date, ElementType.GRAPH, null, attributeId, oldValue, newValue));
    }

    public void removeNodeAttributeAt(long date, String nodeId, String attributeId) {
        this.insert(new AttributeRemoved(date, ElementType.NODE, nodeId, attributeId));
    }

    public void removeEdgeAttributeAt(long date, String edgeId, String attributeId) {
        this.insert(new AttributeRemoved(date, ElementType.EDGE, edgeId, attributeId));
    }

    public void removeGraphAttributeAt(long date, String attributeId) {
        this.insert(new AttributeRemoved(date, ElementType.GRAPH, null, attributeId));
    }

    public void stepBeginsAt(long date, double step) {
        this.insert(new StepBegins(date, step));
    }

    public void clearGraphAt(long date) {
        this.insert(new GraphCleared(date));
    }

    protected void handleTimeAttribute(boolean delete, String key, Object value) {
        TimeAction action = TimeAction.valueOf(key.substring(TIME_PREFIX.length() + 1).toUpperCase());
        switch (action) {
            default: 
        }
    }

    public void edgeAttributeAdded(String sourceId, long timeId, String edgeId, String attribute, Object value) {
        this.addEdgeAttributeAt(this.currentDate, edgeId, attribute, value);
    }

    public void edgeAttributeChanged(String sourceId, long timeId, String edgeId, String attribute, Object oldValue, Object newValue) {
        this.changeEdgeAttributeAt(this.currentDate, edgeId, attribute, oldValue, newValue);
    }

    public void edgeAttributeRemoved(String sourceId, long timeId, String edgeId, String attribute) {
        this.removeEdgeAttributeAt(this.currentDate, edgeId, attribute);
    }

    public void graphAttributeAdded(String sourceId, long timeId, String attribute, Object value) {
        if (attribute.startsWith("time.")) {
            this.handleTimeAttribute(false, attribute, value);
        }
        this.addGraphAttributeAt(this.currentDate, attribute, value);
    }

    public void graphAttributeChanged(String sourceId, long timeId, String attribute, Object oldValue, Object newValue) {
        if (attribute.startsWith("time.")) {
            this.handleTimeAttribute(false, attribute, newValue);
        }
        this.changeGraphAttributeAt(this.currentDate, attribute, oldValue, newValue);
    }

    public void graphAttributeRemoved(String sourceId, long timeId, String attribute) {
        if (attribute.startsWith("time.")) {
            this.handleTimeAttribute(true, attribute, null);
        }
        this.removeGraphAttributeAt(this.currentDate, attribute);
    }

    public void nodeAttributeAdded(String sourceId, long timeId, String nodeId, String attribute, Object value) {
        this.addNodeAttributeAt(this.currentDate, nodeId, attribute, value);
    }

    public void nodeAttributeChanged(String sourceId, long timeId, String nodeId, String attribute, Object oldValue, Object newValue) {
        this.changeNodeAttributeAt(this.currentDate, nodeId, attribute, oldValue, newValue);
    }

    public void nodeAttributeRemoved(String sourceId, long timeId, String nodeId, String attribute) {
        this.removeNodeAttributeAt(this.currentDate, nodeId, attribute);
    }

    public void edgeAdded(String sourceId, long timeId, String edgeId, String fromNodeId, String toNodeId, boolean directed) {
        this.addEdgeAt(this.currentDate, edgeId, fromNodeId, toNodeId, directed);
    }

    public void edgeRemoved(String sourceId, long timeId, String edgeId) {
        this.removeEdgeAt(this.currentDate, edgeId);
    }

    public void graphCleared(String sourceId, long timeId) {
        this.clearGraphAt(this.currentDate);
    }

    public void nodeAdded(String sourceId, long timeId, String nodeId) {
        this.addNodeAt(this.currentDate, nodeId);
    }

    public void nodeRemoved(String sourceId, long timeId, String nodeId) {
        this.removeNodeAt(this.currentDate, nodeId);
    }

    public void stepBegins(String sourceId, long timeId, double step) {
        this.stepBeginsAt(this.currentDate, step);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum TimeAction {
        FORMAT,
        SET;

    }

    protected class GraphCleared
    extends Event {
        public GraphCleared(long date) {
            super(date, 0);
        }

        public void doEvent(long timeId) {
            Timeline.this.sendGraphCleared(Timeline.this.sourceId, timeId);
        }

        public void reverse(long timeId) {
        }
    }

    protected class StepBegins
    extends Event {
        double step;

        public StepBegins(long date, double step) {
            super(date, 0);
            this.step = step;
        }

        public void doEvent(long timeId) {
            Timeline.this.sendStepBegins(Timeline.this.sourceId, timeId, this.step);
        }

        public void reverse(long timeId) {
        }
    }

    protected class EdgeRemoved
    extends Event {
        String edgeId;

        public EdgeRemoved(long date, String edgeId) {
            super(date, 5);
            this.edgeId = edgeId;
        }

        public void doEvent(long timeId) {
            Timeline.this.sendEdgeRemoved(Timeline.this.sourceId, timeId, this.edgeId);
        }

        public void reverse(long timeId) {
        }
    }

    protected class EdgeAdded
    extends Event {
        String edgeId;
        String source;
        String target;
        boolean directed;

        public EdgeAdded(long date, String edgeId, String source, String target, boolean directed) {
            super(date, 9);
            this.edgeId = edgeId;
            this.source = source;
            this.target = target;
            this.directed = directed;
        }

        public void doEvent(long timeId) {
            Timeline.this.sendEdgeAdded(Timeline.this.sourceId, timeId, this.edgeId, this.source, this.target, this.directed);
        }

        public void reverse(long timeId) {
            Timeline.this.sendEdgeRemoved(Timeline.this.sourceId, timeId, this.edgeId);
        }
    }

    protected class AttributeRemoved
    extends Event {
        ElementType type;
        String elementId;
        String attrId;

        public AttributeRemoved(long date, ElementType type, String elementId, String attrId) {
            super(date, 6);
            this.type = type;
            this.elementId = elementId;
        }

        public void doEvent(long timeId) {
            switch (this.type) {
                case NODE: {
                    Timeline.this.sendNodeAttributeRemoved(Timeline.this.sourceId, timeId, this.elementId, this.attrId);
                    break;
                }
                case EDGE: {
                    Timeline.this.sendEdgeAttributeRemoved(Timeline.this.sourceId, timeId, this.elementId, this.attrId);
                    break;
                }
                case GRAPH: {
                    Timeline.this.sendGraphAttributeRemoved(Timeline.this.sourceId, timeId, this.attrId);
                }
            }
        }

        public void reverse(long timeId) {
        }
    }

    protected class AttributeChanged
    extends Event {
        ElementType type;
        String elementId;
        String attrId;
        Object newValue;
        Object oldValue;

        public AttributeChanged(long date, ElementType type, String elementId, String attrId, Object newValue, Object oldValue) {
            super(date, 7);
            this.type = type;
            this.elementId = elementId;
            this.attrId = attrId;
            this.newValue = newValue;
            this.oldValue = oldValue;
        }

        public void doEvent(long timeId) {
            switch (this.type) {
                case NODE: {
                    Timeline.this.sendNodeAttributeChanged(Timeline.this.sourceId, timeId, this.elementId, this.attrId, this.oldValue, this.newValue);
                }
                case EDGE: {
                    Timeline.this.sendEdgeAttributeChanged(Timeline.this.sourceId, timeId, this.elementId, this.attrId, this.oldValue, this.newValue);
                    break;
                }
                case GRAPH: {
                    Timeline.this.sendGraphAttributeChanged(Timeline.this.sourceId, timeId, this.attrId, this.oldValue, this.newValue);
                }
            }
        }

        public void reverse(long timeId) {
        }
    }

    protected class AttributeAdded
    extends Event {
        ElementType type;
        String elementId;
        String attrId;
        Object value;

        public AttributeAdded(long timeId, ElementType type, String elementId, String attrId, Object value) {
            super(timeId, 8);
            this.type = type;
            this.elementId = elementId;
            this.value = value;
        }

        public void doEvent(long timeId) {
            switch (this.type) {
                case NODE: {
                    Timeline.this.sendNodeAttributeAdded(Timeline.this.sourceId, timeId, this.elementId, this.attrId, this.value);
                    break;
                }
                case EDGE: {
                    Timeline.this.sendEdgeAttributeAdded(Timeline.this.sourceId, timeId, this.elementId, this.attrId, this.value);
                    break;
                }
                case GRAPH: {
                    Timeline.this.sendGraphAttributeAdded(Timeline.this.sourceId, timeId, this.attrId, this.value);
                }
            }
        }

        public void reverse(long timeId) {
        }
    }

    protected class NodeRemoved
    extends Event {
        String nodeId;

        public NodeRemoved(long timeId, String nodeId) {
            super(timeId, 4);
            this.nodeId = nodeId;
        }

        public void doEvent(long timeId) {
            Timeline.this.sendNodeRemoved(Timeline.this.sourceId, timeId, this.nodeId);
        }

        public void reverse(long timeId) {
            Timeline.this.sendNodeAdded(Timeline.this.sourceId, timeId, this.nodeId);
        }
    }

    protected class NodeAdded
    extends Event {
        String nodeId;

        public NodeAdded(long timeId, String nodeId) {
            super(timeId, 10);
            this.nodeId = nodeId;
        }

        public void doEvent(long timeId) {
            Timeline.this.sendNodeAdded(Timeline.this.sourceId, timeId, this.nodeId);
        }

        public void reverse(long timeId) {
            Timeline.this.sendNodeRemoved(Timeline.this.sourceId, timeId, this.nodeId);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected abstract class Event
    implements Comparable<Event> {
        long date;
        int priority;

        protected Event(long date, int priority) {
            this.date = date;
        }

        abstract void doEvent(long var1);

        abstract void reverse(long var1);

        @Override
        public int compareTo(Event e) {
            if (this.date == e.date) {
                return this.priority - e.priority;
            }
            return (int)(this.date - e.date);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum ElementType {
        NODE,
        EDGE,
        GRAPH;

    }
}

