/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.stream.file;

import java.io.IOException;
import java.io.PrintWriter;
import org.graphstream.stream.file.FileSinkBase;

public class FileSinkDOT
extends FileSinkBase {
    protected PrintWriter out;
    protected String graphName = "";
    protected boolean digraph;

    public FileSinkDOT() {
        this(false);
    }

    public FileSinkDOT(boolean digraph) {
        this.digraph = digraph;
    }

    public void setDirected(boolean digraph) {
        this.digraph = digraph;
    }

    public boolean isDirected() {
        return this.digraph;
    }

    protected void outputHeader() throws IOException {
        this.out = (PrintWriter)this.output;
        this.out.printf("%s {%n", this.digraph ? "digraph" : "graph");
        if (this.graphName.length() > 0) {
            this.out.printf("\tgraph [label=%s];%n", this.graphName);
        }
    }

    protected void outputEndOfFile() throws IOException {
        this.out.printf("}%n", new Object[0]);
    }

    public void edgeAttributeAdded(String graphId, long timeId, String edgeId, String attribute, Object value) {
    }

    public void edgeAttributeChanged(String graphId, long timeId, String edgeId, String attribute, Object oldValue, Object newValue) {
    }

    public void edgeAttributeRemoved(String graphId, long timeId, String edgeId, String attribute) {
    }

    public void graphAttributeAdded(String graphId, long timeId, String attribute, Object value) {
        this.out.printf("\tgraph [ %s ];%n", this.outputAttribute(attribute, value, true));
    }

    public void graphAttributeChanged(String graphId, long timeId, String attribute, Object oldValue, Object newValue) {
        this.out.printf("\tgraph [ %s ];%n", this.outputAttribute(attribute, newValue, true));
    }

    public void graphAttributeRemoved(String graphId, long timeId, String attribute) {
    }

    public void nodeAttributeAdded(String graphId, long timeId, String nodeId, String attribute, Object value) {
        this.out.printf("\t\"%s\" [ %s ];%n", nodeId, this.outputAttribute(attribute, value, true));
    }

    public void nodeAttributeChanged(String graphId, long timeId, String nodeId, String attribute, Object oldValue, Object newValue) {
        this.out.printf("\t\"%s\" [ %s ];%n", nodeId, this.outputAttribute(attribute, newValue, true));
    }

    public void nodeAttributeRemoved(String graphId, long timeId, String nodeId, String attribute) {
    }

    public void edgeAdded(String graphId, long timeId, String edgeId, String fromNodeId, String toNodeId, boolean directed) {
        if (this.digraph) {
            this.out.printf("\t\"%s\" -> \"%s\"", fromNodeId, toNodeId);
            if (!directed) {
                this.out.printf(" -> \"%s\"", fromNodeId);
            }
            this.out.printf("\n;", new Object[0]);
        } else {
            this.out.printf("\t\"%s\" -- \"%s\";%n", fromNodeId, toNodeId);
        }
    }

    public void edgeRemoved(String graphId, long timeId, String edgeId) {
    }

    public void graphCleared(String graphId, long timeId) {
    }

    public void nodeAdded(String graphId, long timeId, String nodeId) {
        this.out.printf("\t\"%s\";%n", nodeId);
    }

    public void nodeRemoved(String graphId, long timeId, String nodeId) {
    }

    public void stepBegins(String graphId, long timeId, double step) {
    }

    protected String outputAttribute(String key, Object value, boolean first) {
        boolean quote = true;
        if (value instanceof Number) {
            quote = false;
        }
        return String.format("%s\"%s\"=%s%s%s", first ? "" : ",", key, quote ? "\"" : "", value, quote ? "\"" : "");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum What {
        NODE,
        EDGE,
        OTHER;

    }
}

