/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.stream.file;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.zip.GZIPInputStream;
import org.graphstream.stream.file.FileSourceParser;
import org.graphstream.stream.file.dgs.DGSParser;
import org.graphstream.util.parser.ParseException;
import org.graphstream.util.parser.Parser;
import org.graphstream.util.parser.ParserFactory;

public class FileSourceDGS
extends FileSourceParser {
    public ParserFactory getNewParserFactory() {
        return new ParserFactory(){

            public Parser newParser(Reader reader) {
                return new DGSParser(FileSourceDGS.this, reader);
            }
        };
    }

    public boolean nextStep() throws IOException {
        try {
            return ((DGSParser)this.parser).nextStep();
        }
        catch (ParseException e) {
            throw new IOException(e);
        }
    }

    protected Reader createReaderForFile(String filename) throws IOException {
        InputStream is = null;
        is = new FileInputStream(filename);
        if (is.markSupported()) {
            is.mark(128);
        }
        try {
            is = new GZIPInputStream(is);
        }
        catch (IOException e1) {
            if (is.markSupported()) {
                try {
                    is.reset();
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            }
            try {
                is.close();
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
            is = new FileInputStream(filename);
        }
        return new BufferedReader(new InputStreamReader(is));
    }
}

