/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.stream.file;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.util.HashSet;
import org.graphstream.stream.file.FileSourceBase;

public class FileSourceEdge
extends FileSourceBase {
    protected int edgeid = 0;
    protected boolean directed = false;
    protected HashSet<String> nodes;
    protected String graphName = "EDGE_";

    public FileSourceEdge() {
        this(false);
    }

    public FileSourceEdge(boolean edgesAreDirected) {
        this(edgesAreDirected, true);
    }

    public FileSourceEdge(boolean edgesAreDirected, boolean declareNodes) {
        this.directed = edgesAreDirected;
        this.nodes = declareNodes ? new HashSet() : null;
    }

    protected void continueParsingInInclude() throws IOException {
    }

    public boolean nextEvents() throws IOException {
        String id1 = this.getWordOrNumberOrStringOrEolOrEof();
        if (!id1.equals("EOL")) {
            if (id1.equals("EOF")) {
                return false;
            }
            this.declareNode(id1);
            String id2 = this.getWordOrNumberOrStringOrEolOrEof();
            while (!id2.equals("EOL")) {
                if (!id1.equals(id2)) {
                    String edgeId = Integer.toString(this.edgeid++);
                    this.declareNode(id2);
                    this.sendEdgeAdded(this.graphName, edgeId, id1, id2, this.directed);
                }
                id2 = this.getWordOrNumberOrStringOrEolOrEof();
            }
        }
        return true;
    }

    protected void declareNode(String id) {
        if (this.nodes != null && !this.nodes.contains(id)) {
            this.sendNodeAdded(this.graphName, id);
            this.nodes.add(id);
        }
    }

    public void begin(String filename) throws IOException {
        super.begin(filename);
        this.init();
    }

    public void begin(URL url) throws IOException {
        super.begin(url);
        this.init();
    }

    public void begin(InputStream stream) throws IOException {
        super.begin(stream);
        this.init();
    }

    public void begin(Reader reader) throws IOException {
        super.begin(reader);
        this.init();
    }

    protected void init() throws IOException {
        this.st.eolIsSignificant(true);
        this.st.commentChar(35);
        this.graphName = String.format("%s_%d", this.graphName, System.currentTimeMillis() + (long)Math.random() * 10L);
    }

    public boolean nextStep() throws IOException {
        return this.nextEvents();
    }

    public void end() throws IOException {
        super.end();
    }
}

