/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.ui.graphicGraph.stylesheet;

import org.graphstream.ui.graphicGraph.stylesheet.StyleConstants;

public class Value
extends Number {
    private static final long serialVersionUID = 1L;
    public double value;
    public StyleConstants.Units units;

    public Value(StyleConstants.Units units, double value) {
        this.value = value;
        this.units = units;
    }

    public Value(Value other) {
        this.value = other.value;
        this.units = other.units;
    }

    public float floatValue() {
        return (float)this.value;
    }

    public double doubleValue() {
        return this.value;
    }

    public int intValue() {
        return (int)Math.round(this.value);
    }

    public long longValue() {
        return Math.round(this.value);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.value);
        switch (this.units) {
            case GU: {
                builder.append("gu");
                break;
            }
            case PX: {
                builder.append("px");
                break;
            }
            case PERCENTS: {
                builder.append("%");
                break;
            }
            default: {
                builder.append("wtf (what's the fuck?)");
            }
        }
        return builder.toString();
    }

    public boolean equals(Value o) {
        if (o != this) {
            if (!(o instanceof Value)) {
                return false;
            }
            Value other = o;
            if (other.units != this.units) {
                return false;
            }
            if (other.value != this.value) {
                return false;
            }
        }
        return true;
    }
}

