/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.util;

import java.util.Collection;
import org.graphstream.graph.Edge;
import org.graphstream.graph.Element;
import org.graphstream.graph.Node;
import org.graphstream.util.Filter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Filters {
    public static <T extends Element> Filter<T> falseFilter() {
        return new Filter<T>(){

            @Override
            public boolean isAvailable(T e) {
                return false;
            }
        };
    }

    public static <T extends Element> Filter<T> trueFilter() {
        return new Filter<T>(){

            @Override
            public boolean isAvailable(T e) {
                return true;
            }
        };
    }

    public static <T extends Element> Filter<T> byAttributeFilter(String key, Object expectedValue) {
        return new ByAttributeFilter(key, expectedValue);
    }

    public static <T extends Element, U extends Element> Filter<Element> separateNodeAndEdgeFilter(Filter<T> nodeFilter, Filter<U> edgeFilter) {
        return new SeparateNodeEdgeFilter<T, U>(nodeFilter, edgeFilter);
    }

    public static <T extends Element, U extends Element> Filter<T> byExtremitiesFilter(Filter<U> f) {
        return new ExtremitiesFilter(f);
    }

    public static <T extends Element> Filter<T> byIdFilter(String idPattern) {
        return new ByIdFilter(idPattern);
    }

    public static <T extends Element> Filter<T> isContained(final Collection<? extends T> set) {
        return new Filter<T>(){

            @Override
            public boolean isAvailable(T e) {
                return set.contains(e);
            }
        };
    }

    public static <T extends Element> Filter<T> isIdContained(final Collection<String> set) {
        return new Filter<T>(){

            @Override
            public boolean isAvailable(T e) {
                return set.contains(e.getId());
            }
        };
    }

    public static <T extends Element> Filter<T> and(Filter<T> f1, Filter<T> f2) {
        return new AndFilter<T>(f1, f2);
    }

    public static <T extends Element> Filter<T> or(Filter<T> f1, Filter<T> f2) {
        return new OrFilter<T>(f1, f2);
    }

    public static <T extends Element> Filter<T> xor(Filter<T> f1, Filter<T> f2) {
        return new XorFilter<T>(f1, f2);
    }

    public static <T extends Element> Filter<T> not(Filter<T> f) {
        return new NotFilter<T>(f);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class NotFilter<T extends Element>
    implements Filter<T> {
        Filter<T> f;

        NotFilter(Filter<T> f) {
            this.f = f;
        }

        @Override
        public boolean isAvailable(T e) {
            return !this.f.isAvailable(e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class XorFilter<T extends Element>
    implements Filter<T> {
        Filter<T> f1;
        Filter<T> f2;

        XorFilter(Filter<T> f1, Filter<T> f2) {
            this.f1 = f1;
            this.f2 = f2;
        }

        @Override
        public boolean isAvailable(T e) {
            return this.f1.isAvailable(e) ^ this.f2.isAvailable(e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class OrFilter<T extends Element>
    implements Filter<T> {
        Filter<T> f1;
        Filter<T> f2;

        OrFilter(Filter<T> f1, Filter<T> f2) {
            this.f1 = f1;
            this.f2 = f2;
        }

        @Override
        public boolean isAvailable(T e) {
            return this.f1.isAvailable(e) || this.f2.isAvailable(e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class AndFilter<T extends Element>
    implements Filter<T> {
        Filter<T> f1;
        Filter<T> f2;

        AndFilter(Filter<T> f1, Filter<T> f2) {
            this.f1 = f1;
            this.f2 = f2;
        }

        @Override
        public boolean isAvailable(T e) {
            return this.f1.isAvailable(e) && this.f2.isAvailable(e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ExtremitiesFilter<T extends Element, U extends Element>
    implements Filter<T> {
        Filter<U> f;

        ExtremitiesFilter(Filter<U> f) {
            this.f = f;
        }

        @Override
        public boolean isAvailable(T e) {
            if (e instanceof Node) {
                return true;
            }
            return this.f.isAvailable(((Edge)e).getNode0()) && this.f.isAvailable(((Edge)e).getNode1());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SeparateNodeEdgeFilter<T extends Element, U extends Element>
    implements Filter<Element> {
        Filter<T> nodeFilter;
        Filter<U> edgeFilter;

        SeparateNodeEdgeFilter(Filter<T> nodeFilter, Filter<U> edgeFilter) {
            this.nodeFilter = nodeFilter;
            this.edgeFilter = edgeFilter;
        }

        @Override
        public boolean isAvailable(Element e) {
            if (e instanceof Edge) {
                return this.edgeFilter.isAvailable(e);
            }
            return this.nodeFilter.isAvailable(e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ByIdFilter<T extends Element>
    implements Filter<T> {
        String nodePattern;
        String edgePattern;

        ByIdFilter(String pattern) {
            this(pattern, pattern);
        }

        ByIdFilter(String nodePattern, String edgePattern) {
            this.nodePattern = nodePattern;
            this.edgePattern = edgePattern;
        }

        @Override
        public boolean isAvailable(Element e) {
            if (e instanceof Edge) {
                return e.getId().matches(this.edgePattern);
            }
            return e.getId().matches(this.nodePattern);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ByAttributeFilter<T extends Element>
    implements Filter<T> {
        protected String key;
        protected Object value;

        ByAttributeFilter(String key, Object value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public boolean isAvailable(T e) {
            return e.hasAttribute(this.key) && (this.value == null ? e.getAttribute(this.key) == null : this.value.equals(e.getAttribute(this.key)));
        }
    }
}

