/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.ui.j2dviewer.renderer;

import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import org.graphstream.ui.geom.Point3;
import org.graphstream.ui.graphicGraph.GraphicElement;
import org.graphstream.ui.graphicGraph.GraphicNode;
import org.graphstream.ui.graphicGraph.GraphicSprite;
import org.graphstream.ui.graphicGraph.StyleGroup;
import org.graphstream.ui.graphicGraph.stylesheet.Style;
import org.graphstream.ui.graphicGraph.stylesheet.StyleConstants;
import org.graphstream.ui.graphicGraph.stylesheet.Values;
import org.graphstream.ui.j2dviewer.Backend;
import org.graphstream.ui.j2dviewer.Camera;
import org.graphstream.ui.j2dviewer.J2DGraphRenderer;
import org.graphstream.ui.j2dviewer.renderer.StyleRenderer;
import org.graphstream.ui.j2dviewer.renderer.shape.swing.SquareShape;
import org.graphstream.ui.swingViewer.util.GraphMetrics;
import org.graphstream.ui.util.swing.FontCache$;
import org.graphstream.ui.util.swing.ImageCache$;
import scala.Option;
import scala.collection.mutable.HashMap;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\teh\u0001B\u0001\u0003\u00015\u0011!CS\"p[B|g.\u001a8u%\u0016tG-\u001a:fe*\u00111\u0001B\u0001\te\u0016tG-\u001a:fe*\u0011QAB\u0001\nUJ\"g/[3xKJT!a\u0002\u0005\u0002\u0005UL'BA\u0005\u000b\u0003-9'/\u00199igR\u0014X-Y7\u000b\u0003-\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\b\u0011\u0005=\u0001R\"\u0001\u0002\n\u0005E\u0011!!D*us2,'+\u001a8eKJ,'\u000fC\u0005\u0014\u0001\t\u0005\t\u0015!\u0003\u00155\u0005Q1\u000f^=mK\u001e\u0013x.\u001e9\u0011\u0005UAR\"\u0001\f\u000b\u0005]1\u0011\u0001D4sCBD\u0017nY$sCBD\u0017BA\r\u0017\u0005)\u0019F/\u001f7f\u000fJ|W\u000f]\u0005\u00037A\tQa\u001a:pkBD\u0001\"\b\u0001\u0003\u0006\u0004%\tAH\u0001\r[\u0006LgNU3oI\u0016\u0014XM]\u000b\u0002?A\u0011\u0001%I\u0007\u0002\t%\u0011!\u0005\u0002\u0002\u0011\u0015J\"uI]1qQJ+g\u000eZ3sKJD\u0001\u0002\n\u0001\u0003\u0002\u0003\u0006IaH\u0001\u000e[\u0006LgNU3oI\u0016\u0014XM\u001d\u0011\t\u000b\u0019\u0002A\u0011A\u0014\u0002\rqJg.\u001b;?)\rA\u0013F\u000b\t\u0003\u001f\u0001AQaE\u0013A\u0002QAQ!H\u0013A\u0002}Aq\u0001\f\u0001A\u0002\u0013EQ&\u0001\u0003tSj,W#\u0001\u0018\u0011\u0005=\u0012T\"\u0001\u0019\u000b\u0005E2\u0012AC:us2,7\u000f[3fi&\u00111\u0007\r\u0002\u0007-\u0006dW/Z:\t\u000fU\u0002\u0001\u0019!C\tm\u0005A1/\u001b>f?\u0012*\u0017\u000f\u0006\u00028{A\u0011\u0001hO\u0007\u0002s)\t!(A\u0003tG\u0006d\u0017-\u0003\u0002=s\t!QK\\5u\u0011\u001dqD'!AA\u00029\n1\u0001\u001f\u00132\u0011\u0019\u0001\u0005\u0001)Q\u0005]\u0005)1/\u001b>fA!9!\t\u0001a\u0001\n#\u0019\u0015!B<jIRDW#\u0001#\u0011\u0005a*\u0015B\u0001$:\u0005\rIe\u000e\u001e\u0005\b\u0011\u0002\u0001\r\u0011\"\u0005J\u0003%9\u0018\u000e\u001a;i?\u0012*\u0017\u000f\u0006\u00028\u0015\"9ahRA\u0001\u0002\u0004!\u0005B\u0002'\u0001A\u0003&A)\u0001\u0004xS\u0012$\b\u000e\t\u0005\b\u001d\u0002\u0001\r\u0011\"\u0005D\u0003\u0019AW-[4ii\"9\u0001\u000b\u0001a\u0001\n#\t\u0016A\u00035fS\u001eDGo\u0018\u0013fcR\u0011qG\u0015\u0005\b}=\u000b\t\u00111\u0001E\u0011\u0019!\u0006\u0001)Q\u0005\t\u00069\u0001.Z5hQR\u0004\u0003b\u0002,\u0001\u0005\u0004%\tbV\u0001\u000eG>l\u0007\u000fV8FY\u0016lWM\u001c;\u0016\u0003a\u0003B!\u00170aQ6\t!L\u0003\u0002\\9\u00069Q.\u001e;bE2,'BA/:\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003?j\u0013q\u0001S1tQ6\u000b\u0007\u000f\u0005\u0002bM6\t!M\u0003\u0002dI\u0006)1o^5oO*\tQ-A\u0003kCZ\f\u00070\u0003\u0002hE\nQ!jQ8na>tWM\u001c;\u0011\u0005%TW\"\u0001\u0001\u0007\u000b-\u0004\u0011\u0011\u00017\u0003!\r{W\u000e]8oK:$X\t\\3nK:$8C\u00016n!\t\tg.\u0003\u0002pE\n1!\nU1oK2D\u0001\"\u001d6\u0003\u0006\u0004%\tA]\u0001\bK2,W.\u001a8u+\u0005\u0019\bCA\u000bu\u0013\t)hC\u0001\bHe\u0006\u0004\b.[2FY\u0016lWM\u001c;\t\u0011]T'\u0011!Q\u0001\nM\f\u0001\"\u001a7f[\u0016tG\u000f\t\u0005\u0006M)$\t!\u001f\u000b\u0003QjDQ!\u001d=A\u0002MDq\u0001 6A\u0002\u0013\u0005Q0\u0001\u0003j]&$X#\u0001@\u0011\u0005az\u0018bAA\u0001s\t9!i\\8mK\u0006t\u0007\"CA\u0003U\u0002\u0007I\u0011AA\u0004\u0003!Ig.\u001b;`I\u0015\fHcA\u001c\u0002\n!Aa(a\u0001\u0002\u0002\u0003\u0007a\u0010C\u0004\u0002\u000e)\u0004\u000b\u0015\u0002@\u0002\u000b%t\u0017\u000e\u001e\u0011\t\u000f\u0005E!N\"\u0001\u0002\u0014\u0005Q!nQ8na>tWM\u001c;\u0016\u0003\u0001Dq!a\u0006k\t\u0003\tI\"A\u0004tKR4\u0015\u000e\u001c7\u0015\u0003]Bq!!\bk\r\u0003\tI\"\u0001\ttKR$V\r\u001f;BY&<g.\\3oi\"9\u0011\u0011\u00056\u0007\u0002\u0005e\u0011aC:fiR+\u0007\u0010\u001e$p]RDq!!\nk\r\u0003\tI\"A\u0006va\u0012\fG/\u001a'bE\u0016d\u0007bBA\u0015U\u0012\u0005\u00111F\u0001\ng\u0016$(i\\;oIN$2bNA\u0017\u0003c\t)$a\u000e\u0002:!9\u0011qFA\u0014\u0001\u0004!\u0015!\u0001=\t\u000f\u0005M\u0012q\u0005a\u0001\t\u0006\t\u0011\u0010\u0003\u0004C\u0003O\u0001\r\u0001\u0012\u0005\u0007\u001d\u0006\u001d\u0002\u0019\u0001#\t\u0011\u0005m\u0012q\u0005a\u0001\u0003{\taaY1nKJ\f\u0007c\u0001\u0011\u0002@%\u0019\u0011\u0011\t\u0003\u0003\r\r\u000bW.\u001a:b\u0011\u001d\t)E\u001bC\u0001\u0003\u000f\na\u0001Z3uC\u000eDW#A\u001c\t\u000f\u0005-#\u000e\"\u0001\u0002N\u0005qQ\u000f\u001d3bi\u0016\u0004vn]5uS>tGcA\u001c\u0002P!A\u00111HA%\u0001\u0004\ti\u0004C\u0004\u0002T)$\t%!\u0016\u0002\u000bA\f\u0017N\u001c;\u0015\u0007]\n9\u0006\u0003\u0005\u0002Z\u0005E\u0003\u0019AA.\u0003\u00059\u0007\u0003BA/\u0003Oj!!a\u0018\u000b\t\u0005\u0005\u00141M\u0001\u0004C^$(BAA3\u0003\u0011Q\u0017M^1\n\t\u0005%\u0014q\f\u0002\t\u000fJ\f\u0007\u000f[5dg\"9\u0011Q\u000e6\u0005\u0012\u0005=\u0014!\u00069pg&$\u0018n\u001c8O_\u0012,7i\\7q_:,g\u000e\u001e\u000b\u0006o\u0005E\u00141\u0010\u0005\t\u0003g\nY\u00071\u0001\u0002v\u0005!an\u001c3f!\r)\u0012qO\u0005\u0004\u0003s2\"aC$sCBD\u0017n\u0019(pI\u0016D\u0001\"a\u000f\u0002l\u0001\u0007\u0011Q\b\u0005\b\u0003\u007fRG\u0011CAA\u0003]\u0001xn]5uS>t7\u000b\u001d:ji\u0016\u001cu.\u001c9p]\u0016tG\u000fF\u00038\u0003\u0007\u000bi\t\u0003\u0005\u0002\u0006\u0006u\u0004\u0019AAD\u0003\u0019\u0019\bO]5uKB\u0019Q#!#\n\u0007\u0005-eCA\u0007He\u0006\u0004\b.[2TaJLG/\u001a\u0005\t\u0003w\ti\b1\u0001\u0002>!9\u0011\u0011\u00136\u0005\u0002\u0005M\u0015aC2iK\u000e\\'i\u001c:eKJ$RaNAK\u0003/C\u0001\"a\u000f\u0002\u0010\u0002\u0007\u0011Q\b\u0005\b\u00033\u000by\t1\u0001\u007f\u0003\u00151wN]2f\u0011\u001d\tiJ\u001bC\t\u0003?\u000bAb\u0019:fCR,'i\u001c:eKJ$B!!)\u0002.B!\u00111UAU\u001b\t\t)KC\u0002\u0002(\n\faAY8sI\u0016\u0014\u0018\u0002BAV\u0003K\u0013aAQ8sI\u0016\u0014\b\u0002CA\u001e\u00037\u0003\r!!\u0010\t\u000f\u0005E&\u000e\"\u0005\u00024\u0006aQ\u000f\u001d3bi\u0016\u0014uN\u001d3feR\u0019q'!.\t\u0011\u0005m\u0012q\u0016a\u0001\u0003{Aq!!/k\r\u0003\tY,A\u0005dQ\u0016\u001c7.S2p]R\u0019q'!0\t\u0011\u0005m\u0012q\u0017a\u0001\u0003{Aq!!1\u0001A\u0003%\u0001,\u0001\bd_6\u0004Hk\\#mK6,g\u000e\u001e\u0011\t\u0013\u0005\u0015\u0007\u00011A\u0005\u0012\u0005\u001d\u0017AB:iC\u0012|w/\u0006\u0002\u0002JB!\u00111ZAj\u001b\t\tiMC\u0002d\u0003\u001fT1!!5\u0003\u0003\u0015\u0019\b.\u00199f\u0013\u0011\t).!4\u0003\u0017M\u000bX/\u0019:f'\"\f\u0007/\u001a\u0005\n\u00033\u0004\u0001\u0019!C\t\u00037\f!b\u001d5bI><x\fJ3r)\r9\u0014Q\u001c\u0005\n}\u0005]\u0017\u0011!a\u0001\u0003\u0013D\u0001\"!9\u0001A\u0003&\u0011\u0011Z\u0001\bg\"\fGm\\<!\u0011%\t)\u000f\u0001a\u0001\n#\t9/\u0001\tb]RL\u0017\r\\5bgN+G\u000f^5oOV\u0011\u0011\u0011\u001e\t\u0004q\u0005-\u0018bAAws\t1\u0011I\\=SK\u001aD\u0011\"!=\u0001\u0001\u0004%\t\"a=\u0002)\u0005tG/[1mS\u0006\u001c8+\u001a;uS:<w\fJ3r)\r9\u0014Q\u001f\u0005\n}\u0005=\u0018\u0011!a\u0001\u0003SD\u0001\"!?\u0001A\u0003&\u0011\u0011^\u0001\u0012C:$\u0018.\u00197jCN\u001cV\r\u001e;j]\u001e\u0004\u0003bBA\u007f\u0001\u0011E\u0011q`\u0001\u0013g\u0016$X\u000f\u001d*f]\u0012,'/\u001b8h!\u0006\u001c8\u000fF\u00048\u0005\u0003\u0011YA!\u0004\t\u0011\t\r\u00111 a\u0001\u0005\u000b\t1AY2l!\r\u0001#qA\u0005\u0004\u0005\u0013!!a\u0002\"bG.,g\u000e\u001a\u0005\t\u0003w\tY\u00101\u0001\u0002>!9!qBA~\u0001\u0004q\u0018!\u00034peNC\u0017\rZ8x\u0011\u001d\u0011\u0019\u0002\u0001C)\u0005+\t\u0001#\u001a8e%\u0016tG-\u001a:j]\u001e\u0004\u0016m]:\u0015\u000f]\u00129B!\u0007\u0003\u001c!A!1\u0001B\t\u0001\u0004\u0011)\u0001\u0003\u0005\u0002<\tE\u0001\u0019AA\u001f\u0011\u001d\u0011yA!\u0005A\u0002yDqAa\b\u0001\t#\u0011\t#A\u0005qkND7\u000b^=mKR9qGa\t\u0003&\t\u001d\u0002\u0002\u0003B\u0002\u0005;\u0001\rA!\u0002\t\u0011\u0005m\"Q\u0004a\u0001\u0003{AqAa\u0004\u0003\u001e\u0001\u0007a\u0010C\u0004\u0003,\u0001!\tB!\f\u0002\u0019A,8\u000f\u001b#z]N#\u0018\u0010\\3\u0015\u000f]\u0012yC!\r\u00034!A!1\u0001B\u0015\u0001\u0004\u0011)\u0001\u0003\u0005\u0002<\t%\u0002\u0019AA\u001f\u0011\u0019\t(\u0011\u0006a\u0001g\"9!q\u0007\u0001\u0005\u0012\te\u0012!\u0004:f]\u0012,'/\u00127f[\u0016tG\u000fF\u00048\u0005w\u0011iDa\u0010\t\u0011\t\r!Q\u0007a\u0001\u0005\u000bA\u0001\"a\u000f\u00036\u0001\u0007\u0011Q\b\u0005\u0007c\nU\u0002\u0019A:\t\u000f\t\r\u0003\u0001\"\u0005\u0003F\u0005a!/\u001a8eKJ\u001c\u0006.\u00193poR9qGa\u0012\u0003J\t-\u0003\u0002\u0003B\u0002\u0005\u0003\u0002\rA!\u0002\t\u0011\u0005m\"\u0011\ta\u0001\u0003{Aa!\u001dB!\u0001\u0004\u0019\bb\u0002B(\u0001\u0011E!\u0011K\u0001\u0011K2,W.\u001a8u\u0013:4\u0018n]5cY\u0016$ra\u000eB*\u0005+\u00129\u0006\u0003\u0005\u0003\u0004\t5\u0003\u0019\u0001B\u0003\u0011!\tYD!\u0014A\u0002\u0005u\u0002BB9\u0003N\u0001\u00071\u000fC\u0004\u0003\\\u0001!\tA!\u0018\u0002\u001dUtW-];ja\u0016cW-\\3oiR\u0019qGa\u0018\t\rE\u0014I\u00061\u0001t\u0011\u001d\u0011\u0019\u0007\u0001C\t\u0005K\n\u0001dZ3u\u001fJ,\u0015/^5q/&$\bNS\"p[B|g.\u001a8u)\rA'q\r\u0005\u0007c\n\u0005\u0004\u0019A:\t\u000f\t-\u0004\u0001\"\u0005\u0003n\u0005Q1\r[3dWN#\u0018\u0010\\3\u0015\u000f]\u0012yG!\u001d\u0003v!A\u00111\bB5\u0001\u0004\ti\u0004C\u0004\u0003t\t%\u0004\u0019\u00015\u0002\u0005\r,\u0007bBAM\u0005S\u0002\rA \u0004\u0007\u0005s\u0002\u0001Aa\u001f\u00033Q+\u0007\u0010\u001e$jK2$7i\\7q_:,g\u000e^#mK6,g\u000e^\n\u0006\u0005oB'Q\u0010\t\u0005\u0005\u007f\u0012))\u0004\u0002\u0003\u0002*!!1QA0\u0003\u0015)g/\u001a8u\u0013\u0011\u00119I!!\u0003\u001d\u0005\u001bG/[8o\u0019&\u001cH/\u001a8fe\"Q\u0011Oa\u001e\u0003\u0002\u0003\u0006Ia\u001d9\t\u0017\t5%q\u000fBC\u0002\u0013\u0005!qR\u0001\u0005G>l\u0007/\u0006\u0002\u0003\u0012B\u0019\u0011Ma%\n\u0007\tU%M\u0001\u0006K)\u0016DHOR5fY\u0012D1B!'\u0003x\t\u0005\t\u0015!\u0003\u0003\u0012\u0006)1m\\7qA!9aEa\u001e\u0005\u0002\tuEC\u0002BP\u0005C\u0013\u0019\u000bE\u0002j\u0005oBa!\u001dBN\u0001\u0004\u0019\b\u0002\u0003BG\u00057\u0003\rA!%\t\u0011\u0005\u0015#q\u000fC!\u00033A\u0001B!+\u0003x\u0011\u0005!1V\u0001\u0010C\u000e$\u0018n\u001c8QKJ4wN]7fIR\u0019qG!,\t\u0011\t=&q\u0015a\u0001\u0005c\u000b\u0011!\u001a\t\u0005\u0005\u007f\u0012\u0019,\u0003\u0003\u00036\n\u0005%aC!di&|g.\u0012<f]RD\u0001\"!\u0005\u0003x\u0011\u0005\u00131\u0003\u0005\t\u0003;\u00119\b\"\u0011\u0002\u001a!A\u0011\u0011\u0005B<\t\u0003\nI\u0002\u0003\u0005\u0002&\t]D\u0011IA\r\u0011!\tILa\u001e\u0005B\t\u0005GcA\u001c\u0003D\"A\u00111\bB`\u0001\u0004\tiD\u0002\u0004\u0003H\u0002\u0001!\u0011\u001a\u0002\u0017\u0005V$Ho\u001c8D_6\u0004xN\\3oi\u0016cW-\\3oiN)!Q\u00195\u0003~!Q\u0011O!2\u0003\u0002\u0003\u0006Ia\u001d9\t\u0017\t5%Q\u0019BC\u0002\u0013\u0005!qZ\u000b\u0003\u0005#\u00042!\u0019Bj\u0013\r\u0011)N\u0019\u0002\b\u0015\n+H\u000f^8o\u0011-\u0011IJ!2\u0003\u0002\u0003\u0006IA!5\t\u000f\u0019\u0012)\r\"\u0001\u0003\\R1!Q\u001cBp\u0005C\u00042!\u001bBc\u0011\u0019\t(\u0011\u001ca\u0001g\"A!Q\u0012Bm\u0001\u0004\u0011\t\u000e\u0003\u0005\u0002F\t\u0015G\u0011IA\r\u0011!\u0011IK!2\u0005\u0002\t\u001dHcA\u001c\u0003j\"A!q\u0016Bs\u0001\u0004\u0011\t\f\u0003\u0005\u0002\u0012\t\u0015G\u0011IA\n\u0011!\tiB!2\u0005B\u0005e\u0001\u0002CA\u0011\u0005\u000b$\t%!\u0007\t\u0011\u0005\u0015\"Q\u0019C!\u00033A\u0001\"!/\u0003F\u0012\u0005#Q\u001f\u000b\u0004o\t]\b\u0002CA\u001e\u0005g\u0004\r!!\u0010")
public class JComponentRenderer
extends StyleRenderer {
    private final J2DGraphRenderer mainRenderer;
    private Values size;
    private int width;
    private int height;
    private final HashMap<JComponent, ComponentElement> compToElement;
    private SquareShape shadow;
    private Object antialiasSetting;

    public J2DGraphRenderer mainRenderer() {
        return this.mainRenderer;
    }

    public Values size() {
        return this.size;
    }

    public void size_$eq(Values x$1) {
        this.size = x$1;
    }

    public int width() {
        return this.width;
    }

    public void width_$eq(int x$1) {
        this.width = x$1;
    }

    public int height() {
        return this.height;
    }

    public void height_$eq(int x$1) {
        this.height = x$1;
    }

    public HashMap<JComponent, ComponentElement> compToElement() {
        return this.compToElement;
    }

    public SquareShape shadow() {
        return this.shadow;
    }

    public void shadow_$eq(SquareShape x$1) {
        this.shadow = x$1;
    }

    public Object antialiasSetting() {
        return this.antialiasSetting;
    }

    public void antialiasSetting_$eq(Object x$1) {
        this.antialiasSetting = x$1;
    }

    @Override
    public void setupRenderingPass(Backend bck, Camera camera, boolean forShadow) {
        GraphMetrics metrics = camera.metrics();
        Graphics2D g = bck.graphics2D();
        this.size_$eq(this.group().getSize());
        this.width_$eq((int)metrics.lengthToPx(this.size(), 0));
        this.height_$eq(this.size().size() > 1 ? (int)metrics.lengthToPx(this.size(), 1) : this.width());
        StyleConstants.ShadowMode shadowMode = this.group().getShadowMode();
        StyleConstants.ShadowMode shadowMode2 = StyleConstants.ShadowMode.NONE;
        if (!(shadowMode != null ? !shadowMode.equals(shadowMode2) : shadowMode2 != null)) {
            this.shadow_$eq(null);
        } else {
            this.shadow_$eq(new SquareShape());
        }
        this.antialiasSetting_$eq(g.getRenderingHint(RenderingHints.KEY_ANTIALIASING));
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
    }

    @Override
    public void endRenderingPass(Backend bck, Camera camera, boolean forShadow) {
        bck.graphics2D().setRenderingHint(RenderingHints.KEY_ANTIALIASING, this.antialiasSetting());
    }

    @Override
    public void pushStyle(Backend bck, Camera camera, boolean forShadow) {
        if (this.shadow() != null) {
            this.shadow().configureForGroup(bck, (Style)this.group(), camera);
        }
    }

    @Override
    public void pushDynStyle(Backend bck, Camera camera, GraphicElement element) {
    }

    @Override
    public void renderElement(Backend bck, Camera camera, GraphicElement element) {
        ComponentElement ce = this.getOrEquipWithJComponent(element);
        ce.setVisible(true);
        ce.updatePosition(camera);
        ce.updateLabel();
        if (!ce.init()) {
            this.checkStyle(camera, ce, true);
        } else if (this.group().hasEventElements()) {
            this.checkStyle(camera, ce, !this.hadEvents());
        } else {
            this.checkStyle(camera, ce, this.hadEvents());
        }
    }

    @Override
    public void renderShadow(Backend bck, Camera camera, GraphicElement element) {
        if (this.shadow() != null) {
            this.shadow().configureForElement(bck, element, null, camera);
            this.shadow().renderShadow(bck, camera, element, null);
        }
    }

    @Override
    public void elementInvisible(Backend bck, Camera camera, GraphicElement element) {
        this.getOrEquipWithJComponent(element).setVisible(false);
    }

    public void unequipElement(GraphicElement element) {
        Option option = this.compToElement().get((Object)((JComponent)element.getComponent()));
        if (option instanceof ComponentElement) {
            Option option2 = option;
            ((ComponentElement)option2).detach();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public ComponentElement getOrEquipWithJComponent(GraphicElement element) {
        StyleConstants.JComponents jComponents;
        block8: {
            void var3_3;
            BoxedUnit boxedUnit;
            ComponentElement ce;
            block7: {
                block6: {
                    JComponent component = (JComponent)element.getComponent();
                    ce = null;
                    if (component != null) {
                        ce = (ComponentElement)this.compToElement().get((Object)component).get();
                        boxedUnit = BoxedUnit.UNIT;
                        return var3_3;
                    }
                    jComponents = this.group().getJComponent();
                    StyleConstants.JComponents jComponents2 = StyleConstants.JComponents.BUTTON;
                    StyleConstants.JComponents jComponents3 = jComponents;
                    if (jComponents2 != null ? !jComponents2.equals(jComponents3) : jComponents3 != null) break block6;
                    ce = new ButtonComponentElement(this, element, new JButton(""));
                    BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                    break block7;
                }
                StyleConstants.JComponents jComponents4 = StyleConstants.JComponents.TEXT_FIELD;
                StyleConstants.JComponents jComponents5 = jComponents;
                if (jComponents4 != null ? !jComponents4.equals(jComponents5) : jComponents5 != null) break block8;
                ce = new TextFieldComponentElement(this, element, new JTextField(""));
                BoxedUnit boxedUnit3 = BoxedUnit.UNIT;
            }
            if (ce == null) {
                boxedUnit = BoxedUnit.UNIT;
                return var3_3;
            }
            boxedUnit = this.compToElement().put((Object)ce.jComponent(), (Object)ce);
            return var3_3;
        }
        StyleConstants.JComponents jComponents6 = StyleConstants.JComponents.PANEL;
        StyleConstants.JComponents jComponents7 = jComponents;
        if (jComponents6 == null) {
            if (jComponents7 == null) throw new RuntimeException("panel not yet available");
            throw new RuntimeException("WTF ?!?");
        }
        if (!jComponents6.equals(jComponents7)) throw new RuntimeException("WTF ?!?");
        throw new RuntimeException("panel not yet available");
    }

    public void checkStyle(Camera camera, ComponentElement ce, boolean force) {
        if (force) {
            ce.checkIcon(camera);
            ce.checkBorder(camera, force);
            ce.setFill();
            ce.setTextAlignment();
            ce.setTextFont();
        }
    }

    public JComponentRenderer(StyleGroup styleGroup, J2DGraphRenderer mainRenderer) {
        this.mainRenderer = mainRenderer;
        super(styleGroup);
        this.size = null;
        this.width = 0;
        this.height = 0;
        this.compToElement = new HashMap();
        this.shadow = null;
        this.antialiasSetting = null;
    }

    public abstract class ComponentElement
    extends JPanel {
        private final GraphicElement element;
        private boolean init;
        public final /* synthetic */ JComponentRenderer $outer;

        public GraphicElement element() {
            return this.element;
        }

        public boolean init() {
            return this.init;
        }

        public void init_$eq(boolean x$1) {
            this.init = x$1;
        }

        public abstract JComponent jComponent();

        public void setFill() {
        }

        public abstract void setTextAlignment();

        public abstract void setTextFont();

        public abstract void updateLabel();

        public void setBounds(int x, int y, int width, int height, Camera camera) {
            this.setBounds(x, y, width, height);
            int borderWidth = 0;
            StyleConstants.StrokeMode strokeMode = this.org$graphstream$ui$j2dviewer$renderer$JComponentRenderer$ComponentElement$$$outer().group().getStrokeMode();
            StyleConstants.StrokeMode strokeMode2 = StyleConstants.StrokeMode.NONE;
            if ((strokeMode == null ? strokeMode2 != null : !strokeMode.equals(strokeMode2)) && this.org$graphstream$ui$j2dviewer$renderer$JComponentRenderer$ComponentElement$$$outer().group().getStrokeWidth().value > 0.0) {
                borderWidth = (int)camera.metrics().lengthToPx(this.org$graphstream$ui$j2dviewer$renderer$JComponentRenderer$ComponentElement$$$outer().group().getStrokeWidth());
            }
            this.jComponent().setBounds(borderWidth, borderWidth, width - borderWidth * 2, height - borderWidth * 2);
        }

        public void detach() {
            this.org$graphstream$ui$j2dviewer$renderer$JComponentRenderer$ComponentElement$$$outer().mainRenderer().renderingSurface().remove(this);
        }

        public void updatePosition(Camera camera) {
            block4: {
                block3: {
                    GraphicElement graphicElement;
                    block2: {
                        graphicElement = this.element();
                        if (!(graphicElement instanceof GraphicNode)) break block2;
                        this.positionNodeComponent((GraphicNode)this.element(), camera);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block3;
                    }
                    if (!(graphicElement instanceof GraphicSprite)) break block4;
                    this.positionSpriteComponent((GraphicSprite)this.element(), camera);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
                return;
            }
            throw new RuntimeException("WTF ?");
        }

        @Override
        public void paint(Graphics g) {
            this.paintComponent(g);
            this.paintBorder(g);
            this.paintChildren(g);
        }

        public void positionNodeComponent(GraphicNode node, Camera camera) {
            Point3 pos = camera.transformGuToPx(node.getX(), node.getY(), 0.0);
            this.setBounds((int)(pos.x - (double)(this.org$graphstream$ui$j2dviewer$renderer$JComponentRenderer$ComponentElement$$$outer().width() / 2)), (int)(pos.y - (double)(this.org$graphstream$ui$j2dviewer$renderer$JComponentRenderer$ComponentElement$$$outer().height() / 2)), this.org$graphstream$ui$j2dviewer$renderer$JComponentRenderer$ComponentElement$$$outer().width(), this.org$graphstream$ui$j2dviewer$renderer$JComponentRenderer$ComponentElement$$$outer().height(), camera);
        }

        public void positionSpriteComponent(GraphicSprite sprite, Camera camera) {
            Point3 pos = camera.getSpritePosition(sprite, new Point3(), StyleConstants.Units.PX);
            this.setBounds((int)(pos.x - (double)(this.org$graphstream$ui$j2dviewer$renderer$JComponentRenderer$ComponentElement$$$outer().width() / 2)), (int)(pos.y - (double)(this.org$graphstream$ui$j2dviewer$renderer$JComponentRenderer$ComponentElement$$$outer().height() / 2)), this.org$graphstream$ui$j2dviewer$renderer$JComponentRenderer$ComponentElement$$$outer().width(), this.org$graphstream$ui$j2dviewer$renderer$JComponentRenderer$ComponentElement$$$outer().height(), camera);
        }

        public void checkBorder(Camera camera, boolean force) {
            if (force) {
                StyleConstants.StrokeMode strokeMode = this.org$graphstream$ui$j2dviewer$renderer$JComponentRenderer$ComponentElement$$$outer().group().getStrokeMode();
                StyleConstants.StrokeMode strokeMode2 = StyleConstants.StrokeMode.NONE;
                if ((strokeMode == null ? strokeMode2 != null : !strokeMode.equals(strokeMode2)) && this.org$graphstream$ui$j2dviewer$renderer$JComponentRenderer$ComponentElement$$$outer().group().getStrokeWidth().value > 0.0) {
                    this.setBorder(this.createBorder(camera));
                } else {
                    this.setBorder(null);
                }
            } else {
                this.updateBorder(camera);
            }
        }

        public Border createBorder(Camera camera) {
            Border border;
            int width = (int)camera.metrics().lengthToPx(this.org$graphstream$ui$j2dviewer$renderer$JComponentRenderer$ComponentElement$$$outer().group().getStrokeWidth());
            StyleConstants.StrokeMode strokeMode = this.org$graphstream$ui$j2dviewer$renderer$JComponentRenderer$ComponentElement$$$outer().group().getStrokeMode();
            StyleConstants.StrokeMode strokeMode2 = StyleConstants.StrokeMode.PLAIN;
            StyleConstants.StrokeMode strokeMode3 = strokeMode;
            if (!(strokeMode2 != null ? !strokeMode2.equals(strokeMode3) : strokeMode3 != null)) {
                border = BorderFactory.createLineBorder(this.org$graphstream$ui$j2dviewer$renderer$JComponentRenderer$ComponentElement$$$outer().group().getStrokeColor(0), width);
            } else {
                StyleConstants.StrokeMode strokeMode4 = StyleConstants.StrokeMode.DOTS;
                StyleConstants.StrokeMode strokeMode5 = strokeMode;
                if (!(strokeMode4 != null ? !strokeMode4.equals(strokeMode5) : strokeMode5 != null)) {
                    throw new RuntimeException("TODO create dots and dashes borders for component to respect stroke-mode.");
                }
                StyleConstants.StrokeMode strokeMode6 = StyleConstants.StrokeMode.DASHES;
                StyleConstants.StrokeMode strokeMode7 = strokeMode;
                if (!(strokeMode6 != null ? !strokeMode6.equals(strokeMode7) : strokeMode7 != null)) {
                    throw new RuntimeException("TODO create dots and dashes borders for component to respect stroke-mode.");
                }
                border = null;
            }
            return border;
        }

        public void updateBorder(Camera camera) {
        }

        public abstract void checkIcon(Camera var1);

        public /* synthetic */ JComponentRenderer org$graphstream$ui$j2dviewer$renderer$JComponentRenderer$ComponentElement$$$outer() {
            return this.$outer;
        }

        public ComponentElement(JComponentRenderer $outer, GraphicElement element) {
            this.element = element;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            this.init = false;
            this.setLayout(null);
            $outer.mainRenderer().renderingSurface().add(this);
        }
    }

    public class ButtonComponentElement
    extends ComponentElement
    implements ActionListener {
        private final JButton comp;

        public JButton comp() {
            return this.comp;
        }

        @Override
        public void detach() {
            super.detach();
            this.comp().removeActionListener(this);
            this.remove(this.comp());
            super.element().setComponent(null);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            super.element().label = this.comp().getText();
            super.element().setAttribute("ui.label", new Object[]{super.element().label});
            super.element().setAttribute("ui.clicked", new Object[0]);
            super.element().myGraph().setAttribute("ui.clicked", new Object[]{super.element().getId()});
        }

        @Override
        public JComponent jComponent() {
            return this.comp();
        }

        @Override
        public void setTextAlignment() {
            StyleConstants.TextAlignment textAlignment = this.org$graphstream$ui$j2dviewer$renderer$JComponentRenderer$ButtonComponentElement$$$outer().group().getTextAlignment();
            StyleConstants.TextAlignment textAlignment2 = StyleConstants.TextAlignment.ALONG;
            StyleConstants.TextAlignment textAlignment3 = textAlignment;
            if (!(textAlignment2 != null ? !textAlignment2.equals(textAlignment3) : textAlignment3 != null)) {
                this.comp().setHorizontalAlignment(0);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                StyleConstants.TextAlignment textAlignment4 = StyleConstants.TextAlignment.JUSTIFY;
                StyleConstants.TextAlignment textAlignment5 = textAlignment;
                if (!(textAlignment4 != null ? !textAlignment4.equals(textAlignment5) : textAlignment5 != null)) {
                    this.comp().setHorizontalAlignment(0);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    StyleConstants.TextAlignment textAlignment6 = StyleConstants.TextAlignment.CENTER;
                    StyleConstants.TextAlignment textAlignment7 = textAlignment;
                    if (!(textAlignment6 != null ? !textAlignment6.equals(textAlignment7) : textAlignment7 != null)) {
                        this.comp().setHorizontalAlignment(0);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else {
                        StyleConstants.TextAlignment textAlignment8 = StyleConstants.TextAlignment.AT_RIGHT;
                        StyleConstants.TextAlignment textAlignment9 = textAlignment;
                        if (!(textAlignment8 != null ? !textAlignment8.equals(textAlignment9) : textAlignment9 != null)) {
                            this.comp().setHorizontalAlignment(4);
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        } else {
                            StyleConstants.TextAlignment textAlignment10 = StyleConstants.TextAlignment.RIGHT;
                            StyleConstants.TextAlignment textAlignment11 = textAlignment;
                            if (!(textAlignment10 != null ? !textAlignment10.equals(textAlignment11) : textAlignment11 != null)) {
                                this.comp().setHorizontalAlignment(4);
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            } else {
                                StyleConstants.TextAlignment textAlignment12 = StyleConstants.TextAlignment.AT_LEFT;
                                StyleConstants.TextAlignment textAlignment13 = textAlignment;
                                if (!(textAlignment12 != null ? !textAlignment12.equals(textAlignment13) : textAlignment13 != null)) {
                                    this.comp().setHorizontalAlignment(2);
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                } else {
                                    StyleConstants.TextAlignment textAlignment14 = StyleConstants.TextAlignment.LEFT;
                                    StyleConstants.TextAlignment textAlignment15 = textAlignment;
                                    if (!(textAlignment14 != null ? !textAlignment14.equals(textAlignment15) : textAlignment15 != null)) {
                                        this.comp().setHorizontalAlignment(2);
                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    } else {
                                        StyleConstants.TextAlignment textAlignment16 = StyleConstants.TextAlignment.ABOVE;
                                        StyleConstants.TextAlignment textAlignment17 = textAlignment;
                                        if (!(textAlignment16 != null ? !textAlignment16.equals(textAlignment17) : textAlignment17 != null)) {
                                            this.comp().setVerticalAlignment(1);
                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                        } else {
                                            StyleConstants.TextAlignment textAlignment18 = StyleConstants.TextAlignment.UNDER;
                                            StyleConstants.TextAlignment textAlignment19 = textAlignment;
                                            if (!(textAlignment18 != null ? !textAlignment18.equals(textAlignment19) : textAlignment19 != null)) {
                                                this.comp().setVerticalAlignment(3);
                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                            } else {
                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }

        @Override
        public void setTextFont() {
            Font font = this.org$graphstream$ui$j2dviewer$renderer$JComponentRenderer$ButtonComponentElement$$$outer().group().getTextFont().equals("default") ? FontCache$.MODULE$.getDefaultFont(this.org$graphstream$ui$j2dviewer$renderer$JComponentRenderer$ButtonComponentElement$$$outer().group().getTextStyle(), (int)this.org$graphstream$ui$j2dviewer$renderer$JComponentRenderer$ButtonComponentElement$$$outer().group().getTextSize().value) : FontCache$.MODULE$.getFont(this.org$graphstream$ui$j2dviewer$renderer$JComponentRenderer$ButtonComponentElement$$$outer().group().getTextFont(), this.org$graphstream$ui$j2dviewer$renderer$JComponentRenderer$ButtonComponentElement$$$outer().group().getTextStyle(), (int)this.org$graphstream$ui$j2dviewer$renderer$JComponentRenderer$ButtonComponentElement$$$outer().group().getTextSize().value);
            this.comp().setFont(font);
            this.comp().setForeground(this.org$graphstream$ui$j2dviewer$renderer$JComponentRenderer$ButtonComponentElement$$$outer().group().getTextColor(0));
        }

        @Override
        public void updateLabel() {
            String label = super.element().getLabel();
            if (label != null) {
                this.comp().setText(label);
            }
        }

        @Override
        public void checkIcon(Camera camera) {
            block6: {
                block2: {
                    StyleConstants.IconMode iconMode;
                    block5: {
                        block4: {
                            block3: {
                                String url;
                                BufferedImage image;
                                StyleConstants.IconMode iconMode2 = this.org$graphstream$ui$j2dviewer$renderer$JComponentRenderer$ButtonComponentElement$$$outer().group().getIconMode();
                                StyleConstants.IconMode iconMode3 = StyleConstants.IconMode.NONE;
                                if (!(iconMode2 == null ? iconMode3 != null : !iconMode2.equals(iconMode3)) || (image = (BufferedImage)ImageCache$.MODULE$.loadImage(url = this.org$graphstream$ui$j2dviewer$renderer$JComponentRenderer$ButtonComponentElement$$$outer().group().getIcon()).get()) == null) break block2;
                                this.comp().setIcon(new ImageIcon(image));
                                iconMode = this.org$graphstream$ui$j2dviewer$renderer$JComponentRenderer$ButtonComponentElement$$$outer().group().getIconMode();
                                StyleConstants.IconMode iconMode4 = StyleConstants.IconMode.AT_LEFT;
                                StyleConstants.IconMode iconMode5 = iconMode;
                                if (iconMode4 != null ? !iconMode4.equals(iconMode5) : iconMode5 != null) break block3;
                                this.comp().setHorizontalTextPosition(4);
                                this.comp().setVerticalTextPosition(0);
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                break block2;
                            }
                            StyleConstants.IconMode iconMode6 = StyleConstants.IconMode.AT_RIGHT;
                            StyleConstants.IconMode iconMode7 = iconMode;
                            if (iconMode6 != null ? !iconMode6.equals(iconMode7) : iconMode7 != null) break block4;
                            this.comp().setHorizontalTextPosition(2);
                            this.comp().setVerticalTextPosition(0);
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            break block2;
                        }
                        StyleConstants.IconMode iconMode8 = StyleConstants.IconMode.ABOVE;
                        StyleConstants.IconMode iconMode9 = iconMode;
                        if (iconMode8 != null ? !iconMode8.equals(iconMode9) : iconMode9 != null) break block5;
                        this.comp().setHorizontalTextPosition(0);
                        this.comp().setVerticalTextPosition(3);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block2;
                    }
                    StyleConstants.IconMode iconMode10 = StyleConstants.IconMode.UNDER;
                    StyleConstants.IconMode iconMode11 = iconMode;
                    if (iconMode10 != null ? !iconMode10.equals(iconMode11) : iconMode11 != null) break block6;
                    this.comp().setHorizontalTextPosition(0);
                    this.comp().setVerticalTextPosition(1);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
                return;
            }
            throw new RuntimeException("unknown image mode");
        }

        public /* synthetic */ JComponentRenderer org$graphstream$ui$j2dviewer$renderer$JComponentRenderer$ButtonComponentElement$$$outer() {
            return this.$outer;
        }

        public ButtonComponentElement(JComponentRenderer $outer, GraphicElement element, JButton comp) {
            this.comp = comp;
            super($outer, element);
            super.element().setComponent((Object)comp);
            comp.addActionListener(this);
            this.add(comp);
        }
    }

    public class TextFieldComponentElement
    extends ComponentElement
    implements ActionListener {
        private final JTextField comp;

        public JTextField comp() {
            return this.comp;
        }

        @Override
        public void detach() {
            super.detach();
            this.comp().removeActionListener(this);
            this.remove(this.comp());
            super.element().setComponent(null);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            super.element().label = this.comp().getText();
            super.element().setAttribute("ui.label", new Object[]{super.element().label});
            super.element().setAttribute("ui.clicked", new Object[0]);
        }

        @Override
        public JComponent jComponent() {
            return this.comp();
        }

        @Override
        public void setTextAlignment() {
            StyleConstants.TextAlignment textAlignment = this.org$graphstream$ui$j2dviewer$renderer$JComponentRenderer$TextFieldComponentElement$$$outer().group().getTextAlignment();
            StyleConstants.TextAlignment textAlignment2 = StyleConstants.TextAlignment.ABOVE;
            StyleConstants.TextAlignment textAlignment3 = textAlignment;
            if (!(textAlignment2 != null ? !textAlignment2.equals(textAlignment3) : textAlignment3 != null)) {
                this.comp().setHorizontalAlignment(0);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                StyleConstants.TextAlignment textAlignment4 = StyleConstants.TextAlignment.UNDER;
                StyleConstants.TextAlignment textAlignment5 = textAlignment;
                if (!(textAlignment4 != null ? !textAlignment4.equals(textAlignment5) : textAlignment5 != null)) {
                    this.comp().setHorizontalAlignment(0);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    StyleConstants.TextAlignment textAlignment6 = StyleConstants.TextAlignment.ALONG;
                    StyleConstants.TextAlignment textAlignment7 = textAlignment;
                    if (!(textAlignment6 != null ? !textAlignment6.equals(textAlignment7) : textAlignment7 != null)) {
                        this.comp().setHorizontalAlignment(0);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else {
                        StyleConstants.TextAlignment textAlignment8 = StyleConstants.TextAlignment.JUSTIFY;
                        StyleConstants.TextAlignment textAlignment9 = textAlignment;
                        if (!(textAlignment8 != null ? !textAlignment8.equals(textAlignment9) : textAlignment9 != null)) {
                            this.comp().setHorizontalAlignment(0);
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        } else {
                            StyleConstants.TextAlignment textAlignment10 = StyleConstants.TextAlignment.CENTER;
                            StyleConstants.TextAlignment textAlignment11 = textAlignment;
                            if (!(textAlignment10 != null ? !textAlignment10.equals(textAlignment11) : textAlignment11 != null)) {
                                this.comp().setHorizontalAlignment(0);
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            } else {
                                StyleConstants.TextAlignment textAlignment12 = StyleConstants.TextAlignment.AT_RIGHT;
                                StyleConstants.TextAlignment textAlignment13 = textAlignment;
                                if (!(textAlignment12 != null ? !textAlignment12.equals(textAlignment13) : textAlignment13 != null)) {
                                    this.comp().setHorizontalAlignment(4);
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                } else {
                                    StyleConstants.TextAlignment textAlignment14 = StyleConstants.TextAlignment.RIGHT;
                                    StyleConstants.TextAlignment textAlignment15 = textAlignment;
                                    if (!(textAlignment14 != null ? !textAlignment14.equals(textAlignment15) : textAlignment15 != null)) {
                                        this.comp().setHorizontalAlignment(4);
                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    } else {
                                        StyleConstants.TextAlignment textAlignment16 = StyleConstants.TextAlignment.AT_LEFT;
                                        StyleConstants.TextAlignment textAlignment17 = textAlignment;
                                        if (!(textAlignment16 != null ? !textAlignment16.equals(textAlignment17) : textAlignment17 != null)) {
                                            this.comp().setHorizontalAlignment(2);
                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                        } else {
                                            StyleConstants.TextAlignment textAlignment18 = StyleConstants.TextAlignment.LEFT;
                                            StyleConstants.TextAlignment textAlignment19 = textAlignment;
                                            if (!(textAlignment18 != null ? !textAlignment18.equals(textAlignment19) : textAlignment19 != null)) {
                                                this.comp().setHorizontalAlignment(2);
                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                            } else {
                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }

        @Override
        public void setTextFont() {
            Font font = this.org$graphstream$ui$j2dviewer$renderer$JComponentRenderer$TextFieldComponentElement$$$outer().group().getTextFont().equals("default") ? FontCache$.MODULE$.getDefaultFont(this.org$graphstream$ui$j2dviewer$renderer$JComponentRenderer$TextFieldComponentElement$$$outer().group().getTextStyle(), (int)this.org$graphstream$ui$j2dviewer$renderer$JComponentRenderer$TextFieldComponentElement$$$outer().group().getTextSize().value) : FontCache$.MODULE$.getFont(this.org$graphstream$ui$j2dviewer$renderer$JComponentRenderer$TextFieldComponentElement$$$outer().group().getTextFont(), this.org$graphstream$ui$j2dviewer$renderer$JComponentRenderer$TextFieldComponentElement$$$outer().group().getTextStyle(), (int)this.org$graphstream$ui$j2dviewer$renderer$JComponentRenderer$TextFieldComponentElement$$$outer().group().getTextSize().value);
            this.comp().setFont(font);
            this.comp().setForeground(this.org$graphstream$ui$j2dviewer$renderer$JComponentRenderer$TextFieldComponentElement$$$outer().group().getTextColor(0));
        }

        @Override
        public void updateLabel() {
            if (!this.comp().hasFocus()) {
                this.comp().setText(super.element().getLabel());
            }
        }

        @Override
        public void checkIcon(Camera camera) {
        }

        public /* synthetic */ JComponentRenderer org$graphstream$ui$j2dviewer$renderer$JComponentRenderer$TextFieldComponentElement$$$outer() {
            return this.$outer;
        }

        public TextFieldComponentElement(JComponentRenderer $outer, GraphicElement element, JTextField comp) {
            this.comp = comp;
            super($outer, element);
            super.element().setComponent((Object)comp);
            comp.addActionListener(this);
            this.add(comp);
        }
    }
}

