/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.ui.j2dviewer.renderer.shape;

import org.graphstream.ui.geom.Point2;
import org.graphstream.ui.geom.Point3;
import org.graphstream.ui.graphicGraph.GraphicEdge;
import org.graphstream.ui.graphicGraph.GraphicElement;
import org.graphstream.ui.graphicGraph.GraphicNode;
import org.graphstream.ui.graphicGraph.stylesheet.Style;
import org.graphstream.ui.graphicGraph.stylesheet.StyleConstants;
import org.graphstream.ui.j2dviewer.Camera;
import org.graphstream.ui.j2dviewer.renderer.AreaSkeleton;
import org.graphstream.ui.j2dviewer.renderer.ConnectorSkeleton;
import org.graphstream.ui.j2dviewer.renderer.Skeleton$;
import org.graphstream.ui.j2dviewer.renderer.shape.Connector;

public abstract class Connector$class {
    public static Point3 fromPos(Connector $this) {
        return $this.skel().from();
    }

    public static Point3 byPos1(Connector $this) {
        return $this.skel().isCurve() ? $this.skel().apply(1) : null;
    }

    public static Point3 byPos2(Connector $this) {
        return $this.skel().isCurve() ? $this.skel().apply(2) : null;
    }

    public static Point3 toPos(Connector $this) {
        return $this.skel().to();
    }

    public static void configureConnectorForGroup(Connector $this, Style style, Camera camera) {
        Connector$class.org$graphstream$ui$j2dviewer$renderer$shape$Connector$$sizeForGroup($this, style, camera);
    }

    public static void configureConnectorForElement(Connector $this, Camera camera, GraphicEdge element, ConnectorSkeleton skel) {
        $this.skel_$eq(skel);
        $this.theEdge_$eq(element);
        Connector$class.org$graphstream$ui$j2dviewer$renderer$shape$Connector$$sizeForElement($this, (Style)element.getStyle(), camera, (GraphicElement)element);
        Connector$class.org$graphstream$ui$j2dviewer$renderer$shape$Connector$$endPoints($this, element.from, element.to, element.isDirected(), camera);
        if (element.getGroup() != null) {
            skel.setMulti(element.getGroup().getCount());
        }
        if (element.hasAttribute("ui.points")) {
            skel.setPoly(element.getAttribute("ui.points"));
        } else {
            Connector$class.org$graphstream$ui$j2dviewer$renderer$shape$Connector$$positionForLinesAndCurves($this, skel, (Style)element.from.getStyle(), element.from, element.to, element.multi, element.getGroup());
        }
    }

    public static void org$graphstream$ui$j2dviewer$renderer$shape$Connector$$sizeForGroup(Connector $this, Style style, Camera camera) {
        $this.theSize_$eq(camera.metrics().lengthToGu(style.getSize(), 0));
    }

    public static void org$graphstream$ui$j2dviewer$renderer$shape$Connector$$sizeForElement(Connector $this, Style style, Camera camera, GraphicElement element) {
        StyleConstants.SizeMode sizeMode = style.getSizeMode();
        StyleConstants.SizeMode sizeMode2 = StyleConstants.SizeMode.DYN_SIZE;
        if (!(sizeMode != null ? !sizeMode.equals(sizeMode2) : sizeMode2 != null) && element.hasAttribute("ui.size")) {
            $this.theSize_$eq(camera.metrics().lengthToGu(StyleConstants.convertValue((Object)element.getAttribute("ui.size"))));
        }
    }

    public static void org$graphstream$ui$j2dviewer$renderer$shape$Connector$$endPoints(Connector $this, GraphicNode from, GraphicNode to, boolean directed, Camera camera) {
        AreaSkeleton fromInfo = (AreaSkeleton)from.getAttribute(Skeleton$.MODULE$.attributeName());
        AreaSkeleton toInfo = (AreaSkeleton)to.getAttribute(Skeleton$.MODULE$.attributeName());
        if (fromInfo == null || toInfo == null) {
            Connector$class.org$graphstream$ui$j2dviewer$renderer$shape$Connector$$endPoints($this, (Style)from.getStyle(), (Style)to.getStyle(), directed, camera);
        } else {
            $this.isDirected_$eq(directed);
            $this.theSourceSize().copy(fromInfo.theSize());
            $this.theTargetSize().copy(toInfo.theSize());
        }
    }

    public static void org$graphstream$ui$j2dviewer$renderer$shape$Connector$$endPoints(Connector $this, double sourceWidth, double targetWidth, boolean directed) {
        $this.theSourceSize().set(sourceWidth, sourceWidth);
        $this.theTargetSize().set(targetWidth, targetWidth);
        $this.isDirected_$eq(directed);
    }

    public static void org$graphstream$ui$j2dviewer$renderer$shape$Connector$$endPoints(Connector $this, double sourceWidth, double sourceHeight, double targetWidth, double targetHeight, boolean directed) {
        $this.theSourceSize().set(sourceWidth, sourceHeight);
        $this.theTargetSize().set(targetWidth, targetHeight);
        $this.isDirected_$eq(directed);
    }

    public static void org$graphstream$ui$j2dviewer$renderer$shape$Connector$$endPoints(Connector $this, Style sourceStyle, Style targetStyle, boolean directed, Camera camera) {
        double srcx = camera.metrics().lengthToGu(sourceStyle.getSize(), 0);
        double srcy = sourceStyle.getSize().size() > 1 ? camera.metrics().lengthToGu(sourceStyle.getSize(), 1) : srcx;
        double trgx = camera.metrics().lengthToGu(targetStyle.getSize(), 0);
        double trgy = targetStyle.getSize().size() > 1 ? camera.metrics().lengthToGu(targetStyle.getSize(), 1) : trgx;
        $this.theSourceSize().set(srcx, srcy);
        $this.theTargetSize().set(trgx, trgy);
        $this.isDirected_$eq(directed);
    }

    public static void org$graphstream$ui$j2dviewer$renderer$shape$Connector$$positionForLinesAndCurves(Connector $this, ConnectorSkeleton skel, Style style, GraphicNode from, GraphicNode to) {
        Connector$class.org$graphstream$ui$j2dviewer$renderer$shape$Connector$$positionForLinesAndCurves($this, skel, style, from, to, 0, null);
    }

    public static void org$graphstream$ui$j2dviewer$renderer$shape$Connector$$positionForLinesAndCurves(Connector $this, ConnectorSkeleton skel, Style style, GraphicNode from, GraphicNode to, int multi, GraphicEdge.EdgeGroup group) {
        if (group == null) {
            GraphicNode graphicNode = from;
            GraphicNode graphicNode2 = to;
            if (!(graphicNode != null ? !graphicNode.equals(graphicNode2) : graphicNode2 != null)) {
                Connector$class.org$graphstream$ui$j2dviewer$renderer$shape$Connector$$positionEdgeLoop($this, skel, from.getX(), from.getY(), 0);
            } else {
                skel.setLine(from.getX(), from.getY(), 0.0, to.getX(), to.getY(), 0.0);
            }
        } else {
            GraphicNode graphicNode = from;
            GraphicNode graphicNode3 = to;
            if (!(graphicNode != null ? !graphicNode.equals(graphicNode3) : graphicNode3 != null)) {
                Connector$class.org$graphstream$ui$j2dviewer$renderer$shape$Connector$$positionEdgeLoop($this, skel, from.getX(), from.getY(), multi);
            } else {
                Connector$class.org$graphstream$ui$j2dviewer$renderer$shape$Connector$$positionMultiEdge($this, skel, from.getX(), from.getY(), to.getX(), to.getY(), multi, group);
            }
        }
    }

    public static void org$graphstream$ui$j2dviewer$renderer$shape$Connector$$positionEdgeLoop(Connector $this, ConnectorSkeleton skel, double x, double y, int multi) {
        float m = 1.0f + (float)multi * 0.2f;
        double s = ($this.theTargetSize().x + $this.theTargetSize().y) / (double)2;
        double d = s / (double)2 * (double)m + (double)4 * s * (double)m;
        skel.setLoop(x, y, 0.0, x + d, y, 0.0, x, y + d, 0.0);
    }

    public static void org$graphstream$ui$j2dviewer$renderer$shape$Connector$$positionMultiEdge(Connector $this, ConnectorSkeleton skel, double x1, double y1, double x2, double y2, int multi, GraphicEdge.EdgeGroup group) {
        double vx = x2 - x1;
        double vy = y2 - y1;
        double vx2 = vy * 0.6;
        double vy2 = -vx * 0.6;
        double gap = 0.2;
        double ox = 0.0;
        double oy = 0.0;
        double f = (double)((1 + multi) / 2) * gap;
        vx *= 0.2;
        vy *= 0.2;
        GraphicEdge main = group.getEdge(0);
        GraphicEdge edge = group.getEdge(multi);
        if (group.getCount() % 2 == 0) {
            ox = vx2 * (gap / (double)2);
            oy = vy2 * (gap / (double)2);
            if (edge.from != main.from) {
                ox = -ox;
                oy = -oy;
            }
        }
        vx2 *= f;
        vy2 *= f;
        double xx1 = x1 + vx;
        double yy1 = y1 + vy;
        double xx2 = x2 - vx;
        double yy2 = y2 - vy;
        int m = multi + (edge.from == main.from ? 0 : 1);
        if (m % 2 == 0) {
            xx1 += vx2 + ox;
            yy1 += vy2 + oy;
            xx2 += vx2 + ox;
            yy2 += vy2 + oy;
        } else {
            xx1 -= vx2 - ox;
            yy1 -= vy2 - oy;
            xx2 -= vx2 - ox;
            yy2 -= vy2 - oy;
        }
        skel.setCurve(x1, y1, 0.0, xx1, yy1, 0.0, xx2, yy2, 0.0, x2, y2, 0.0);
    }

    public static void $init$(Connector $this) {
        $this.theEdge_$eq(null);
        $this.theSize_$eq(0.0);
        $this.theTargetSize_$eq(new Point2(0.0, 0.0));
        $this.theSourceSize_$eq(new Point2(0.0, 0.0));
        $this.isDirected_$eq(false);
    }
}

