/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.ui.j2dviewer.renderer.shape.swing;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import org.graphstream.ui.geom.Point2;
import org.graphstream.ui.geom.Point3;
import org.graphstream.ui.geom.Vector2;
import org.graphstream.ui.graphicGraph.GraphicEdge;
import org.graphstream.ui.graphicGraph.GraphicElement;
import org.graphstream.ui.graphicGraph.StyleGroup;
import org.graphstream.ui.graphicGraph.stylesheet.Style;
import org.graphstream.ui.j2dviewer.Backend;
import org.graphstream.ui.j2dviewer.Camera;
import org.graphstream.ui.j2dviewer.renderer.AreaSkeleton;
import org.graphstream.ui.j2dviewer.renderer.Skeleton;
import org.graphstream.ui.j2dviewer.renderer.shape.Area$class;
import org.graphstream.ui.j2dviewer.renderer.shape.AreaOnConnector$class;
import org.graphstream.ui.j2dviewer.renderer.shape.Connector;
import org.graphstream.ui.j2dviewer.renderer.shape.OnConnector$class;
import org.graphstream.ui.j2dviewer.renderer.shape.swing.AreaOnConnectorShape;
import org.graphstream.ui.j2dviewer.renderer.shape.swing.AreaOnConnectorShape$class;
import org.graphstream.ui.j2dviewer.renderer.shape.swing.Fillable$class;
import org.graphstream.ui.j2dviewer.renderer.shape.swing.Shadowable$class;
import org.graphstream.ui.j2dviewer.renderer.shape.swing.ShapeDecor;
import org.graphstream.ui.j2dviewer.renderer.shape.swing.ShapePaint;
import org.graphstream.ui.j2dviewer.renderer.shape.swing.ShapeStroke;
import org.graphstream.ui.j2dviewer.renderer.shape.swing.Strokable$class;
import org.graphstream.ui.util.CubicCurve$;
import org.graphstream.ui.util.ShapeUtil$;
import scala.MatchError;
import scala.Tuple2;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.TraitSetter;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005a\u0001B\u0001\u0003\u0001E\u0011AbQ5sG2,wJ\\#eO\u0016T!a\u0001\u0003\u0002\u000bM<\u0018N\\4\u000b\u0005\u00151\u0011!B:iCB,'BA\u0004\t\u0003!\u0011XM\u001c3fe\u0016\u0014(BA\u0005\u000b\u0003%Q'\u0007\u001a<jK^,'O\u0003\u0002\f\u0019\u0005\u0011Q/\u001b\u0006\u0003\u001b9\t1b\u001a:ba\"\u001cHO]3b[*\tq\"A\u0002pe\u001e\u001c\u0001aE\u0002\u0001%a\u0001\"a\u0005\f\u000e\u0003QQ\u0011!F\u0001\u0006g\u000e\fG.Y\u0005\u0003/Q\u0011a!\u00118z%\u00164\u0007CA\r\u001b\u001b\u0005\u0011\u0011BA\u000e\u0003\u0005Q\t%/Z1P]\u000e{gN\\3di>\u00148\u000b[1qK\")Q\u0004\u0001C\u0001=\u00051A(\u001b8jiz\"\u0012a\b\t\u00033\u0001Aq!\t\u0001C\u0002\u0013\u0005!%\u0001\u0005uQ\u0016\u001c\u0006.\u00199f+\u0005\u0019\u0003C\u0001\u0013/\u001d\t)C&D\u0001'\u0015\t9\u0003&\u0001\u0003hK>l'BA\u0015+\u0003\r\tw\u000f\u001e\u0006\u0002W\u0005!!.\u0019<b\u0013\tic%A\u0005FY2L\u0007o]33\t&\u0011q\u0006\r\u0002\u0007\t>,(\r\\3\u000b\u000552\u0003B\u0002\u001a\u0001A\u0003%1%A\u0005uQ\u0016\u001c\u0006.\u00199fA!)A\u0007\u0001C\tk\u0005!Q.Y6f)\r1\u0014h\u0010\t\u0003']J!\u0001\u000f\u000b\u0003\tUs\u0017\u000e\u001e\u0005\u0006uM\u0002\raO\u0001\u0004E\u000e\\\u0007C\u0001\u001f>\u001b\u0005A\u0011B\u0001 \t\u0005\u001d\u0011\u0015mY6f]\u0012DQ\u0001Q\u001aA\u0002\u0005\u000baaY1nKJ\f\u0007C\u0001\u001fC\u0013\t\u0019\u0005B\u0001\u0004DC6,'/\u0019\u0005\u0006\u000b\u0002!\tBR\u0001\u000b[\u0006\\Wm\u00155bI><Hc\u0001\u001cH\u0011\")!\b\u0012a\u0001w!)\u0001\t\u0012a\u0001\u0003\")A\u0007\u0001C\t\u0015R\u0019ag\u0013)\t\u000b1K\u0005\u0019A'\u0002\u0013\u0019|'o\u00155bI><\bCA\nO\u0013\tyECA\u0004C_>dW-\u00198\t\u000b\u0001K\u0005\u0019A!\t\u000bI\u0003A\u0011C*\u0002\u00155\f7.Z(o\u0019&tW\rF\u00027)VCQ\u0001T)A\u00025CQ\u0001Q)A\u0002\u0005CQa\u0016\u0001\u0005\u0012a\u000b1\"\\1lK>s7)\u001e:wKR\u0019a'\u0017.\t\u000b13\u0006\u0019A'\t\u000b\u00013\u0006\u0019A!\t\u000bq\u0003A\u0011A/\u0002\u0019I,g\u000eZ3s'\"\fGm\\<\u0015\u000bYrv\f\u00195\t\u000biZ\u0006\u0019A\u001e\t\u000b\u0001[\u0006\u0019A!\t\u000b\u0005\\\u0006\u0019\u00012\u0002\u000f\u0015dW-\\3oiB\u00111MZ\u0007\u0002I*\u0011QMC\u0001\rOJ\f\u0007\u000f[5d\u000fJ\f\u0007\u000f[\u0005\u0003O\u0012\u0014ab\u0012:ba\"L7-\u00127f[\u0016tG\u000fC\u0003j7\u0002\u0007!.\u0001\u0003tW\u0016d\u0007CA6m\u001b\u00051\u0011BA7\u0007\u0005!\u00196.\u001a7fi>t\u0007\"B8\u0001\t\u0003\u0001\u0018A\u0002:f]\u0012,'\u000fF\u00037cJ\u001cH\u000fC\u0003;]\u0002\u00071\bC\u0003A]\u0002\u0007\u0011\tC\u0003b]\u0002\u0007!\rC\u0003j]\u0002\u0007!\u000eC\u0003w\u0001\u0011Eq/A\u0007mK:<G\u000f[(g\u0007V\u0014h/\u001a\u000b\u0003qj\u0004\"aE=\n\u0005=\"\u0002\"B>v\u0001\u0004a\u0018!A2\u0011\u0005utX\"\u0001\u0003\n\u0005}$!!C\"p]:,7\r^8s\u0001")
public class CircleOnEdge
implements AreaOnConnectorShape {
    private final Ellipse2D.Double theShape;
    private ShapePaint shadowPaint;
    private final Point2 theShadowWidth;
    private final Point2 theShadowOff;
    private Color strokeColor;
    private ShapeStroke theStroke;
    private double theStrokeWidth;
    private ShapePaint fillPaint;
    private double theFillPercent;
    private Color theFillColor;
    private boolean plainFast;
    private GraphicEdge theEdge;
    private Connector theConnector;
    private final Point2 theCenter;
    private final Point2 theSize;
    private boolean fit;

    @Override
    public void configureForGroup(Backend bck, Style style, Camera camera) {
        AreaOnConnectorShape$class.configureForGroup(this, bck, style, camera);
    }

    @Override
    public void configureForElement(Backend bck, GraphicElement element, Skeleton skel, Camera camera) {
        AreaOnConnectorShape$class.configureForElement(this, bck, element, skel, camera);
    }

    @Override
    public ShapePaint shadowPaint() {
        return this.shadowPaint;
    }

    @Override
    public void shadowPaint_$eq(ShapePaint x$1) {
        this.shadowPaint = x$1;
    }

    @Override
    public Point2 theShadowWidth() {
        return this.theShadowWidth;
    }

    @Override
    public Point2 theShadowOff() {
        return this.theShadowOff;
    }

    @Override
    public void org$graphstream$ui$j2dviewer$renderer$shape$swing$Shadowable$_setter_$theShadowWidth_$eq(Point2 x$1) {
        this.theShadowWidth = x$1;
    }

    @Override
    public void org$graphstream$ui$j2dviewer$renderer$shape$swing$Shadowable$_setter_$theShadowOff_$eq(Point2 x$1) {
        this.theShadowOff = x$1;
    }

    @Override
    public void shadowWidth(double width, double height) {
        Shadowable$class.shadowWidth(this, width, height);
    }

    @Override
    public void shadowOffset(double xoff, double yoff) {
        Shadowable$class.shadowOffset(this, xoff, yoff);
    }

    @Override
    public void cast(Graphics2D g, Shape shape) {
        Shadowable$class.cast(this, g, shape);
    }

    @Override
    public void configureShadowableForGroup(Style style, Camera camera) {
        Shadowable$class.configureShadowableForGroup(this, style, camera);
    }

    @Override
    public Color strokeColor() {
        return this.strokeColor;
    }

    @Override
    public void strokeColor_$eq(Color x$1) {
        this.strokeColor = x$1;
    }

    @Override
    public ShapeStroke theStroke() {
        return this.theStroke;
    }

    @Override
    public void theStroke_$eq(ShapeStroke x$1) {
        this.theStroke = x$1;
    }

    @Override
    public double theStrokeWidth() {
        return this.theStrokeWidth;
    }

    @Override
    public void theStrokeWidth_$eq(double x$1) {
        this.theStrokeWidth = x$1;
    }

    @Override
    public void stroke(Graphics2D g, Shape shape) {
        Strokable$class.stroke(this, g, shape);
    }

    @Override
    public void configureStrokableForGroup(Style style, Camera camera) {
        Strokable$class.configureStrokableForGroup(this, style, camera);
    }

    @Override
    public ShapePaint fillPaint() {
        return this.fillPaint;
    }

    @Override
    public void fillPaint_$eq(ShapePaint x$1) {
        this.fillPaint = x$1;
    }

    @Override
    public double theFillPercent() {
        return this.theFillPercent;
    }

    @Override
    public void theFillPercent_$eq(double x$1) {
        this.theFillPercent = x$1;
    }

    @Override
    public Color theFillColor() {
        return this.theFillColor;
    }

    @Override
    public void theFillColor_$eq(Color x$1) {
        this.theFillColor = x$1;
    }

    @Override
    public boolean plainFast() {
        return this.plainFast;
    }

    @Override
    public void plainFast_$eq(boolean x$1) {
        this.plainFast = x$1;
    }

    @Override
    public void fill(Graphics2D g, double dynColor, Color optColor, Shape shape, Camera camera) {
        Fillable$class.fill(this, g, dynColor, optColor, shape, camera);
    }

    @Override
    public void fill(Graphics2D g, Shape shape, Camera camera) {
        Fillable$class.fill(this, g, shape, camera);
    }

    @Override
    public void configureFillableForGroup(Backend bck, Style style, Camera camera) {
        Fillable$class.configureFillableForGroup(this, bck, style, camera);
    }

    @Override
    public void configureFillableForElement(Style style, Camera camera, GraphicElement element) {
        Fillable$class.configureFillableForElement(this, style, camera, element);
    }

    @Override
    public GraphicEdge theEdge() {
        return this.theEdge;
    }

    @Override
    @TraitSetter
    public void theEdge_$eq(GraphicEdge x$1) {
        this.theEdge = x$1;
    }

    @Override
    public void configureAreaOnConnectorForGroup(Style style, Camera camera) {
        AreaOnConnector$class.configureAreaOnConnectorForGroup(this, style, camera);
    }

    @Override
    public void configureAreaOnConnectorForElement(GraphicEdge edge, Style style, Camera camera) {
        AreaOnConnector$class.configureAreaOnConnectorForElement(this, edge, style, camera);
    }

    @Override
    public Connector theConnector() {
        return this.theConnector;
    }

    @Override
    @TraitSetter
    public void theConnector_$eq(Connector x$1) {
        this.theConnector = x$1;
    }

    @Override
    public void theConnectorYoureAttachedTo(Connector connector) {
        OnConnector$class.theConnectorYoureAttachedTo(this, connector);
    }

    @Override
    public Point2 theCenter() {
        return this.theCenter;
    }

    @Override
    public Point2 theSize() {
        return this.theSize;
    }

    @Override
    public boolean fit() {
        return this.fit;
    }

    @Override
    @TraitSetter
    public void fit_$eq(boolean x$1) {
        this.fit = x$1;
    }

    @Override
    public void org$graphstream$ui$j2dviewer$renderer$shape$Area$_setter_$theCenter_$eq(Point2 x$1) {
        this.theCenter = x$1;
    }

    @Override
    public void org$graphstream$ui$j2dviewer$renderer$shape$Area$_setter_$theSize_$eq(Point2 x$1) {
        this.theSize = x$1;
    }

    @Override
    public void configureAreaForGroup(Style style, Camera camera) {
        Area$class.configureAreaForGroup(this, style, camera);
    }

    @Override
    public void configureAreaForElement(Backend backend, Camera camera, AreaSkeleton skel, GraphicElement element, ShapeDecor decor) {
        Area$class.configureAreaForElement(this, backend, camera, skel, element, decor);
    }

    public Ellipse2D.Double theShape() {
        return this.theShape;
    }

    @Override
    public void make(Backend bck, Camera camera) {
        this.make(false, camera);
    }

    @Override
    public void makeShadow(Backend bck, Camera camera) {
        this.make(true, camera);
    }

    public void make(boolean forShadow, Camera camera) {
        if (this.theConnector().skel().isCurve()) {
            this.makeOnCurve(forShadow, camera);
        } else {
            this.makeOnLine(forShadow, camera);
        }
    }

    public void makeOnLine(boolean forShadow, Camera camera) {
        double off = ShapeUtil$.MODULE$.evalTargetRadius2D(this.theEdge(), camera) + (this.theSize().x + this.theSize().y) / (double)4;
        Vector2 theDirection = new Vector2(this.theConnector().toPos().x - this.theConnector().fromPos().x, this.theConnector().toPos().y - this.theConnector().fromPos().y);
        theDirection.normalize();
        double x = this.theCenter().x - theDirection.x() * off;
        double y = this.theCenter().y - theDirection.y() * off;
        theDirection.scalarMult(this.theSize().x);
        if (forShadow) {
            x += this.theShadowOff().x;
            y += this.theShadowOff().y;
        }
        this.theShape().setFrame(x - this.theSize().x / (double)2, y - this.theSize().y / (double)2, this.theSize().x, this.theSize().y);
    }

    public void makeOnCurve(boolean forShadow, Camera camera) {
        Tuple2<Point2, Object> tuple2 = CubicCurve$.MODULE$.approxIntersectionPointOnCurve(this.theEdge(), this.theConnector(), camera);
        if (tuple2 != null) {
            Tuple2 tuple22;
            Point2 p1 = (Point2)tuple2._1();
            double t = tuple2._2$mcD$sp();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)p1, (Object)BoxesRunTime.boxToDouble((double)t));
            Point2 p12 = (Point2)tuple23._1();
            double t2 = tuple23._2$mcD$sp();
            StyleGroup style = this.theEdge().getStyle();
            Point3 p2 = CubicCurve$.MODULE$.eval(this.theConnector().fromPos(), this.theConnector().byPos1(), this.theConnector().byPos2(), this.theConnector().toPos(), t2 - (double)0.1f);
            Vector2 dir = new Vector2(p12.x - p2.x, p12.y - p2.y);
            dir.normalize();
            dir.scalarMult(this.theSize().x / (double)2);
            this.theShape().setFrame(p12.x - dir.x() - this.theSize().x / (double)2, p12.y - dir.y() - this.theSize().y / (double)2, this.theSize().x, this.theSize().y);
            return;
        }
        throw new MatchError(tuple2);
    }

    @Override
    public void renderShadow(Backend bck, Camera camera, GraphicElement element, Skeleton skel) {
        this.make(true, camera);
        this.cast(bck.graphics2D(), this.theShape());
    }

    @Override
    public void render(Backend bck, Camera camera, GraphicElement element, Skeleton skel) {
        Graphics2D g = bck.graphics2D();
        this.make(false, camera);
        this.stroke(g, this.theShape());
        this.fill(g, this.theShape(), camera);
    }

    public double lengthOfCurve(Connector c) {
        return (c.fromPos().distance(c.byPos1()) + c.byPos1().distance(c.byPos2()) + c.byPos2().distance(c.toPos())) * 0.75;
    }

    public CircleOnEdge() {
        Area$class.$init$(this);
        OnConnector$class.$init$(this);
        AreaOnConnector$class.$init$(this);
        Fillable$class.$init$(this);
        Strokable$class.$init$(this);
        Shadowable$class.$init$(this);
        AreaOnConnectorShape$class.$init$(this);
        this.theShape = new Ellipse2D.Double();
    }
}

