/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.syslog4j.impl.message.processor;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.graylog2.syslog4j.impl.message.processor.AbstractSyslogMessageProcessor;

public class SyslogMessageProcessor
extends AbstractSyslogMessageProcessor {
    private static final long serialVersionUID = -4232803978024990353L;
    private static final SyslogMessageProcessor INSTANCE;
    protected static SyslogMessageProcessor defaultInstance;

    public static void setDefault(SyslogMessageProcessor messageProcessor) {
        if (messageProcessor != null) {
            defaultInstance = messageProcessor;
        }
    }

    public static SyslogMessageProcessor getDefault() {
        return defaultInstance;
    }

    @Override
    public void appendTimestamp(StringBuffer buffer, Date datetime) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("MMM dd HH:mm:ss ", Locale.ENGLISH);
        String datePrefix = dateFormat.format(datetime);
        int pos = buffer.length() + 4;
        buffer.append(datePrefix);
        if (buffer.charAt(pos) == '0') {
            buffer.setCharAt(pos, ' ');
        }
    }

    @Override
    public String createSyslogHeader(int facility, int level, String localName, boolean sendLocalTimestamp, boolean sendLocalName) {
        StringBuffer buffer = new StringBuffer();
        this.appendPriority(buffer, facility, level);
        if (sendLocalTimestamp) {
            this.appendTimestamp(buffer, new Date());
        }
        if (sendLocalName) {
            this.appendLocalName(buffer, localName);
        }
        return buffer.toString();
    }

    @Override
    public String createSyslogHeader(int facility, int level, String localName, boolean sendLocalName, Date datetime) {
        StringBuffer buffer = new StringBuffer();
        this.appendPriority(buffer, facility, level);
        this.appendTimestamp(buffer, datetime);
        if (sendLocalName) {
            this.appendLocalName(buffer, localName);
        }
        return buffer.toString();
    }

    static {
        defaultInstance = INSTANCE = new SyslogMessageProcessor();
    }
}

