/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.syslog4j.impl.message.structured;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.graylog2.syslog4j.impl.message.AbstractSyslogMessage;
import org.graylog2.syslog4j.impl.message.structured.StructuredSyslogMessageIF;
import org.graylog2.syslog4j.util.Preconditions;

public class StructuredSyslogMessage
extends AbstractSyslogMessage
implements StructuredSyslogMessageIF {
    public static final String EMPTY_STRUCTURED_DATA_PREFIX = "- - ";
    public static final int EMPTY_STRUCTURED_DATA_PREFIX_LENGTH = "- - ".length();
    private String messageId;
    private Map<String, Map<String, String>> structuredData;
    private String message;
    private String procId;

    private StructuredSyslogMessage() {
        this.messageId = null;
        this.message = null;
        this.procId = null;
        this.structuredData = null;
    }

    public StructuredSyslogMessage(String messageId, String procId, Map<String, Map<String, String>> structuredData, String message) {
        this.messageId = messageId;
        this.procId = procId;
        this.structuredData = structuredData;
        this.message = message;
    }

    public static StructuredSyslogMessage fromString(String syslogMessageStr) {
        StructuredSyslogMessage syslogMessage = new StructuredSyslogMessage();
        syslogMessage.deserialize(syslogMessageStr);
        return syslogMessage;
    }

    private void deserialize(String stringMessage) {
        int start;
        if (stringMessage.startsWith(EMPTY_STRUCTURED_DATA_PREFIX)) {
            this.message = stringMessage.substring(EMPTY_STRUCTURED_DATA_PREFIX_LENGTH);
            return;
        }
        int end = -1;
        if (start <= 0) {
            throw new IllegalArgumentException("Invalid Syslog string format: " + stringMessage);
        }
        String syslogHeader = stringMessage.substring(0, stringMessage.indexOf(91));
        String[] tokens = syslogHeader.split(" ");
        if (tokens.length != 1) {
            throw new IllegalArgumentException("Invalid Syslog string format: " + stringMessage);
        }
        String string = this.messageId = "-".equals(tokens[0]) ? null : tokens[0];
        if (stringMessage.contains("[0@0]")) {
            this.structuredData = Collections.emptyMap();
            end = stringMessage.indexOf("[0@0]") + 4;
        } else {
            HashMap<String, Map<String, String>> structuredDataMap = new HashMap<String, Map<String, String>>();
            for (start = stringMessage.indexOf(91); start < stringMessage.length() && StructuredSyslogMessage.matchChar(stringMessage, start, '[') == start; ++start) {
                Preconditions.checkArgument(stringMessage.charAt(start) == '[', "Invalid structured data in syslog message '%s'", stringMessage);
                end = StructuredSyslogMessage.matchChar(stringMessage, start, ']');
                Preconditions.checkArgument(end != -1 && stringMessage.charAt(end) == ']', "Invalid structured data in syslog message '%s'", stringMessage);
                String key = null;
                HashMap<String, String> keyMap = new HashMap<String, String>();
                while (start < end) {
                    if (key == null) {
                        int keyEnd = StructuredSyslogMessage.matchChar(stringMessage, ++start, ']', ' ');
                        key = stringMessage.substring(start, keyEnd);
                        start = keyEnd;
                        continue;
                    }
                    Preconditions.checkArgument(start < stringMessage.length() && stringMessage.charAt(start) == ' ', "Invalid structured data in syslog message '%s'", stringMessage);
                    int equalsIndex = stringMessage.indexOf(61, ++start);
                    Preconditions.checkArgument(equalsIndex != -1, "Invalid structured data in syslog message '%s'", stringMessage);
                    Preconditions.checkArgument(stringMessage.charAt(equalsIndex + 1) == '\"', "Invalid structured data in syslog message '%s'", stringMessage);
                    int valueEnd = StructuredSyslogMessage.matchChar(stringMessage, equalsIndex + 2, '\"');
                    Preconditions.checkArgument(valueEnd != -1 && stringMessage.charAt(valueEnd) == '\"', "Invalid structured data in syslog message '%s'", stringMessage);
                    keyMap.put(stringMessage.substring(start, equalsIndex), this.unescape(stringMessage.substring(equalsIndex + 2, valueEnd)));
                    start = valueEnd + 1;
                }
                structuredDataMap.put(key, keyMap);
            }
            this.structuredData = structuredDataMap;
        }
        this.message = end + 2 <= stringMessage.length() ? stringMessage.substring(end + 2) : "";
    }

    public String getMessageId() {
        return this.messageId;
    }

    public Map<String, Map<String, String>> getStructuredData() {
        return this.structuredData;
    }

    public String getMessage() {
        return this.message;
    }

    public String getProcId() {
        return this.procId;
    }

    @Override
    public String createMessage() {
        return this.serialize();
    }

    private String serialize() {
        if (!StructuredSyslogMessage.checkIsPrintable(this.getMessageId())) {
            throw new IllegalArgumentException("Invalid message id: " + this.getMessageId());
        }
        StringBuffer sb = new StringBuffer();
        sb.append(StructuredSyslogMessage.nilProtect(this.getMessageId()));
        sb.append(' ');
        if (this.getStructuredData() == null || this.getStructuredData().size() == 0) {
            sb.append("[0@0]");
        } else {
            Set<Map.Entry<String, Map<String, String>>> sdEntrySet = this.getStructuredData().entrySet();
            for (Map.Entry<String, Map<String, String>> sdElement : sdEntrySet) {
                String sdId = sdElement.getKey();
                if (StringUtils.isBlank((CharSequence)sdId) || !StructuredSyslogMessage.checkIsPrintable(sdId)) {
                    throw new IllegalArgumentException("Illegal structured data id: " + sdId);
                }
                sb.append('[').append(sdId);
                Map<String, String> sdParams = sdElement.getValue();
                if (sdParams != null) {
                    Set<Map.Entry<String, String>> entrySet = sdParams.entrySet();
                    for (Map.Entry<String, String> entry : entrySet) {
                        String paramName = entry.getKey();
                        String paramValue = entry.getValue();
                        if (StringUtils.isBlank((CharSequence)paramName) || !StructuredSyslogMessage.checkIsPrintable(paramName)) {
                            throw new IllegalArgumentException("Illegal structured data parameter name: " + paramName);
                        }
                        if (paramValue == null) {
                            throw new IllegalArgumentException("Null structured data parameter value for parameter name: " + paramName);
                        }
                        sb.append(' ');
                        sb.append(paramName);
                        sb.append('=').append('\"');
                        StructuredSyslogMessage.sdEscape(sb, paramValue);
                        sb.append('\"');
                    }
                }
                sb.append(']');
            }
        }
        if (!StringUtils.isEmpty((CharSequence)this.getMessage())) {
            sb.append(' ');
            sb.append(StructuredSyslogMessage.nilProtect(this.getMessage()));
        }
        return sb.toString();
    }

    public static void sdEscape(StringBuffer sb, String value) {
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c == '\"' || c == '\\' || c == ']') {
                sb.append('\\');
            }
            sb.append(c);
        }
    }

    public static boolean checkIsPrintable(String value) {
        if (value == null) {
            return true;
        }
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c >= '!' && c <= '~') continue;
            return false;
        }
        return true;
    }

    public static String nilProtect(String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return "-";
        }
        return value;
    }

    public static int matchChar(String data, int start, char ... matchChars) {
        int ptr = start;
        while (ptr < data.length()) {
            if (data.charAt(ptr) == '\\') {
                ++ptr;
                ++ptr;
                continue;
            }
            if (ptr >= data.length()) {
                return -1;
            }
            for (int i = 0; i < matchChars.length; ++i) {
                if (data.charAt(ptr) != matchChars[i]) continue;
                return ptr;
            }
            ++ptr;
        }
        return -1;
    }

    private String unescape(String str) {
        if (str.indexOf(92) == -1) {
            return str;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) == '\\') continue;
            sb.append(str.charAt(i));
        }
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.message == null ? 0 : this.message.hashCode());
        result = 31 * result + (this.messageId == null ? 0 : this.messageId.hashCode());
        result = 31 * result + (this.structuredData == null ? 0 : this.structuredData.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StructuredSyslogMessage other = (StructuredSyslogMessage)obj;
        if (this.message == null ? other.message != null : !this.message.equals(other.message)) {
            return false;
        }
        if (this.messageId == null ? other.messageId != null : !this.messageId.equals(other.messageId)) {
            return false;
        }
        return !(this.structuredData == null ? other.structuredData != null : !this.structuredData.equals(other.structuredData));
    }

    public String toString() {
        return this.serialize();
    }
}

