/*
 * Decompiled with CFR 0.152.
 */
package org.grpcmock;

import io.grpc.HandlerRegistry;
import io.grpc.ServerBuilder;
import io.grpc.ServerInterceptor;
import java.io.File;
import java.io.IOException;
import java.net.ServerSocket;
import java.util.Objects;
import java.util.concurrent.Executor;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.grpcmock.DelegateHandlerRegistry;
import org.grpcmock.GrpcMock;
import org.grpcmock.exception.GrpcMockException;
import org.grpcmock.interceptors.RequestCaptureInterceptor;

public class GrpcMockBuilder {
    private final DelegateHandlerRegistry delegateHandlerRegistry = new DelegateHandlerRegistry();
    private final RequestCaptureInterceptor requestCaptureInterceptor = new RequestCaptureInterceptor();
    private final ServerBuilder serverBuilder;

    GrpcMockBuilder(@Nonnull ServerBuilder serverBuilder) {
        Objects.requireNonNull(serverBuilder);
        this.serverBuilder = serverBuilder.intercept((ServerInterceptor)this.requestCaptureInterceptor).fallbackHandlerRegistry((HandlerRegistry)this.delegateHandlerRegistry);
    }

    GrpcMockBuilder(int port) {
        this(ServerBuilder.forPort((int)(port <= 0 ? GrpcMockBuilder.findFreePort() : port)));
    }

    public GrpcMockBuilder interceptor(@Nonnull ServerInterceptor interceptor) {
        Objects.requireNonNull(interceptor);
        this.serverBuilder.intercept(interceptor);
        return this;
    }

    public GrpcMockBuilder executor(@Nullable Executor executor) {
        this.serverBuilder.executor(executor);
        return this;
    }

    public GrpcMockBuilder transportSecurity(@Nonnull File certChain, @Nonnull File privateKey) {
        Objects.requireNonNull(certChain);
        Objects.requireNonNull(privateKey);
        this.serverBuilder.useTransportSecurity(certChain, privateKey);
        return this;
    }

    private static int findFreePort() {
        int n;
        ServerSocket socket = new ServerSocket(0);
        try {
            n = socket.getLocalPort();
        }
        catch (Throwable throwable) {
            try {
                try {
                    socket.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new GrpcMockException("Failed finding a free port", e);
            }
        }
        socket.close();
        return n;
    }

    public GrpcMock build() {
        return new GrpcMock(this.serverBuilder.build(), this.delegateHandlerRegistry.getDelegate(), this.requestCaptureInterceptor);
    }
}

