/*
 * Decompiled with CFR 0.152.
 */
package org.grpcmock.definitions.stub;

import io.grpc.ServerServiceDefinition;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import org.grpcmock.definitions.stub.MethodStub;
import org.grpcmock.exception.GrpcMockException;

public final class ServiceStub {
    private final String serviceName;
    private final Map<String, MethodStub> methodStubs = new ConcurrentHashMap<String, MethodStub>();

    public ServiceStub(@Nonnull MethodStub<?, ?> methodStub) {
        Objects.requireNonNull(methodStub);
        Objects.requireNonNull(methodStub.serviceName());
        this.serviceName = methodStub.serviceName();
        this.methodStubs.put(methodStub.fullMethodName(), methodStub);
    }

    public ServerServiceDefinition serverServiceDefinition() {
        ServerServiceDefinition.Builder builder = ServerServiceDefinition.builder((String)this.serviceName);
        this.methodStubs.values().stream().map(MethodStub::serverMethodDefinition).forEach(arg_0 -> ((ServerServiceDefinition.Builder)builder).addMethod(arg_0));
        return builder.build();
    }

    public <ReqT, RespT> ServiceStub registerMethod(@Nonnull MethodStub<ReqT, RespT> methodStub) {
        Objects.requireNonNull(methodStub);
        if (!this.serviceName.equals(methodStub.serviceName())) {
            throw new GrpcMockException("Method is not part of the actual service descriptor");
        }
        this.methodStubs.compute(methodStub.fullMethodName(), (key, oldValue) -> Optional.ofNullable(oldValue).map(previous -> previous.registerScenarios(methodStub)).orElse(methodStub));
        return this;
    }
}

