/*
 * Decompiled with CFR 0.152.
 */
package org.grpcmock.definitions.verification;

import java.util.Objects;
import java.util.function.IntPredicate;
import javax.annotation.Nonnull;

public class CountMatcher
implements IntPredicate {
    private final String description;
    private final IntPredicate condition;

    public CountMatcher(@Nonnull String description, @Nonnull IntPredicate condition) {
        Objects.requireNonNull(description);
        Objects.requireNonNull(condition);
        this.description = description;
        this.condition = condition;
    }

    @Override
    public boolean test(int actual) {
        return this.condition.test(actual);
    }

    public String toString() {
        return this.description;
    }

    public static CountMatcher times(int count) {
        return new CountMatcher(String.format("exactly %d times", count), actual -> actual == count);
    }

    public static CountMatcher once() {
        return CountMatcher.times(1);
    }

    public static CountMatcher twice() {
        return CountMatcher.times(2);
    }

    public static CountMatcher never() {
        return new CountMatcher("never", actual -> actual <= 0);
    }

    public static CountMatcher atLeast(int count) {
        return new CountMatcher(String.format("at least %d times", count), actual -> actual >= count);
    }

    public static CountMatcher atMost(int count) {
        return new CountMatcher(String.format("at most %d times", count), actual -> actual <= count);
    }
}

