/*
 * Decompiled with CFR 0.152.
 */
package org.grpcmock;

import io.grpc.MethodDescriptor;
import io.grpc.Server;
import io.grpc.ServerBuilder;
import io.grpc.Status;
import io.grpc.inprocess.InProcessServerBuilder;
import io.grpc.inprocess.InProcessSocketAddress;
import io.grpc.util.MutableHandlerRegistry;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.grpcmock.GrpcMockBuilder;
import org.grpcmock.InProcessGrpcMockBuilder;
import org.grpcmock.definitions.response.ExceptionResponseActionBuilderImpl;
import org.grpcmock.definitions.response.ObjectResponseActionBuilderImpl;
import org.grpcmock.definitions.response.StreamResponseBuilderImpl;
import org.grpcmock.definitions.response.steps.ExceptionResponseActionBuilder;
import org.grpcmock.definitions.response.steps.ExceptionStreamResponseBuildersStep;
import org.grpcmock.definitions.response.steps.ObjectResponseActionBuilder;
import org.grpcmock.definitions.response.steps.ObjectStreamResponseBuilderStep;
import org.grpcmock.definitions.stub.BidiStreamingMethodStubBuilderImpl;
import org.grpcmock.definitions.stub.ClientStreamingMethodStubBuilderImpl;
import org.grpcmock.definitions.stub.MethodStub;
import org.grpcmock.definitions.stub.ServerStreamingMethodStubBuilderImpl;
import org.grpcmock.definitions.stub.ServiceStub;
import org.grpcmock.definitions.stub.UnaryMethodStubBuilderImpl;
import org.grpcmock.definitions.stub.steps.BidiStreamingMethodStubBuilderStep;
import org.grpcmock.definitions.stub.steps.ClientStreamingMethodStubBuilderStep;
import org.grpcmock.definitions.stub.steps.MethodStubBuilder;
import org.grpcmock.definitions.stub.steps.ServerStreamingMethodStubBuilderStep;
import org.grpcmock.definitions.stub.steps.UnaryMethodStubBuilderStep;
import org.grpcmock.definitions.verification.CountMatcher;
import org.grpcmock.definitions.verification.RequestPattern;
import org.grpcmock.definitions.verification.RequestPatternBuilderImpl;
import org.grpcmock.definitions.verification.steps.RequestPatternBuilderStep;
import org.grpcmock.exception.GrpcMockException;
import org.grpcmock.exception.GrpcMockVerificationError;
import org.grpcmock.interceptors.RequestCaptureInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GrpcMock {
    private static final Logger log = LoggerFactory.getLogger(GrpcMock.class);
    private static final ThreadLocal<GrpcMock> INSTANCE = ThreadLocal.withInitial(() -> GrpcMock.grpcMock().build());
    private final Server server;
    private final MutableHandlerRegistry handlerRegistry;
    private final RequestCaptureInterceptor requestCaptureInterceptor;
    private final Map<String, ServiceStub> serviceStubs = new ConcurrentHashMap<String, ServiceStub>();

    GrpcMock(@Nonnull Server server, @Nonnull MutableHandlerRegistry handlerRegistry, @Nonnull RequestCaptureInterceptor requestCaptureInterceptor) {
        Objects.requireNonNull(server);
        Objects.requireNonNull(handlerRegistry);
        Objects.requireNonNull(requestCaptureInterceptor);
        this.server = server;
        this.handlerRegistry = handlerRegistry;
        this.requestCaptureInterceptor = requestCaptureInterceptor;
    }

    public int getPort() {
        return this.server.getPort();
    }

    public String getInProcessName() {
        return this.server.getListenSockets().stream().filter(InProcessSocketAddress.class::isInstance).map(InProcessSocketAddress.class::cast).map(InProcessSocketAddress::getName).findFirst().orElseThrow(() -> new GrpcMockException("This gRPC Mock instance does not use in-process server"));
    }

    public GrpcMock start() {
        try {
            this.server.start();
        }
        catch (IllegalStateException e) {
            log.warn("gRPC Mock server is already started");
        }
        catch (IOException e) {
            throw new GrpcMockException("failed to start gRPC Mock server", e);
        }
        return this;
    }

    public GrpcMock stop() {
        this.server.shutdownNow();
        return this;
    }

    public <ReqT, RespT> void register(@Nonnull MethodStubBuilder<ReqT, RespT> methodStubBuilder) {
        Objects.requireNonNull(methodStubBuilder);
        MethodStub methodStub = methodStubBuilder.build();
        ServiceStub serviceStub = this.serviceStubs.compute(methodStub.serviceName(), (key, registeredStub) -> Optional.ofNullable(registeredStub).map(previous -> previous.registerMethod(methodStub)).orElseGet(() -> new ServiceStub(methodStub)));
        this.handlerRegistry.addService(serviceStub.serverServiceDefinition());
    }

    public <ReqT> void verifyThat(@Nonnull RequestPattern<ReqT> requestPattern, @Nonnull CountMatcher countMatcher) {
        Objects.requireNonNull(requestPattern);
        Objects.requireNonNull(countMatcher);
        int callCount = this.requestCaptureInterceptor.callCountFor(requestPattern);
        if (!countMatcher.test(callCount)) {
            throw new GrpcMockVerificationError(String.format("Expected %s method to be called %s, but actual call count was %d", requestPattern.fullMethodName(), countMatcher, callCount));
        }
    }

    public void resetAll() {
        this.serviceStubs.clear();
        this.requestCaptureInterceptor.clear();
        this.handlerRegistry.getServices().forEach(arg_0 -> ((MutableHandlerRegistry)this.handlerRegistry).removeService(arg_0));
    }

    public static GrpcMockBuilder grpcMock() {
        return GrpcMock.grpcMock(0);
    }

    public static GrpcMockBuilder grpcMock(int port) {
        return new GrpcMockBuilder(port);
    }

    public static InProcessGrpcMockBuilder inProcessGrpcMock(@Nonnull String name) {
        return new InProcessGrpcMockBuilder(name);
    }

    public static InProcessGrpcMockBuilder inProcessGrpcMock() {
        return new InProcessGrpcMockBuilder(InProcessServerBuilder.generateName());
    }

    public static GrpcMockBuilder grpcMock(@Nonnull ServerBuilder serverBuilder) {
        return new GrpcMockBuilder(serverBuilder);
    }

    public static void configureFor(int port) {
        INSTANCE.set(GrpcMock.grpcMock(port).build());
    }

    public static void configureFor(@Nonnull GrpcMock client) {
        Objects.requireNonNull(client);
        INSTANCE.set(client);
    }

    public static int getGlobalPort() {
        return INSTANCE.get().getPort();
    }

    public static String getGlobalInProcessName() {
        return INSTANCE.get().getInProcessName();
    }

    public static void resetMappings() {
        INSTANCE.get().resetAll();
    }

    public static <ReqT, RespT> void stubFor(MethodStubBuilder<ReqT, RespT> methodStubBuilder) {
        INSTANCE.get().register(methodStubBuilder);
    }

    public static <ReqT, RespT> UnaryMethodStubBuilderStep<ReqT, RespT> unaryMethod(@Nonnull MethodDescriptor<ReqT, RespT> method) {
        return new UnaryMethodStubBuilderImpl<ReqT, RespT>(method);
    }

    public static <ReqT, RespT> ServerStreamingMethodStubBuilderStep<ReqT, RespT> serverStreamingMethod(@Nonnull MethodDescriptor<ReqT, RespT> method) {
        return new ServerStreamingMethodStubBuilderImpl<ReqT, RespT>(method);
    }

    public static <ReqT, RespT> ClientStreamingMethodStubBuilderStep<ReqT, RespT> clientStreamingMethod(@Nonnull MethodDescriptor<ReqT, RespT> method) {
        return new ClientStreamingMethodStubBuilderImpl<ReqT, RespT>(method);
    }

    public static <ReqT, RespT> BidiStreamingMethodStubBuilderStep<ReqT, RespT> bidiStreamingMethod(@Nonnull MethodDescriptor<ReqT, RespT> method) {
        return new BidiStreamingMethodStubBuilderImpl<ReqT, RespT>(method);
    }

    public static <RespT> ObjectResponseActionBuilder<RespT> response(@Nonnull RespT responseObject) {
        return new ObjectResponseActionBuilderImpl<RespT>(responseObject);
    }

    public static ExceptionResponseActionBuilder exception(@Nonnull Throwable exception) {
        return new ExceptionResponseActionBuilderImpl(exception);
    }

    public static ExceptionResponseActionBuilder statusException(@Nonnull Status status) {
        return new ExceptionResponseActionBuilderImpl(status);
    }

    public static <RespT> ObjectStreamResponseBuilderStep<RespT> stream(@Nonnull ObjectResponseActionBuilder<RespT> responseAction) {
        Objects.requireNonNull(responseAction);
        return new StreamResponseBuilderImpl<RespT>(responseAction.build());
    }

    public static <RespT> ObjectStreamResponseBuilderStep<RespT> stream(@Nonnull List<RespT> responses) {
        Objects.requireNonNull(responses);
        responses.forEach(Objects::requireNonNull);
        return new StreamResponseBuilderImpl(responses.stream().map(GrpcMock::response).map(ObjectResponseActionBuilder::build).collect(Collectors.toList()));
    }

    public static <RespT> ObjectStreamResponseBuilderStep<RespT> stream(RespT ... responses) {
        return GrpcMock.stream(Arrays.asList(responses));
    }

    public static <RespT> ExceptionStreamResponseBuildersStep<RespT> stream(@Nonnull ExceptionResponseActionBuilder responseAction) {
        Objects.requireNonNull(responseAction);
        return new StreamResponseBuilderImpl(responseAction.build());
    }

    public static <ReqT> void verifyThat(@Nonnull MethodDescriptor<ReqT, ?> method) {
        GrpcMock.verifyThat(GrpcMock.calledMethod(method), GrpcMock.times(1));
    }

    public static <ReqT> void verifyThat(@Nonnull RequestPatternBuilderStep<ReqT> requestPattern) {
        GrpcMock.verifyThat(requestPattern, GrpcMock.times(1));
    }

    public static <ReqT> void verifyThat(@Nonnull MethodDescriptor<ReqT, ?> method, @Nonnull CountMatcher countMatcher) {
        GrpcMock.verifyThat(GrpcMock.calledMethod(method), countMatcher);
    }

    public static <ReqT> void verifyThat(@Nonnull RequestPatternBuilderStep<ReqT> requestPattern, @Nonnull CountMatcher countMatcher) {
        Objects.requireNonNull(requestPattern);
        INSTANCE.get().verifyThat(requestPattern.build(), countMatcher);
    }

    public static <ReqT> RequestPatternBuilderStep<ReqT> calledMethod(@Nonnull MethodDescriptor<ReqT, ?> method) {
        return new RequestPatternBuilderImpl<ReqT>(method);
    }

    public static CountMatcher times(int count) {
        return CountMatcher.times(count);
    }

    public static CountMatcher never() {
        return CountMatcher.never();
    }

    public static CountMatcher atLeast(int count) {
        return CountMatcher.atLeast(count);
    }

    public static CountMatcher atMost(int count) {
        return CountMatcher.atMost(count);
    }
}

